/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.math.ColorRGBA;
import com.jme3.opencl.AbstractOpenCLObject;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Event;
import com.jme3.opencl.MappingAccess;
import com.jme3.opencl.OpenCLObject;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class Image
extends AbstractOpenCLObject {
    protected Image(OpenCLObject.ObjectReleaser releaser) {
        super(releaser);
    }

    @Override
    public Image register() {
        super.register();
        return this;
    }

    public abstract long getWidth();

    public abstract long getHeight();

    public abstract long getDepth();

    public abstract long getRowPitch();

    public abstract long getSlicePitch();

    public abstract long getArraySize();

    public abstract ImageFormat getImageFormat();

    public abstract ImageType getImageType();

    public abstract int getElementSize();

    public abstract void readImage(CommandQueue var1, ByteBuffer var2, long[] var3, long[] var4, long var5, long var7);

    public abstract Event readImageAsync(CommandQueue var1, ByteBuffer var2, long[] var3, long[] var4, long var5, long var7);

    public abstract void writeImage(CommandQueue var1, ByteBuffer var2, long[] var3, long[] var4, long var5, long var7);

    public abstract Event writeImageAsync(CommandQueue var1, ByteBuffer var2, long[] var3, long[] var4, long var5, long var7);

    public abstract void copyTo(CommandQueue var1, Image var2, long[] var3, long[] var4, long[] var5);

    public abstract Event copyToAsync(CommandQueue var1, Image var2, long[] var3, long[] var4, long[] var5);

    public abstract ImageMapping map(CommandQueue var1, long[] var2, long[] var3, MappingAccess var4);

    public abstract ImageMapping mapAsync(CommandQueue var1, long[] var2, long[] var3, MappingAccess var4);

    public abstract void unmap(CommandQueue var1, ImageMapping var2);

    public abstract Event fillAsync(CommandQueue var1, long[] var2, long[] var3, ColorRGBA var4);

    public abstract Event fillAsync(CommandQueue var1, long[] var2, long[] var3, int[] var4);

    public abstract Event copyToBufferAsync(CommandQueue var1, Buffer var2, long[] var3, long[] var4, long var5);

    public abstract Event acquireImageForSharingAsync(CommandQueue var1);

    public void acquireImageForSharingNoEvent(CommandQueue queue) {
        this.acquireImageForSharingAsync(queue).release();
    }

    public abstract Event releaseImageForSharingAsync(CommandQueue var1);

    public void releaseImageForSharingNoEvent(CommandQueue queue) {
        this.releaseImageForSharingAsync(queue).release();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Image (");
        ImageType t = this.getImageType();
        str.append((Object)t);
        str.append(", w=").append(this.getWidth());
        if (t == ImageType.IMAGE_2D || t == ImageType.IMAGE_3D) {
            str.append(", h=").append(this.getHeight());
        }
        if (t == ImageType.IMAGE_3D) {
            str.append(", d=").append(this.getDepth());
        }
        if (t == ImageType.IMAGE_1D_ARRAY || t == ImageType.IMAGE_2D_ARRAY) {
            str.append(", arrays=").append(this.getArraySize());
        }
        str.append(", ").append(this.getImageFormat());
        str.append(')');
        return str.toString();
    }

    public static enum ImageType {
        IMAGE_1D,
        IMAGE_1D_BUFFER,
        IMAGE_2D,
        IMAGE_3D,
        IMAGE_1D_ARRAY,
        IMAGE_2D_ARRAY;

    }

    public static class ImageFormat {
        public ImageChannelOrder channelOrder;
        public ImageChannelType channelType;

        public ImageFormat() {
        }

        public ImageFormat(ImageChannelOrder channelOrder, ImageChannelType channelType) {
            this.channelOrder = channelOrder;
            this.channelType = channelType;
        }

        public String toString() {
            return "ImageFormat{channelOrder=" + (Object)((Object)this.channelOrder) + ", channelType=" + (Object)((Object)this.channelType) + '}';
        }

        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + Objects.hashCode((Object)this.channelOrder);
            hash = 61 * hash + Objects.hashCode((Object)this.channelType);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImageFormat other = (ImageFormat)obj;
            if (this.channelOrder != other.channelOrder) {
                return false;
            }
            return this.channelType == other.channelType;
        }
    }

    public static class ImageMapping {
        public final ByteBuffer buffer;
        public final long rowPitch;
        public final long slicePitch;
        public final Event event;

        public ImageMapping(ByteBuffer buffer, long rowPitch, long slicePitch, Event event) {
            this.buffer = buffer;
            this.rowPitch = rowPitch;
            this.slicePitch = slicePitch;
            this.event = event;
        }

        public ImageMapping(ByteBuffer buffer, long rowPitch, long slicePitch) {
            this.buffer = buffer;
            this.rowPitch = rowPitch;
            this.slicePitch = slicePitch;
            this.event = null;
        }
    }

    public static class ImageDescriptor {
        public ImageType type;
        public long width;
        public long height;
        public long depth;
        public long arraySize;
        public long rowPitch;
        public long slicePitch;
        public ByteBuffer hostPtr;

        public ImageDescriptor() {
        }

        public ImageDescriptor(ImageType type2, long width2, long height2, long depth, long arraySize, long rowPitch, long slicePitch, ByteBuffer hostPtr) {
            this.type = type2;
            this.width = width2;
            this.height = height2;
            this.depth = depth;
            this.arraySize = arraySize;
            this.rowPitch = rowPitch;
            this.slicePitch = slicePitch;
            this.hostPtr = hostPtr;
        }

        public ImageDescriptor(ImageType type2, long width2, long height2, long depth, long arraySize) {
            this.type = type2;
            this.width = width2;
            this.height = height2;
            this.depth = depth;
            this.arraySize = arraySize;
            this.rowPitch = 0L;
            this.slicePitch = 0L;
            this.hostPtr = null;
        }

        public String toString() {
            return "ImageDescriptor{type=" + (Object)((Object)this.type) + ", width=" + this.width + ", height=" + this.height + ", depth=" + this.depth + ", arraySize=" + this.arraySize + ", rowPitch=" + this.rowPitch + ", slicePitch=" + this.slicePitch + '}';
        }
    }

    public static enum ImageChannelOrder {
        R,
        Rx,
        A,
        INTENSITY,
        LUMINANCE,
        RG,
        RGx,
        RA,
        RGB,
        RGBx,
        RGBA,
        ARGB,
        BGRA;

    }

    public static enum ImageChannelType {
        SNORM_INT8,
        SNORM_INT16,
        UNORM_INT8,
        UNORM_INT16,
        UNORM_SHORT_565,
        UNORM_SHORT_555,
        UNORM_INT_101010,
        SIGNED_INT8,
        SIGNED_INT16,
        SIGNED_INT32,
        UNSIGNED_INT8,
        UNSIGNED_INT16,
        UNSIGNED_INT32,
        HALF_FLOAT,
        FLOAT;

    }
}

