/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.opencl.Device;
import com.jme3.opencl.Platform;
import com.jme3.opencl.PlatformChooser;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DefaultPlatformChooser
implements PlatformChooser {
    private static final Logger LOG = Logger.getLogger(DefaultPlatformChooser.class.getName());

    @Override
    public List<? extends Device> chooseDevices(List<? extends Platform> platforms) {
        ArrayList<Device> result2 = new ArrayList<Device>();
        for (Platform platform : platforms) {
            if (!platform.hasOpenGLInterop()) continue;
            for (Device device2 : platform.getDevices()) {
                if (!device2.hasOpenGLInterop() || device2.getDeviceType() != Device.DeviceType.GPU) continue;
                result2.add(device2);
            }
            if (result2.isEmpty()) continue;
            return result2;
        }
        for (Platform platform : platforms) {
            if (!platform.hasOpenGLInterop()) continue;
            for (Device device3 : platform.getDevices()) {
                if (!device3.hasOpenGLInterop()) continue;
                result2.add(device3);
            }
            if (result2.isEmpty()) continue;
            return result2;
        }
        LOG.warning("No device with OpenCL-OpenGL-interop found, try without");
        for (Platform platform : platforms) {
            for (Device device4 : platform.getDevices()) {
                result2.add(device4);
            }
            if (result2.isEmpty()) continue;
            return result2;
        }
        return result2;
    }
}

