/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.opencl.AbstractOpenCLObject;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.Image;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Context
extends AbstractOpenCLObject {
    private static final Logger LOG = Logger.getLogger(Context.class.getName());

    protected Context(OpenCLObject.ObjectReleaser releaser) {
        super(releaser);
    }

    @Override
    public Context register() {
        super.register();
        return this;
    }

    public abstract List<? extends Device> getDevices();

    public CommandQueue createQueue() {
        return this.createQueue(this.getDevices().get(0));
    }

    public abstract CommandQueue createQueue(Device var1);

    public abstract Buffer createBuffer(long var1, MemoryAccess var3);

    public Buffer createBuffer(long size2) {
        return this.createBuffer(size2, MemoryAccess.READ_WRITE);
    }

    public abstract Buffer createBufferFromHost(ByteBuffer var1, MemoryAccess var2);

    public Buffer createBufferFromHost(ByteBuffer data2) {
        return this.createBufferFromHost(data2, MemoryAccess.READ_WRITE);
    }

    public abstract Image createImage(MemoryAccess var1, Image.ImageFormat var2, Image.ImageDescriptor var3);

    public abstract Image.ImageFormat[] querySupportedFormats(MemoryAccess var1, Image.ImageType var2);

    public abstract Buffer bindVertexBuffer(VertexBuffer var1, MemoryAccess var2);

    public abstract Image bindImage(com.jme3.texture.Image var1, Texture.Type var2, int var3, MemoryAccess var4);

    public Image bindImage(Texture texture, int miplevel, MemoryAccess access) {
        return this.bindImage(texture.getImage(), texture.getType(), miplevel, access);
    }

    public Image bindImage(Texture texture, MemoryAccess access) {
        return this.bindImage(texture, 0, access);
    }

    public Image bindRenderBuffer(FrameBuffer.RenderBuffer buffer, MemoryAccess access) {
        if (buffer.getTexture() == null) {
            return this.bindPureRenderBuffer(buffer, access);
        }
        return this.bindImage(buffer.getTexture(), access);
    }

    protected abstract Image bindPureRenderBuffer(FrameBuffer.RenderBuffer var1, MemoryAccess var2);

    public abstract Program createProgramFromSourceCode(String var1);

    public Program createProgramFromSourceCodeWithDependencies(String sourceCode, AssetManager assetManager2) {
        StringBuilder builder = new StringBuilder(sourceCode.length());
        BufferedReader reader = new BufferedReader(new StringReader(sourceCode));
        try {
            this.buildSourcesRec(reader, builder, assetManager2);
        }
        catch (IOException ex) {
            throw new AssetNotFoundException("Unable to read a dependency file", ex);
        }
        return this.createProgramFromSourceCode(builder.toString());
    }

    private void buildSourcesRec(BufferedReader reader, StringBuilder builder, AssetManager assetManager2) throws IOException {
        String ln;
        while ((ln = reader.readLine()) != null) {
            if (ln.trim().startsWith("#import ")) {
                AssetInfo info2;
                if ((ln = ln.trim().substring(8).trim()).startsWith("\"")) {
                    ln = ln.substring(1);
                }
                if (ln.endsWith("\"")) {
                    ln = ln.substring(0, ln.length() - 1);
                }
                if ((info2 = assetManager2.locateAsset(new AssetKey(ln))) == null) {
                    throw new AssetNotFoundException("Unable to load source file \"" + ln + "\"");
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(info2.openStream()));
                try {
                    builder.append("//-- begin import ").append(ln).append(" --\n");
                    this.buildSourcesRec(r, builder, assetManager2);
                    builder.append("//-- end import ").append(ln).append(" --\n");
                    continue;
                }
                finally {
                    r.close();
                    continue;
                }
            }
            builder.append(ln).append('\n');
        }
    }

    public Program createProgramFromSourceFilesWithInclude(AssetManager assetManager2, String include, String ... resources) {
        return this.createProgramFromSourceFilesWithInclude(assetManager2, include, Arrays.asList(resources));
    }

    public Program createProgramFromSourceFilesWithInclude(AssetManager assetManager2, String include, List<String> resources) {
        StringBuilder str = new StringBuilder();
        str.append(include);
        for (String res : resources) {
            AssetInfo info2 = assetManager2.locateAsset(new AssetKey(res));
            if (info2 == null) {
                throw new AssetNotFoundException("Unable to load source file \"" + res + "\"");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(info2.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    str.append(line).append('\n');
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "unable to load source file '" + res + "'", ex);
            }
        }
        return this.createProgramFromSourceCodeWithDependencies(str.toString(), assetManager2);
    }

    public Program createProgramFromSourceFiles(AssetManager assetManager2, String ... resources) {
        return this.createProgramFromSourceFilesWithInclude(assetManager2, "", resources);
    }

    public Program createProgramFromSourceFiles(AssetManager assetManager2, List<String> resources) {
        return this.createProgramFromSourceFilesWithInclude(assetManager2, "", resources);
    }

    public abstract Program createProgramFromBinary(ByteBuffer var1, Device var2);

    public String toString() {
        return "Context (" + this.getDevices() + ')';
    }
}

