/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.opencl.AbstractOpenCLObject;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.MappingAccess;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import java.nio.ByteBuffer;

public abstract class Buffer
extends AbstractOpenCLObject {
    protected Buffer(OpenCLObject.ObjectReleaser releaser) {
        super(releaser);
    }

    @Override
    public Buffer register() {
        super.register();
        return this;
    }

    public abstract long getSize();

    public abstract MemoryAccess getMemoryAccessFlags();

    public abstract void read(CommandQueue var1, ByteBuffer var2, long var3, long var5);

    public void read(CommandQueue queue, ByteBuffer dest, long size2) {
        this.read(queue, dest, size2, 0L);
    }

    public void read(CommandQueue queue, ByteBuffer dest) {
        this.read(queue, dest, this.getSize());
    }

    public abstract Event readAsync(CommandQueue var1, ByteBuffer var2, long var3, long var5);

    public Event readAsync(CommandQueue queue, ByteBuffer dest, long size2) {
        return this.readAsync(queue, dest, size2, 0L);
    }

    public Event readAsync(CommandQueue queue, ByteBuffer dest) {
        return this.readAsync(queue, dest, this.getSize());
    }

    public abstract void write(CommandQueue var1, ByteBuffer var2, long var3, long var5);

    public void write(CommandQueue queue, ByteBuffer src, long size2) {
        this.write(queue, src, size2, 0L);
    }

    public void write(CommandQueue queue, ByteBuffer src) {
        this.write(queue, src, this.getSize());
    }

    public abstract Event writeAsync(CommandQueue var1, ByteBuffer var2, long var3, long var5);

    public Event writeAsync(CommandQueue queue, ByteBuffer src, long size2) {
        return this.writeAsync(queue, src, size2, 0L);
    }

    public Event writeAsync(CommandQueue queue, ByteBuffer src) {
        return this.writeAsync(queue, src, this.getSize());
    }

    public abstract void copyTo(CommandQueue var1, Buffer var2, long var3, long var5, long var7);

    public void copyTo(CommandQueue queue, Buffer dest, long size2) {
        this.copyTo(queue, dest, size2, 0L, 0L);
    }

    public void copyTo(CommandQueue queue, Buffer dest) {
        this.copyTo(queue, dest, this.getSize());
    }

    public abstract Event copyToAsync(CommandQueue var1, Buffer var2, long var3, long var5, long var7);

    public Event copyToAsync(CommandQueue queue, Buffer dest, long size2) {
        return this.copyToAsync(queue, dest, size2, 0L, 0L);
    }

    public Event copyToAsync(CommandQueue queue, Buffer dest) {
        return this.copyToAsync(queue, dest, this.getSize());
    }

    public abstract ByteBuffer map(CommandQueue var1, long var2, long var4, MappingAccess var6);

    public ByteBuffer map(CommandQueue queue, long size2, MappingAccess access) {
        return this.map(queue, size2, 0L, access);
    }

    public ByteBuffer map(CommandQueue queue, MappingAccess access) {
        return this.map(queue, this.getSize(), access);
    }

    public abstract void unmap(CommandQueue var1, ByteBuffer var2);

    public abstract AsyncMapping mapAsync(CommandQueue var1, long var2, long var4, MappingAccess var6);

    public AsyncMapping mapAsync(CommandQueue queue, long size2, MappingAccess access) {
        return this.mapAsync(queue, size2, 0L, access);
    }

    public AsyncMapping mapAsync(CommandQueue queue, MappingAccess access) {
        return this.mapAsync(queue, this.getSize(), 0L, access);
    }

    public abstract Event fillAsync(CommandQueue var1, ByteBuffer var2, long var3, long var5);

    public abstract Event copyToImageAsync(CommandQueue var1, Image var2, long var3, long[] var5, long[] var6);

    public abstract Event acquireBufferForSharingAsync(CommandQueue var1);

    public void acquireBufferForSharingNoEvent(CommandQueue queue) {
        this.acquireBufferForSharingAsync(queue).release();
    }

    public abstract Event releaseBufferForSharingAsync(CommandQueue var1);

    public void releaseBufferForSharingNoEvent(CommandQueue queue) {
        this.releaseBufferForSharingAsync(queue).release();
    }

    public String toString() {
        return "Buffer (" + this.getSize() + "B)";
    }

    public static class AsyncMapping {
        public final Event event;
        public final ByteBuffer buffer;

        public AsyncMapping(Event event, ByteBuffer buffer) {
            this.event = event;
            this.buffer = buffer;
        }

        public Event getEvent() {
            return this.event;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }
    }
}

