/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public final class Matrix3f
implements Savable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Matrix3f.class.getName());
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m20;
    protected float m21;
    protected float m22;
    public static final Matrix3f ZERO = new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = new Matrix3f();

    public Matrix3f() {
        this.loadIdentity();
    }

    public Matrix3f(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3f(Matrix3f mat) {
        this.set(mat);
    }

    public void absoluteLocal() {
        this.m00 = FastMath.abs(this.m00);
        this.m01 = FastMath.abs(this.m01);
        this.m02 = FastMath.abs(this.m02);
        this.m10 = FastMath.abs(this.m10);
        this.m11 = FastMath.abs(this.m11);
        this.m12 = FastMath.abs(this.m12);
        this.m20 = FastMath.abs(this.m20);
        this.m21 = FastMath.abs(this.m21);
        this.m22 = FastMath.abs(this.m22);
    }

    public Matrix3f set(Matrix3f matrix) {
        if (null == matrix) {
            this.loadIdentity();
        } else {
            this.m00 = matrix.m00;
            this.m01 = matrix.m01;
            this.m02 = matrix.m02;
            this.m10 = matrix.m10;
            this.m11 = matrix.m11;
            this.m12 = matrix.m12;
            this.m20 = matrix.m20;
            this.m21 = matrix.m21;
            this.m22 = matrix.m22;
        }
        return this;
    }

    public float get(int i, int j) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
            }
            case 1: {
                switch (j) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
            }
            case 2: {
                switch (j) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public void get(float[] data2, boolean rowMajor) {
        if (data2.length == 9) {
            if (rowMajor) {
                data2[0] = this.m00;
                data2[1] = this.m01;
                data2[2] = this.m02;
                data2[3] = this.m10;
                data2[4] = this.m11;
                data2[5] = this.m12;
                data2[6] = this.m20;
                data2[7] = this.m21;
                data2[8] = this.m22;
            } else {
                data2[0] = this.m00;
                data2[1] = this.m10;
                data2[2] = this.m20;
                data2[3] = this.m01;
                data2[4] = this.m11;
                data2[5] = this.m21;
                data2[6] = this.m02;
                data2[7] = this.m12;
                data2[8] = this.m22;
            }
        } else if (data2.length == 16) {
            if (rowMajor) {
                data2[0] = this.m00;
                data2[1] = this.m01;
                data2[2] = this.m02;
                data2[4] = this.m10;
                data2[5] = this.m11;
                data2[6] = this.m12;
                data2[8] = this.m20;
                data2[9] = this.m21;
                data2[10] = this.m22;
            } else {
                data2[0] = this.m00;
                data2[1] = this.m10;
                data2[2] = this.m20;
                data2[4] = this.m01;
                data2[5] = this.m11;
                data2[6] = this.m21;
                data2[8] = this.m02;
                data2[9] = this.m12;
                data2[10] = this.m22;
            }
        } else {
            throw new IndexOutOfBoundsException("Array size must be 9 or 16 in Matrix3f.get().");
        }
    }

    public Matrix3f normalize(Matrix3f store) {
        if (store == null) {
            store = new Matrix3f();
        }
        float mag = 1.0f / FastMath.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
        store.m00 = this.m00 * mag;
        store.m10 = this.m10 * mag;
        store.m20 = this.m20 * mag;
        mag = 1.0f / FastMath.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
        store.m01 = this.m01 * mag;
        store.m11 = this.m11 * mag;
        store.m21 = this.m21 * mag;
        store.m02 = store.m10 * store.m21 - store.m11 * store.m20;
        store.m12 = store.m01 * store.m20 - store.m00 * store.m21;
        store.m22 = store.m00 * store.m11 - store.m01 * store.m10;
        return store;
    }

    public Matrix3f normalizeLocal() {
        return this.normalize(this);
    }

    public Vector3f getColumn(int i) {
        return this.getColumn(i, null);
    }

    public Vector3f getColumn(int i, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        switch (i) {
            case 0: {
                store.x = this.m00;
                store.y = this.m10;
                store.z = this.m20;
                break;
            }
            case 1: {
                store.x = this.m01;
                store.y = this.m11;
                store.z = this.m21;
                break;
            }
            case 2: {
                store.x = this.m02;
                store.y = this.m12;
                store.z = this.m22;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + i);
            }
        }
        return store;
    }

    public Vector3f getRow(int i) {
        return this.getRow(i, null);
    }

    public Vector3f getRow(int i, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        switch (i) {
            case 0: {
                store.x = this.m00;
                store.y = this.m01;
                store.z = this.m02;
                break;
            }
            case 1: {
                store.x = this.m10;
                store.y = this.m11;
                store.z = this.m12;
                break;
            }
            case 2: {
                store.x = this.m20;
                store.y = this.m21;
                store.z = this.m22;
                break;
            }
            default: {
                logger.warning("Invalid row index.");
                throw new IllegalArgumentException("Invalid row index. " + i);
            }
        }
        return store;
    }

    public FloatBuffer toFloatBuffer() {
        FloatBuffer fb = BufferUtils.createFloatBuffer(9);
        fb.put(this.m00).put(this.m01).put(this.m02);
        fb.put(this.m10).put(this.m11).put(this.m12);
        fb.put(this.m20).put(this.m21).put(this.m22);
        fb.rewind();
        return fb;
    }

    public FloatBuffer fillFloatBuffer(FloatBuffer fb, boolean columnMajor) {
        TempVars vars = TempVars.get();
        this.fillFloatArray(vars.matrixWrite, columnMajor);
        fb.put(vars.matrixWrite, 0, 9);
        vars.release();
        return fb;
    }

    public void fillFloatArray(float[] f, boolean columnMajor) {
        if (columnMajor) {
            f[0] = this.m00;
            f[1] = this.m10;
            f[2] = this.m20;
            f[3] = this.m01;
            f[4] = this.m11;
            f[5] = this.m21;
            f[6] = this.m02;
            f[7] = this.m12;
            f[8] = this.m22;
        } else {
            f[0] = this.m00;
            f[1] = this.m01;
            f[2] = this.m02;
            f[3] = this.m10;
            f[4] = this.m11;
            f[5] = this.m12;
            f[6] = this.m20;
            f[7] = this.m21;
            f[8] = this.m22;
        }
    }

    public Matrix3f setColumn(int i, Vector3f column) {
        if (column == null) {
            logger.warning("Column is null. Ignoring.");
            return this;
        }
        switch (i) {
            case 0: {
                this.m00 = column.x;
                this.m10 = column.y;
                this.m20 = column.z;
                break;
            }
            case 1: {
                this.m01 = column.x;
                this.m11 = column.y;
                this.m21 = column.z;
                break;
            }
            case 2: {
                this.m02 = column.x;
                this.m12 = column.y;
                this.m22 = column.z;
                break;
            }
            default: {
                logger.warning("Invalid column index.");
                throw new IllegalArgumentException("Invalid column index. " + i);
            }
        }
        return this;
    }

    public Matrix3f setRow(int i, Vector3f row) {
        if (row == null) {
            logger.warning("Row is null. Ignoring.");
            return this;
        }
        switch (i) {
            case 0: {
                this.m00 = row.x;
                this.m01 = row.y;
                this.m02 = row.z;
                break;
            }
            case 1: {
                this.m10 = row.x;
                this.m11 = row.y;
                this.m12 = row.z;
                break;
            }
            case 2: {
                this.m20 = row.x;
                this.m21 = row.y;
                this.m22 = row.z;
                break;
            }
            default: {
                logger.warning("Invalid row index.");
                throw new IllegalArgumentException("Invalid row index. " + i);
            }
        }
        return this;
    }

    public Matrix3f set(int i, int j, float value) {
        switch (i) {
            case 0: {
                switch (j) {
                    case 0: {
                        this.m00 = value;
                        return this;
                    }
                    case 1: {
                        this.m01 = value;
                        return this;
                    }
                    case 2: {
                        this.m02 = value;
                        return this;
                    }
                }
            }
            case 1: {
                switch (j) {
                    case 0: {
                        this.m10 = value;
                        return this;
                    }
                    case 1: {
                        this.m11 = value;
                        return this;
                    }
                    case 2: {
                        this.m12 = value;
                        return this;
                    }
                }
            }
            case 2: {
                switch (j) {
                    case 0: {
                        this.m20 = value;
                        return this;
                    }
                    case 1: {
                        this.m21 = value;
                        return this;
                    }
                    case 2: {
                        this.m22 = value;
                        return this;
                    }
                }
            }
        }
        logger.warning("Invalid matrix index.");
        throw new IllegalArgumentException("Invalid indices into matrix.");
    }

    public Matrix3f set(float[][] matrix) {
        if (matrix.length != 3 || matrix[0].length != 3) {
            throw new IllegalArgumentException("Array must be of size 9.");
        }
        this.m00 = matrix[0][0];
        this.m01 = matrix[0][1];
        this.m02 = matrix[0][2];
        this.m10 = matrix[1][0];
        this.m11 = matrix[1][1];
        this.m12 = matrix[1][2];
        this.m20 = matrix[2][0];
        this.m21 = matrix[2][1];
        this.m22 = matrix[2][2];
        return this;
    }

    public void fromAxes(Vector3f uAxis, Vector3f vAxis, Vector3f wAxis) {
        this.m00 = uAxis.x;
        this.m10 = uAxis.y;
        this.m20 = uAxis.z;
        this.m01 = vAxis.x;
        this.m11 = vAxis.y;
        this.m21 = vAxis.z;
        this.m02 = wAxis.x;
        this.m12 = wAxis.y;
        this.m22 = wAxis.z;
    }

    public Matrix3f set(float[] matrix) {
        return this.set(matrix, true);
    }

    public Matrix3f set(float[] matrix, boolean rowMajor) {
        if (matrix.length != 9) {
            throw new IllegalArgumentException("Array must be of size 9.");
        }
        if (rowMajor) {
            this.m00 = matrix[0];
            this.m01 = matrix[1];
            this.m02 = matrix[2];
            this.m10 = matrix[3];
            this.m11 = matrix[4];
            this.m12 = matrix[5];
            this.m20 = matrix[6];
            this.m21 = matrix[7];
            this.m22 = matrix[8];
        } else {
            this.m00 = matrix[0];
            this.m01 = matrix[3];
            this.m02 = matrix[6];
            this.m10 = matrix[1];
            this.m11 = matrix[4];
            this.m12 = matrix[7];
            this.m20 = matrix[2];
            this.m21 = matrix[5];
            this.m22 = matrix[8];
        }
        return this;
    }

    public Matrix3f set(Quaternion quaternion) {
        return quaternion.toRotationMatrix(this);
    }

    public void loadIdentity() {
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0f && this.m01 == 0.0f && this.m02 == 0.0f && this.m10 == 0.0f && this.m11 == 1.0f && this.m12 == 0.0f && this.m20 == 0.0f && this.m21 == 0.0f && this.m22 == 1.0f;
    }

    public void fromAngleAxis(float angle, Vector3f axis) {
        Vector3f normAxis = axis.normalize();
        this.fromAngleNormalAxis(angle, normAxis);
    }

    public void fromAngleNormalAxis(float angle, Vector3f axis) {
        float fCos = FastMath.cos(angle);
        float fSin = FastMath.sin(angle);
        float fOneMinusCos = 1.0f - fCos;
        float fX2 = axis.x * axis.x;
        float fY2 = axis.y * axis.y;
        float fZ2 = axis.z * axis.z;
        float fXYM = axis.x * axis.y * fOneMinusCos;
        float fXZM = axis.x * axis.z * fOneMinusCos;
        float fYZM = axis.y * axis.z * fOneMinusCos;
        float fXSin = axis.x * fSin;
        float fYSin = axis.y * fSin;
        float fZSin = axis.z * fSin;
        this.m00 = fX2 * fOneMinusCos + fCos;
        this.m01 = fXYM - fZSin;
        this.m02 = fXZM + fYSin;
        this.m10 = fXYM + fZSin;
        this.m11 = fY2 * fOneMinusCos + fCos;
        this.m12 = fYZM - fXSin;
        this.m20 = fXZM - fYSin;
        this.m21 = fYZM + fXSin;
        this.m22 = fZ2 * fOneMinusCos + fCos;
    }

    public Matrix3f mult(Matrix3f mat) {
        return this.mult(mat, null);
    }

    public Matrix3f mult(Matrix3f mat, Matrix3f product) {
        if (product == null) {
            product = new Matrix3f();
        }
        float temp00 = this.m00 * mat.m00 + this.m01 * mat.m10 + this.m02 * mat.m20;
        float temp01 = this.m00 * mat.m01 + this.m01 * mat.m11 + this.m02 * mat.m21;
        float temp02 = this.m00 * mat.m02 + this.m01 * mat.m12 + this.m02 * mat.m22;
        float temp10 = this.m10 * mat.m00 + this.m11 * mat.m10 + this.m12 * mat.m20;
        float temp11 = this.m10 * mat.m01 + this.m11 * mat.m11 + this.m12 * mat.m21;
        float temp12 = this.m10 * mat.m02 + this.m11 * mat.m12 + this.m12 * mat.m22;
        float temp20 = this.m20 * mat.m00 + this.m21 * mat.m10 + this.m22 * mat.m20;
        float temp21 = this.m20 * mat.m01 + this.m21 * mat.m11 + this.m22 * mat.m21;
        float temp22 = this.m20 * mat.m02 + this.m21 * mat.m12 + this.m22 * mat.m22;
        product.m00 = temp00;
        product.m01 = temp01;
        product.m02 = temp02;
        product.m10 = temp10;
        product.m11 = temp11;
        product.m12 = temp12;
        product.m20 = temp20;
        product.m21 = temp21;
        product.m22 = temp22;
        return product;
    }

    public Vector3f mult(Vector3f vec) {
        return this.mult(vec, null);
    }

    public Vector3f mult(Vector3f vec, Vector3f product) {
        if (null == product) {
            product = new Vector3f();
        }
        float x2 = vec.x;
        float y2 = vec.y;
        float z = vec.z;
        product.x = this.m00 * x2 + this.m01 * y2 + this.m02 * z;
        product.y = this.m10 * x2 + this.m11 * y2 + this.m12 * z;
        product.z = this.m20 * x2 + this.m21 * y2 + this.m22 * z;
        return product;
    }

    public Matrix3f multLocal(float scale2) {
        this.m00 *= scale2;
        this.m01 *= scale2;
        this.m02 *= scale2;
        this.m10 *= scale2;
        this.m11 *= scale2;
        this.m12 *= scale2;
        this.m20 *= scale2;
        this.m21 *= scale2;
        this.m22 *= scale2;
        return this;
    }

    public Vector3f multLocal(Vector3f vec) {
        if (vec == null) {
            return null;
        }
        float x2 = vec.x;
        float y2 = vec.y;
        vec.x = this.m00 * x2 + this.m01 * y2 + this.m02 * vec.z;
        vec.y = this.m10 * x2 + this.m11 * y2 + this.m12 * vec.z;
        vec.z = this.m20 * x2 + this.m21 * y2 + this.m22 * vec.z;
        return vec;
    }

    public Matrix3f multLocal(Matrix3f mat) {
        return this.mult(mat, this);
    }

    public Matrix3f transposeLocal() {
        float tmp = this.m01;
        this.m01 = this.m10;
        this.m10 = tmp;
        tmp = this.m02;
        this.m02 = this.m20;
        this.m20 = tmp;
        tmp = this.m12;
        this.m12 = this.m21;
        this.m21 = tmp;
        return this;
    }

    public Matrix3f invert() {
        return this.invert(null);
    }

    public Matrix3f invert(Matrix3f store) {
        float det;
        if (store == null) {
            store = new Matrix3f();
        }
        if (FastMath.abs(det = this.determinant()) <= 1.1920929E-7f) {
            return store.zero();
        }
        store.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        store.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        store.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        store.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        store.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        store.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        store.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        store.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        store.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        store.multLocal(1.0f / det);
        return store;
    }

    public Matrix3f invertLocal() {
        float det = this.determinant();
        if (FastMath.abs(det) <= 0.0f) {
            return this.zero();
        }
        float f00 = this.m11 * this.m22 - this.m12 * this.m21;
        float f01 = this.m02 * this.m21 - this.m01 * this.m22;
        float f02 = this.m01 * this.m12 - this.m02 * this.m11;
        float f10 = this.m12 * this.m20 - this.m10 * this.m22;
        float f11 = this.m00 * this.m22 - this.m02 * this.m20;
        float f12 = this.m02 * this.m10 - this.m00 * this.m12;
        float f20 = this.m10 * this.m21 - this.m11 * this.m20;
        float f21 = this.m01 * this.m20 - this.m00 * this.m21;
        float f22 = this.m00 * this.m11 - this.m01 * this.m10;
        this.m00 = f00;
        this.m01 = f01;
        this.m02 = f02;
        this.m10 = f10;
        this.m11 = f11;
        this.m12 = f12;
        this.m20 = f20;
        this.m21 = f21;
        this.m22 = f22;
        this.multLocal(1.0f / det);
        return this;
    }

    public Matrix3f adjoint() {
        return this.adjoint(null);
    }

    public Matrix3f adjoint(Matrix3f store) {
        if (store == null) {
            store = new Matrix3f();
        }
        store.m00 = this.m11 * this.m22 - this.m12 * this.m21;
        store.m01 = this.m02 * this.m21 - this.m01 * this.m22;
        store.m02 = this.m01 * this.m12 - this.m02 * this.m11;
        store.m10 = this.m12 * this.m20 - this.m10 * this.m22;
        store.m11 = this.m00 * this.m22 - this.m02 * this.m20;
        store.m12 = this.m02 * this.m10 - this.m00 * this.m12;
        store.m20 = this.m10 * this.m21 - this.m11 * this.m20;
        store.m21 = this.m01 * this.m20 - this.m00 * this.m21;
        store.m22 = this.m00 * this.m11 - this.m01 * this.m10;
        return store;
    }

    public float determinant() {
        float fCo00 = this.m11 * this.m22 - this.m12 * this.m21;
        float fCo10 = this.m12 * this.m20 - this.m10 * this.m22;
        float fCo20 = this.m10 * this.m21 - this.m11 * this.m20;
        float fDet = this.m00 * fCo00 + this.m01 * fCo10 + this.m02 * fCo20;
        return fDet;
    }

    public Matrix3f zero() {
        this.m22 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m11 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        this.m00 = 0.0f;
        return this;
    }

    public Matrix3f transpose() {
        return this.transposeLocal();
    }

    public Matrix3f transposeNew() {
        Matrix3f ret = new Matrix3f(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return ret;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder("Matrix3f\n[\n");
        result2.append(" ");
        result2.append(this.m00);
        result2.append("  ");
        result2.append(this.m01);
        result2.append("  ");
        result2.append(this.m02);
        result2.append(" \n");
        result2.append(" ");
        result2.append(this.m10);
        result2.append("  ");
        result2.append(this.m11);
        result2.append("  ");
        result2.append(this.m12);
        result2.append(" \n");
        result2.append(" ");
        result2.append(this.m20);
        result2.append("  ");
        result2.append(this.m21);
        result2.append("  ");
        result2.append(this.m22);
        result2.append(" \n]");
        return result2.toString();
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + Float.floatToIntBits(this.m00);
        hash = 37 * hash + Float.floatToIntBits(this.m01);
        hash = 37 * hash + Float.floatToIntBits(this.m02);
        hash = 37 * hash + Float.floatToIntBits(this.m10);
        hash = 37 * hash + Float.floatToIntBits(this.m11);
        hash = 37 * hash + Float.floatToIntBits(this.m12);
        hash = 37 * hash + Float.floatToIntBits(this.m20);
        hash = 37 * hash + Float.floatToIntBits(this.m21);
        hash = 37 * hash + Float.floatToIntBits(this.m22);
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Matrix3f comp = (Matrix3f)o;
        if (Float.compare(this.m00, comp.m00) != 0) {
            return false;
        }
        if (Float.compare(this.m01, comp.m01) != 0) {
            return false;
        }
        if (Float.compare(this.m02, comp.m02) != 0) {
            return false;
        }
        if (Float.compare(this.m10, comp.m10) != 0) {
            return false;
        }
        if (Float.compare(this.m11, comp.m11) != 0) {
            return false;
        }
        if (Float.compare(this.m12, comp.m12) != 0) {
            return false;
        }
        if (Float.compare(this.m20, comp.m20) != 0) {
            return false;
        }
        if (Float.compare(this.m21, comp.m21) != 0) {
            return false;
        }
        return Float.compare(this.m22, comp.m22) == 0;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule cap = e.getCapsule(this);
        cap.write(this.m00, "m00", 1.0f);
        cap.write(this.m01, "m01", 0.0f);
        cap.write(this.m02, "m02", 0.0f);
        cap.write(this.m10, "m10", 0.0f);
        cap.write(this.m11, "m11", 1.0f);
        cap.write(this.m12, "m12", 0.0f);
        cap.write(this.m20, "m20", 0.0f);
        cap.write(this.m21, "m21", 0.0f);
        cap.write(this.m22, "m22", 1.0f);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        InputCapsule cap = importer.getCapsule(this);
        this.m00 = cap.readFloat("m00", 1.0f);
        this.m01 = cap.readFloat("m01", 0.0f);
        this.m02 = cap.readFloat("m02", 0.0f);
        this.m10 = cap.readFloat("m10", 0.0f);
        this.m11 = cap.readFloat("m11", 1.0f);
        this.m12 = cap.readFloat("m12", 0.0f);
        this.m20 = cap.readFloat("m20", 0.0f);
        this.m21 = cap.readFloat("m21", 0.0f);
        this.m22 = cap.readFloat("m22", 1.0f);
    }

    public void fromStartEndVectors(Vector3f start2, Vector3f end2) {
        float f;
        Vector3f v = new Vector3f();
        start2.cross(end2, v);
        float e = start2.dot(end2);
        float f2 = f = e < 0.0f ? -e : e;
        if (f > 0.9999f) {
            Vector3f u = new Vector3f();
            Vector3f x2 = new Vector3f();
            x2.x = (double)start2.x > 0.0 ? start2.x : -start2.x;
            x2.y = (double)start2.y > 0.0 ? start2.y : -start2.y;
            float f3 = x2.z = (double)start2.z > 0.0 ? start2.z : -start2.z;
            if (x2.x < x2.y) {
                if (x2.x < x2.z) {
                    x2.x = 1.0f;
                    x2.z = 0.0f;
                    x2.y = 0.0f;
                } else {
                    x2.z = 1.0f;
                    x2.y = 0.0f;
                    x2.x = 0.0f;
                }
            } else if (x2.y < x2.z) {
                x2.y = 1.0f;
                x2.z = 0.0f;
                x2.x = 0.0f;
            } else {
                x2.z = 1.0f;
                x2.y = 0.0f;
                x2.x = 0.0f;
            }
            u.x = x2.x - start2.x;
            u.y = x2.y - start2.y;
            u.z = x2.z - start2.z;
            v.x = x2.x - end2.x;
            v.y = x2.y - end2.y;
            v.z = x2.z - end2.z;
            float c1 = 2.0f / u.dot(u);
            float c2 = 2.0f / v.dot(v);
            float c3 = c1 * c2 * u.dot(v);
            for (int i = 0; i < 3; ++i) {
                float val;
                for (int j = 0; j < 3; ++j) {
                    val = -c1 * u.get(i) * u.get(j) - c2 * v.get(i) * v.get(j) + c3 * v.get(i) * u.get(j);
                    this.set(i, j, val);
                }
                val = this.get(i, i);
                this.set(i, i, val + 1.0f);
            }
        } else {
            float h = 1.0f / (1.0f + e);
            float hvx = h * v.x;
            float hvz = h * v.z;
            float hvxy = hvx * v.y;
            float hvxz = hvx * v.z;
            float hvyz = hvz * v.y;
            this.set(0, 0, e + hvx * v.x);
            this.set(0, 1, hvxy - v.z);
            this.set(0, 2, hvxz + v.y);
            this.set(1, 0, hvxy + v.z);
            this.set(1, 1, e + h * v.y * v.y);
            this.set(1, 2, hvyz - v.x);
            this.set(2, 0, hvxz - v.y);
            this.set(2, 1, hvyz + v.x);
            this.set(2, 2, e + hvz * v.z);
        }
    }

    public void scale(Vector3f scale2) {
        this.m00 *= scale2.x;
        this.m10 *= scale2.x;
        this.m20 *= scale2.x;
        this.m01 *= scale2.y;
        this.m11 *= scale2.y;
        this.m21 *= scale2.y;
        this.m02 *= scale2.z;
        this.m12 *= scale2.z;
        this.m22 *= scale2.z;
    }

    static boolean equalIdentity(Matrix3f mat) {
        if ((double)Math.abs(mat.m00 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m11 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m22 - 1.0f) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m01) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m02) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m10) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m12) > 1.0E-4) {
            return false;
        }
        if ((double)Math.abs(mat.m20) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(mat.m21) > 1.0E-4);
    }

    public Matrix3f clone() {
        try {
            return (Matrix3f)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

