/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.io.Serializable;

public class LineSegment
implements Cloneable,
Savable,
Serializable {
    static final long serialVersionUID = 1L;
    private Vector3f origin;
    private Vector3f direction;
    private float extent;

    public LineSegment() {
        this.origin = new Vector3f();
        this.direction = new Vector3f();
    }

    public LineSegment(LineSegment ls) {
        this.origin = new Vector3f(ls.getOrigin());
        this.direction = new Vector3f(ls.getDirection());
        this.extent = ls.getExtent();
    }

    public LineSegment(Vector3f origin2, Vector3f direction, float extent) {
        this.origin = origin2;
        this.direction = direction;
        this.extent = extent;
    }

    public LineSegment(Vector3f start2, Vector3f end2) {
        this.origin = new Vector3f(0.5f * (start2.x + end2.x), 0.5f * (start2.y + end2.y), 0.5f * (start2.z + end2.z));
        this.direction = end2.subtract(start2);
        this.extent = this.direction.length() * 0.5f;
        this.direction.normalizeLocal();
    }

    public void set(LineSegment ls) {
        this.origin = new Vector3f(ls.getOrigin());
        this.direction = new Vector3f(ls.getDirection());
        this.extent = ls.getExtent();
    }

    public float distance(Vector3f point) {
        return FastMath.sqrt(this.distanceSquared(point));
    }

    public float distance(LineSegment ls) {
        return FastMath.sqrt(this.distanceSquared(ls));
    }

    public float distance(Ray r) {
        return FastMath.sqrt(this.distanceSquared(r));
    }

    public float distanceSquared(Vector3f point) {
        TempVars vars = TempVars.get();
        Vector3f compVec1 = vars.vect1;
        point.subtract(this.origin, compVec1);
        float segmentParameter = this.direction.dot(compVec1);
        if (-this.extent < segmentParameter) {
            if (segmentParameter < this.extent) {
                this.origin.add(this.direction.mult(segmentParameter, compVec1), compVec1);
            } else {
                this.origin.add(this.direction.mult(this.extent, compVec1), compVec1);
            }
        } else {
            this.origin.subtract(this.direction.mult(this.extent, compVec1), compVec1);
        }
        compVec1.subtractLocal(point);
        float len = compVec1.lengthSquared();
        vars.release();
        return len;
    }

    public float distanceSquared(LineSegment test) {
        float squareDistance;
        TempVars vars = TempVars.get();
        Vector3f compVec1 = vars.vect1;
        this.origin.subtract(test.getOrigin(), compVec1);
        float negativeDirectionDot = -this.direction.dot(test.getDirection());
        float diffThisDot = compVec1.dot(this.direction);
        float diffTestDot = -compVec1.dot(test.getDirection());
        float lengthOfDiff = compVec1.lengthSquared();
        vars.release();
        float determinant = FastMath.abs(1.0f - negativeDirectionDot * negativeDirectionDot);
        if (determinant >= 1.1920929E-7f) {
            float s0 = negativeDirectionDot * diffTestDot - diffThisDot;
            float s1 = negativeDirectionDot * diffThisDot - diffTestDot;
            float extentDeterminant0 = this.extent * determinant;
            float extentDeterminant1 = test.getExtent() * determinant;
            if (s0 >= -extentDeterminant0) {
                if (s0 <= extentDeterminant0) {
                    if (s1 >= -extentDeterminant1) {
                        if (s1 <= extentDeterminant1) {
                            float inverseDeterminant = 1.0f / determinant;
                            squareDistance = (s0 *= inverseDeterminant) * (s0 + negativeDirectionDot * (s1 *= inverseDeterminant) + 2.0f * diffThisDot) + s1 * (negativeDirectionDot * s0 + s1 + 2.0f * diffTestDot) + lengthOfDiff;
                        } else {
                            s1 = test.getExtent();
                            float tempS0 = -(negativeDirectionDot * s1 + diffThisDot);
                            if (tempS0 < -this.extent) {
                                s0 = -this.extent;
                                squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                            } else if (tempS0 <= this.extent) {
                                s0 = tempS0;
                                squareDistance = -s0 * s0 + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                            } else {
                                s0 = this.extent;
                                squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                            }
                        }
                    } else {
                        s1 = -test.getExtent();
                        float tempS0 = -(negativeDirectionDot * s1 + diffThisDot);
                        if (tempS0 < -this.extent) {
                            s0 = -this.extent;
                            squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                        } else if (tempS0 <= this.extent) {
                            s0 = tempS0;
                            squareDistance = -s0 * s0 + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                        } else {
                            s0 = this.extent;
                            squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                        }
                    }
                } else if (s1 >= -extentDeterminant1) {
                    if (s1 <= extentDeterminant1) {
                        s0 = this.extent;
                        float tempS1 = -(negativeDirectionDot * s0 + diffTestDot);
                        if (tempS1 < -test.getExtent()) {
                            s1 = -test.getExtent();
                            squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        } else if (tempS1 <= test.getExtent()) {
                            s1 = tempS1;
                            squareDistance = -s1 * s1 + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        } else {
                            s1 = test.getExtent();
                            squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        }
                    } else {
                        s1 = test.getExtent();
                        float tempS0 = -(negativeDirectionDot * s1 + diffThisDot);
                        if (tempS0 < -this.extent) {
                            s0 = -this.extent;
                            squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                        } else if (tempS0 <= this.extent) {
                            s0 = tempS0;
                            squareDistance = -s0 * s0 + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                        } else {
                            s0 = this.extent;
                            float tempS1 = -(negativeDirectionDot * s0 + diffTestDot);
                            if (tempS1 < -test.getExtent()) {
                                s1 = -test.getExtent();
                                squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                            } else if (tempS1 <= test.getExtent()) {
                                s1 = tempS1;
                                squareDistance = -s1 * s1 + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                            } else {
                                s1 = test.getExtent();
                                squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                            }
                        }
                    }
                } else {
                    s1 = -test.getExtent();
                    float tempS0 = -(negativeDirectionDot * s1 + diffThisDot);
                    if (tempS0 < -this.extent) {
                        s0 = -this.extent;
                        squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                    } else if (tempS0 <= this.extent) {
                        s0 = tempS0;
                        squareDistance = -s0 * s0 + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                    } else {
                        s0 = this.extent;
                        float tempS1 = -(negativeDirectionDot * s0 + diffTestDot);
                        if (tempS1 > test.getExtent()) {
                            s1 = test.getExtent();
                            squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        } else if (tempS1 >= -test.getExtent()) {
                            s1 = tempS1;
                            squareDistance = -s1 * s1 + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        } else {
                            s1 = -test.getExtent();
                            squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        }
                    }
                }
            } else if (s1 >= -extentDeterminant1) {
                if (s1 <= extentDeterminant1) {
                    s0 = -this.extent;
                    float tempS1 = -(negativeDirectionDot * s0 + diffTestDot);
                    if (tempS1 < -test.getExtent()) {
                        s1 = -test.getExtent();
                        squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                    } else if (tempS1 <= test.getExtent()) {
                        s1 = tempS1;
                        squareDistance = -s1 * s1 + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                    } else {
                        s1 = test.getExtent();
                        squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                    }
                } else {
                    s1 = test.getExtent();
                    float tempS0 = -(negativeDirectionDot * s1 + diffThisDot);
                    if (tempS0 > this.extent) {
                        s0 = this.extent;
                        squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                    } else if (tempS0 >= -this.extent) {
                        s0 = tempS0;
                        squareDistance = -s0 * s0 + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                    } else {
                        s0 = -this.extent;
                        float tempS1 = -(negativeDirectionDot * s0 + diffTestDot);
                        if (tempS1 < -test.getExtent()) {
                            s1 = -test.getExtent();
                            squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        } else if (tempS1 <= test.getExtent()) {
                            s1 = tempS1;
                            squareDistance = -s1 * s1 + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        } else {
                            s1 = test.getExtent();
                            squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                        }
                    }
                }
            } else {
                s1 = -test.getExtent();
                float tempS0 = -(negativeDirectionDot * s1 + diffThisDot);
                if (tempS0 > this.extent) {
                    s0 = this.extent;
                    squareDistance = s0 * (s0 - 2.0f * tempS0) + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                } else if (tempS0 >= -this.extent) {
                    s0 = tempS0;
                    squareDistance = -s0 * s0 + s1 * (s1 + 2.0f * diffTestDot) + lengthOfDiff;
                } else {
                    s0 = -this.extent;
                    float tempS1 = -(negativeDirectionDot * s0 + diffTestDot);
                    if (tempS1 < -test.getExtent()) {
                        s1 = -test.getExtent();
                        squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                    } else if (tempS1 <= test.getExtent()) {
                        s1 = tempS1;
                        squareDistance = -s1 * s1 + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                    } else {
                        s1 = test.getExtent();
                        squareDistance = s1 * (s1 - 2.0f * tempS1) + s0 * (s0 + 2.0f * diffThisDot) + lengthOfDiff;
                    }
                }
            }
        } else {
            float extentSum;
            float sign2 = negativeDirectionDot > 0.0f ? -1.0f : 1.0f;
            float averageB0 = 0.5f * (diffThisDot - sign2 * diffTestDot);
            float lambda = -averageB0;
            if (lambda < -(extentSum = this.extent + test.getExtent())) {
                lambda = -extentSum;
            } else if (lambda > extentSum) {
                lambda = extentSum;
            }
            squareDistance = lambda * (lambda + 2.0f * averageB0) + lengthOfDiff;
        }
        return FastMath.abs(squareDistance);
    }

    public float distanceSquared(Ray r) {
        float fSqrDist;
        Vector3f kDiff = r.getOrigin().subtract(this.origin);
        float fA01 = -r.getDirection().dot(this.direction);
        float fB0 = kDiff.dot(r.getDirection());
        float fB1 = -kDiff.dot(this.direction);
        float fC = kDiff.lengthSquared();
        float fDet = FastMath.abs(1.0f - fA01 * fA01);
        if (fDet >= 1.1920929E-7f) {
            float fS0 = fA01 * fB1 - fB0;
            float fS1 = fA01 * fB0 - fB1;
            float fExtDet = this.extent * fDet;
            if (fS0 >= 0.0f) {
                if (fS1 >= -fExtDet) {
                    if (fS1 <= fExtDet) {
                        float fInvDet = 1.0f / fDet;
                        fSqrDist = (fS0 *= fInvDet) * (fS0 + fA01 * (fS1 *= fInvDet) + 2.0f * fB0) + fS1 * (fA01 * fS0 + fS1 + 2.0f * fB1) + fC;
                    } else {
                        fS1 = this.extent;
                        fS0 = -(fA01 * fS1 + fB0);
                        if (fS0 > 0.0f) {
                            fSqrDist = -fS0 * fS0 + fS1 * (fS1 + 2.0f * fB1) + fC;
                        } else {
                            fS0 = 0.0f;
                            fSqrDist = fS1 * (fS1 + 2.0f * fB1) + fC;
                        }
                    }
                } else {
                    fS1 = -this.extent;
                    fS0 = -(fA01 * fS1 + fB0);
                    if (fS0 > 0.0f) {
                        fSqrDist = -fS0 * fS0 + fS1 * (fS1 + 2.0f * fB1) + fC;
                    } else {
                        fS0 = 0.0f;
                        fSqrDist = fS1 * (fS1 + 2.0f * fB1) + fC;
                    }
                }
            } else if (fS1 <= -fExtDet) {
                fS0 = -(-fA01 * this.extent + fB0);
                if (fS0 > 0.0f) {
                    fS1 = -this.extent;
                    fSqrDist = -fS0 * fS0 + fS1 * (fS1 + 2.0f * fB1) + fC;
                } else {
                    fS0 = 0.0f;
                    fS1 = -fB1;
                    if (fS1 < -this.extent) {
                        fS1 = -this.extent;
                    } else if (fS1 > this.extent) {
                        fS1 = this.extent;
                    }
                    fSqrDist = fS1 * (fS1 + 2.0f * fB1) + fC;
                }
            } else if (fS1 <= fExtDet) {
                fS0 = 0.0f;
                fS1 = -fB1;
                if (fS1 < -this.extent) {
                    fS1 = -this.extent;
                } else if (fS1 > this.extent) {
                    fS1 = this.extent;
                }
                fSqrDist = fS1 * (fS1 + 2.0f * fB1) + fC;
            } else {
                fS0 = -(fA01 * this.extent + fB0);
                if (fS0 > 0.0f) {
                    fS1 = this.extent;
                    fSqrDist = -fS0 * fS0 + fS1 * (fS1 + 2.0f * fB1) + fC;
                } else {
                    fS0 = 0.0f;
                    fS1 = -fB1;
                    if (fS1 < -this.extent) {
                        fS1 = -this.extent;
                    } else if (fS1 > this.extent) {
                        fS1 = this.extent;
                    }
                    fSqrDist = fS1 * (fS1 + 2.0f * fB1) + fC;
                }
            }
        } else {
            float fS1 = fA01 > 0.0f ? -this.extent : this.extent;
            float fS0 = -(fA01 * fS1 + fB0);
            if (fS0 > 0.0f) {
                fSqrDist = -fS0 * fS0 + fS1 * (fS1 + 2.0f * fB1) + fC;
            } else {
                fS0 = 0.0f;
                fSqrDist = fS1 * (fS1 + 2.0f * fB1) + fC;
            }
        }
        return FastMath.abs(fSqrDist);
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction = direction;
    }

    public float getExtent() {
        return this.extent;
    }

    public void setExtent(float extent) {
        this.extent = extent;
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector3f origin2) {
        this.origin = origin2;
    }

    public Vector3f getPositiveEnd(Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        return this.origin.add(this.direction.mult(this.extent, store), store);
    }

    public Vector3f getNegativeEnd(Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        return this.origin.subtract(this.direction.mult(this.extent, store), store);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.origin, "origin", Vector3f.ZERO);
        capsule.write(this.direction, "direction", Vector3f.ZERO);
        capsule.write(this.extent, "extent", 0.0f);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule(this);
        this.origin = (Vector3f)capsule.readSavable("origin", Vector3f.ZERO.clone());
        this.direction = (Vector3f)capsule.readSavable("direction", Vector3f.ZERO.clone());
        this.extent = capsule.readFloat("extent", 0.0f);
    }

    public LineSegment clone() {
        try {
            LineSegment segment = (LineSegment)super.clone();
            segment.direction = this.direction.clone();
            segment.origin = this.origin.clone();
            return segment;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public boolean isPointInsideBounds(Vector3f point) {
        return this.isPointInsideBounds(point, Float.MIN_VALUE);
    }

    public boolean isPointInsideBounds(Vector3f point, float error) {
        if (FastMath.abs(point.x - this.origin.x) > FastMath.abs(this.direction.x * this.extent) + error) {
            return false;
        }
        if (FastMath.abs(point.y - this.origin.y) > FastMath.abs(this.direction.y * this.extent) + error) {
            return false;
        }
        return !(FastMath.abs(point.z - this.origin.z) > FastMath.abs(this.direction.z * this.extent) + error);
    }
}

