/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Eigen3f;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class Line
implements Savable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private Vector3f origin;
    private Vector3f direction;

    public Line() {
        this.origin = new Vector3f();
        this.direction = new Vector3f();
    }

    public Line(Vector3f origin2, Vector3f direction) {
        this.origin = origin2;
        this.direction = direction;
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector3f origin2) {
        this.origin = origin2;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction = direction;
    }

    public float distanceSquared(Vector3f point) {
        TempVars vars = TempVars.get();
        Vector3f compVec1 = vars.vect1;
        Vector3f compVec2 = vars.vect2;
        point.subtract(this.origin, compVec1);
        float lineParameter = this.direction.dot(compVec1);
        this.origin.add(this.direction.mult(lineParameter, compVec2), compVec2);
        compVec2.subtract(point, compVec1);
        float len = compVec1.lengthSquared();
        vars.release();
        return len;
    }

    public float distance(Vector3f point) {
        return FastMath.sqrt(this.distanceSquared(point));
    }

    public void orthogonalLineFit(FloatBuffer points) {
        if (points == null) {
            return;
        }
        TempVars vars = TempVars.get();
        Vector3f compVec1 = vars.vect1;
        Vector3f compVec2 = vars.vect2;
        Matrix3f compMat1 = vars.tempMat3;
        Eigen3f compEigen1 = vars.eigen;
        points.rewind();
        int length = points.remaining() / 3;
        BufferUtils.populateFromBuffer(this.origin, points, 0);
        for (int i = 1; i < length; ++i) {
            BufferUtils.populateFromBuffer(compVec1, points, i);
            this.origin.addLocal(compVec1);
        }
        this.origin.multLocal(1.0f / (float)length);
        float sumXX = 0.0f;
        float sumXY = 0.0f;
        float sumXZ = 0.0f;
        float sumYY = 0.0f;
        float sumYZ = 0.0f;
        float sumZZ = 0.0f;
        points.rewind();
        for (int i = 0; i < length; ++i) {
            BufferUtils.populateFromBuffer(compVec1, points, i);
            compVec1.subtract(this.origin, compVec2);
            sumXX += compVec2.x * compVec2.x;
            sumXY += compVec2.x * compVec2.y;
            sumXZ += compVec2.x * compVec2.z;
            sumYY += compVec2.y * compVec2.y;
            sumYZ += compVec2.y * compVec2.z;
            sumZZ += compVec2.z * compVec2.z;
        }
        compMat1.m00 = sumYY + sumZZ;
        compMat1.m01 = -sumXY;
        compMat1.m02 = -sumXZ;
        compMat1.m10 = -sumXY;
        compMat1.m11 = sumXX + sumZZ;
        compMat1.m12 = -sumYZ;
        compMat1.m20 = -sumXZ;
        compMat1.m21 = -sumYZ;
        compMat1.m22 = sumXX + sumYY;
        compEigen1.calculateEigen(compMat1);
        this.direction = compEigen1.getEigenVector(0);
        vars.release();
    }

    public Vector3f random() {
        return this.random(null);
    }

    public Vector3f random(Vector3f result2) {
        if (result2 == null) {
            result2 = new Vector3f();
        }
        float rand = (float)Math.random();
        result2.x = this.origin.x * (1.0f - rand) + this.direction.x * rand;
        result2.y = this.origin.y * (1.0f - rand) + this.direction.y * rand;
        result2.z = this.origin.z * (1.0f - rand) + this.direction.z * rand;
        return result2;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.origin, "origin", Vector3f.ZERO);
        capsule.write(this.direction, "direction", Vector3f.ZERO);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule(this);
        this.origin = (Vector3f)capsule.readSavable("origin", Vector3f.ZERO.clone());
        this.direction = (Vector3f)capsule.readSavable("direction", Vector3f.ZERO.clone());
    }

    public Line clone() {
        try {
            Line line = (Line)super.clone();
            line.direction = this.direction.clone();
            line.origin = this.origin.clone();
            return line;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

