/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.lwjgl3.utils;

import com.jme3.lwjgl3.utils.APIBuffer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class APIUtil {
    private static final ThreadLocal<APIBuffer> API_BUFFERS = ThreadLocal.withInitial(APIBuffer::new);

    private APIUtil() {
    }

    @SafeVarargs
    public static <T> T[] toArray(T ... arguments2) {
        return arguments2;
    }

    public static APIBuffer apiBuffer() {
        return API_BUFFERS.get().reset();
    }

    public static APIBuffer apiStack() {
        return API_BUFFERS.get().push();
    }

    public static APIVersion apiParseVersion(String version) {
        return APIUtil.apiParseVersion(version, null);
    }

    public static APIVersion apiParseVersion(String version, String prefix) {
        Matcher matcher;
        String pattern = "([0-9]+)[.]([0-9]+)([.]\\S+)?\\s*(.+)?";
        if (prefix != null) {
            pattern = prefix + "\\s+" + pattern;
        }
        if (!(matcher = Pattern.compile(pattern).matcher(version)).matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", version));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static String apiUnknownToken(int token2) {
        return APIUtil.apiUnknownToken("Unknown", token2);
    }

    public static String apiUnknownToken(String description2, int token2) {
        return String.format("%s [0x%X]", description2, token2);
    }

    public static Map<Integer, String> apiClassTokens(TokenFilter filter2, Map<Integer, String> target, Class<?> ... tokenClasses) {
        if (target == null) {
            target = new HashMap<Integer, String>(64);
        }
        int TOKEN_MODIFIERS = 25;
        for (Class<?> tokenClass : tokenClasses) {
            if (tokenClass == null) continue;
            for (Field field : tokenClass.getDeclaredFields()) {
                if ((field.getModifiers() & TOKEN_MODIFIERS) != TOKEN_MODIFIERS || field.getType() != Integer.TYPE) continue;
                try {
                    int value = field.getInt(null);
                    if (filter2 != null && !filter2.accept(field, value)) continue;
                    String name = target.get(value);
                    target.put(value, name == null ? field.getName() : name + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return target;
    }

    public static Class<?> apiOptionalClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static class APIVersion {
        public final int major;
        public final int minor;
        public final String revision;
        public final String implementation;

        public APIVersion(int major, int minor) {
            this(major, minor, null, null);
        }

        public APIVersion(int major, int minor, String revision, String implementation) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.implementation = implementation;
        }
    }

    public static interface TokenFilter {
        public boolean accept(Field var1, int var2);
    }
}

