/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.lwjgl3.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class APIBuffer {
    private static final int DEFAULT_CAPACITY = 128;
    private ByteBuffer buffer;
    private long address;
    private int offset;
    private int stackDepth;
    private int[] stack = new int[4];

    public APIBuffer() {
        this.buffer = BufferUtils.createByteBuffer(128);
        this.address = MemoryUtil.memAddress(this.buffer);
    }

    public APIBuffer reset() {
        this.offset = 0;
        return this;
    }

    public APIBuffer push() {
        if (this.stackDepth == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length << 1);
        }
        this.stack[this.stackDepth++] = this.offset;
        this.offset = this.offset + (Pointer.POINTER_SIZE - 1) & -Pointer.POINTER_SIZE;
        return this;
    }

    public APIBuffer pop() {
        this.offset = this.stack[--this.stackDepth];
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset2) {
        this.offset = offset2;
    }

    public long address() {
        return this.address;
    }

    public long address(int offset2) {
        return this.address + (long)offset2;
    }

    public long addressSafe(Object value, int offset2) {
        return value == null ? 0L : this.address(offset2);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private void ensureCapacity(int capacity) {
        if (capacity <= this.buffer.capacity()) {
            return;
        }
        ByteBuffer resized = BufferUtils.createByteBuffer(MathUtil.mathRoundPoT(capacity));
        resized.put(this.buffer);
        resized.clear();
        this.buffer = resized;
        this.address = MemoryUtil.memAddress(resized);
    }

    private int param(int bytes) {
        return this.param(bytes, bytes);
    }

    private int param(int bytes, int alignment) {
        int param = this.offset + (alignment - 1) & -alignment;
        this.offset = param + bytes;
        this.ensureCapacity(this.offset);
        return param;
    }

    public int booleanParam() {
        return this.param(1);
    }

    public int byteParam() {
        return this.param(1);
    }

    public int shortParam() {
        return this.param(2);
    }

    public int intParam() {
        return this.param(4);
    }

    public int longParam() {
        return this.param(8);
    }

    public int floatParam() {
        return this.param(4);
    }

    public int doubleParam() {
        return this.param(8);
    }

    public int pointerParam() {
        return this.param(Pointer.POINTER_SIZE);
    }

    public int bufferParam(int size2) {
        return this.param(size2, Pointer.POINTER_SIZE);
    }

    public int booleanParam(boolean value) {
        int offset2 = this.booleanParam();
        this.buffer.put(offset2, value ? (byte)1 : 0);
        return offset2;
    }

    public int byteParam(byte value) {
        int offset2 = this.byteParam();
        this.buffer.put(offset2, value);
        return offset2;
    }

    public int shortParam(short value) {
        int offset2 = this.shortParam();
        this.buffer.putShort(offset2, value);
        return offset2;
    }

    public int intParam(int value) {
        int offset2 = this.intParam();
        this.buffer.putInt(offset2, value);
        return offset2;
    }

    public int longParam(long value) {
        int offset2 = this.longParam();
        this.buffer.putLong(offset2, value);
        return offset2;
    }

    public int floatParam(float value) {
        int offset2 = this.floatParam();
        this.buffer.putFloat(offset2, value);
        return offset2;
    }

    public int doubleParam(double value) {
        int offset2 = this.doubleParam();
        this.buffer.putDouble(offset2, value);
        return offset2;
    }

    public int pointerParam(long value) {
        int offset2 = this.pointerParam();
        PointerBuffer.put(this.buffer, offset2, value);
        return offset2;
    }

    public int pointerArrayParam(long ... pointers) {
        int buffersAddress = this.bufferParam(pointers.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < pointers.length; ++i) {
            this.pointerParam(buffersAddress, i, pointers[i]);
        }
        return buffersAddress;
    }

    public int pointerArrayParam(ByteBuffer ... buffers) {
        int buffersAddress = this.bufferParam(buffers.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < buffers.length; ++i) {
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffers[i]));
        }
        return buffersAddress;
    }

    public int pointerArrayParamp(ByteBuffer ... buffers) {
        int buffersAddress = this.pointerArrayParam(buffers);
        int buffersLengths = this.bufferParam(buffers.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < buffers.length; ++i) {
            this.pointerParam(buffersLengths, i, buffers[i].remaining());
        }
        return buffersAddress;
    }

    public int pointerArrayParamASCII(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memASCII(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
        }
        return buffersAddress;
    }

    public int pointerArrayParamASCIIi(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        int lengthsAddress = this.bufferParam(strings.length << 2);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memASCII(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
            this.intParam(lengthsAddress, i, buffer.remaining());
        }
        return buffersAddress;
    }

    public int pointerArrayParamASCIIp(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        int lengthsAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memASCII(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
            this.pointerParam(lengthsAddress, i, buffer.remaining());
        }
        return buffersAddress;
    }

    public int pointerArrayParamUTF8(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memUTF8(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
        }
        return buffersAddress;
    }

    public int pointerArrayParamUTF8i(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        int lengthsAddress = this.bufferParam(strings.length << 2);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memUTF8(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
            this.intParam(lengthsAddress, i, buffer.remaining());
        }
        return buffersAddress;
    }

    public int pointerArrayParamUTF8p(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        int lengthsAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memUTF8(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
            this.pointerParam(lengthsAddress, i, buffer.remaining());
        }
        return buffersAddress;
    }

    public int pointerArrayParamUTF16(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memUTF16(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
        }
        return buffersAddress;
    }

    public int pointerArrayParamUTF16i(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        int lengthsAddress = this.bufferParam(strings.length << 2);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memUTF16(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
            this.intParam(lengthsAddress, i, buffer.remaining());
        }
        return buffersAddress;
    }

    public int pointerArrayParamUTF16p(CharSequence ... strings) {
        int buffersAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        int lengthsAddress = this.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            ByteBuffer buffer = MemoryUtil.memUTF16(strings[i]);
            this.pointerParam(buffersAddress, i, MemoryUtil.memAddress(buffer));
            this.pointerParam(lengthsAddress, i, buffer.remaining());
        }
        return buffersAddress;
    }

    public void pointerArrayFree(int offset2, int length) {
        for (int i = 0; i < length; ++i) {
            MemoryUtil.nmemFree(this.pointerValue(offset2 + (i << Pointer.POINTER_SHIFT)));
        }
    }

    public void intParam(int offset2, int index2, int value) {
        this.buffer.putInt(offset2 + (index2 << 2), value);
    }

    public void pointerParam(int offset2, int index2, long value) {
        PointerBuffer.put(this.buffer, offset2 + (index2 << Pointer.POINTER_SHIFT), value);
    }

    public int stringParamASCII(CharSequence value, boolean nullTerminated) {
        if (value == null) {
            return -1;
        }
        int offset2 = this.bufferParam(value.length() + (nullTerminated ? 1 : 0));
        MemoryUtil.memASCII(value, nullTerminated, this.buffer, offset2);
        return offset2;
    }

    public int stringParamUTF8(CharSequence value, boolean nullTerminated) {
        if (value == null) {
            return -1;
        }
        int encodedLen = MemoryUtil.memLengthUTF8(value, nullTerminated);
        int offset2 = this.bufferParam(encodedLen);
        MemoryUtil.memUTF8(value, nullTerminated, this.buffer, offset2);
        return offset2;
    }

    public int stringParamUTF16(CharSequence value, boolean nullTerminated) {
        if (value == null) {
            return -1;
        }
        int offset2 = this.bufferParam(value.length() + (nullTerminated ? 1 : 0) << 1);
        MemoryUtil.memUTF16(value, nullTerminated, this.buffer, offset2);
        return offset2;
    }

    public boolean booleanValue(int offset2) {
        return this.buffer.get(offset2) != 0;
    }

    public byte byteValue(int offset2) {
        return this.buffer.get(offset2);
    }

    public short shortValue(int offset2) {
        return this.buffer.getShort(offset2);
    }

    public int intValue(int offset2) {
        return this.buffer.getInt(offset2);
    }

    public long longValue(int offset2) {
        return this.buffer.getLong(offset2);
    }

    public float floatValue(int offset2) {
        return this.buffer.getFloat(offset2);
    }

    public double doubleValue(int offset2) {
        return this.buffer.getDouble(offset2);
    }

    public long pointerValue(int offset2) {
        return PointerBuffer.get(this.buffer, offset2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValueASCII(int offset2, int limit) {
        this.buffer.position(offset2);
        this.buffer.limit(limit);
        try {
            String string = MemoryUtil.memASCII(this.buffer);
            return string;
        }
        finally {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValueUTF8(int offset2, int limit) {
        this.buffer.position(offset2);
        this.buffer.limit(limit);
        try {
            String string = MemoryUtil.memUTF8(this.buffer);
            return string;
        }
        finally {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValueUTF16(int offset2, int limit) {
        this.buffer.position(offset2);
        this.buffer.limit(limit);
        try {
            String string = MemoryUtil.memUTF16(this.buffer);
            return string;
        }
        finally {
            this.buffer.clear();
        }
    }
}

