/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.Light;
import com.jme3.light.OrientedBoxProbeArea;
import com.jme3.light.ProbeArea;
import com.jme3.light.SphereProbeArea;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LightProbe
extends Light
implements Savable {
    private static final Logger logger = Logger.getLogger(LightProbe.class.getName());
    public static final Matrix4f FALLBACK_MATRIX = new Matrix4f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
    private Vector3f[] shCoefficients;
    private TextureCubeMap prefilteredEnvMap;
    private ProbeArea area = new SphereProbeArea(Vector3f.ZERO, 1.0f);
    private boolean ready = false;
    private Vector3f position = new Vector3f();
    private int nbMipMaps;

    public TextureCubeMap getPrefilteredEnvMap() {
        return this.prefilteredEnvMap;
    }

    public void setPrefilteredMap(TextureCubeMap prefilteredEnvMap) {
        this.prefilteredEnvMap = prefilteredEnvMap;
    }

    public Matrix4f getUniformMatrix() {
        Matrix4f mat = this.area.getUniformMatrix();
        mat.m33 = (float)this.nbMipMaps + 1.0f / this.area.getRadius();
        return mat;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.shCoefficients, "shCoeffs", null);
        oc.write(this.prefilteredEnvMap, "prefilteredEnvMap", null);
        oc.write(this.position, "position", null);
        oc.write(this.area, "area", new SphereProbeArea(Vector3f.ZERO, 1.0f));
        oc.write(this.ready, "ready", false);
        oc.write(this.nbMipMaps, "nbMipMaps", 0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.prefilteredEnvMap = (TextureCubeMap)ic.readSavable("prefilteredEnvMap", null);
        this.position = (Vector3f)ic.readSavable("position", null);
        this.area = (ProbeArea)ic.readSavable("area", null);
        if (this.area == null) {
            BoundingSphere bounds2 = (BoundingSphere)ic.readSavable("bounds", new BoundingSphere(1.0f, Vector3f.ZERO));
            this.area = new SphereProbeArea(bounds2.getCenter(), bounds2.getRadius());
        }
        this.area.setCenter(this.position);
        this.nbMipMaps = ic.readInt("nbMipMaps", 0);
        this.ready = ic.readBoolean("ready", false);
        Savable[] coeffs = ic.readSavableArray("shCoeffs", null);
        if (coeffs == null) {
            this.ready = false;
            logger.log(Level.WARNING, "LightProbe is missing parameters, it should be recomputed. Please use lightProbeFactory.updateProbe()");
        } else {
            this.shCoefficients = new Vector3f[coeffs.length];
            for (int i = 0; i < coeffs.length; ++i) {
                this.shCoefficients[i] = (Vector3f)coeffs[i];
            }
        }
    }

    @Deprecated
    public BoundingVolume getBounds() {
        return new BoundingSphere(this.area.getRadius(), ((SphereProbeArea)this.area).getCenter());
    }

    public ProbeArea getArea() {
        return this.area;
    }

    public void setAreaType(AreaType type2) {
        switch (type2) {
            case Spherical: {
                this.area = new SphereProbeArea(Vector3f.ZERO, 1.0f);
                break;
            }
            case OrientedBox: {
                this.area = new OrientedBoxProbeArea(new Transform());
            }
        }
        this.area.setCenter(this.position);
    }

    public AreaType getAreaType() {
        if (this.area instanceof SphereProbeArea) {
            return AreaType.Spherical;
        }
        return AreaType.OrientedBox;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public Vector3f[] getShCoeffs() {
        return this.shCoefficients;
    }

    public void setShCoeffs(Vector3f[] shCoefficients) {
        this.shCoefficients = shCoefficients;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position.set(position);
        this.area.setCenter(position);
    }

    public int getNbMipMaps() {
        return this.nbMipMaps;
    }

    public void setNbMipMaps(int nbMipMaps) {
        this.nbMipMaps = nbMipMaps;
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        return this.area.intersectsBox(box, vars);
    }

    @Override
    public boolean intersectsFrustum(Camera camera, TempVars vars) {
        return this.area.intersectsFrustum(camera, vars);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere sphere, TempVars vars) {
        return this.area.intersectsSphere(sphere, vars);
    }

    @Override
    protected void computeLastDistance(Spatial owner2) {
        if (owner2.getWorldBound() != null) {
            BoundingVolume bv = owner2.getWorldBound();
            this.lastDistance = bv.distanceSquaredTo(this.position);
        } else {
            this.lastDistance = owner2.getWorldTranslation().distanceSquared(this.position);
        }
    }

    @Override
    public Light.Type getType() {
        return Light.Type.Probe;
    }

    public String toString() {
        return "Light Probe : " + this.name + " at " + this.position + " / " + this.area;
    }

    public static enum AreaType {
        Spherical,
        OrientedBox;

    }
}

