/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.math.Vector2f;
import com.jme3.system.lwjgl.LwjglWindow;
import com.jme3.system.lwjgl.WindowSizeListener;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.system.MemoryStack;

public class GlfwMouseInput
implements MouseInput {
    private static final Logger logger = Logger.getLogger(GlfwMouseInput.class.getName());
    private static final int WHEEL_SCALE = 120;
    private final Map<JmeCursor, long[]> jmeToGlfwCursorMap = new HashMap<JmeCursor, long[]>();
    private final Queue<MouseMotionEvent> mouseMotionEvents = new ArrayDeque<MouseMotionEvent>();
    private final Queue<MouseButtonEvent> mouseButtonEvents = new ArrayDeque<MouseButtonEvent>();
    private final LwjglWindow context;
    private WindowSizeListener windowSizeListener;
    private RawInputListener listener;
    private IntBuffer currentCursorDelays;
    private GLFWCursorPosCallback cursorPosCallback;
    private GLFWScrollCallback scrollCallback;
    private GLFWMouseButtonCallback mouseButtonCallback;
    private long[] currentCursor;
    private double currentCursorFrameStartTime = 0.0;
    private int currentCursorFrame = 0;
    private int mouseX;
    private int mouseY;
    private int mouseWheel;
    private int currentHeight;
    private boolean cursorVisible;
    private boolean initialized;
    private final Vector2f inputScale = new Vector2f();

    private static long[] createGlfwCursor(JmeCursor jmeCursor) {
        long[] cursorArray = new long[jmeCursor.getNumImages()];
        for (int i = 0; i < jmeCursor.getNumImages(); ++i) {
            ByteBuffer buffer = GlfwMouseInput.transformCursorImage(jmeCursor.getImagesData(), jmeCursor.getWidth(), jmeCursor.getHeight(), i);
            GLFWImage glfwImage = new GLFWImage(BufferUtils.createByteBuffer(GLFWImage.SIZEOF));
            glfwImage.set(jmeCursor.getWidth(), jmeCursor.getHeight(), buffer);
            int hotspotX = jmeCursor.getXHotSpot();
            int hotspotY = jmeCursor.getHeight() - jmeCursor.getYHotSpot();
            cursorArray[i] = GLFW.glfwCreateCursor(glfwImage, hotspotX, hotspotY);
        }
        return cursorArray;
    }

    private static ByteBuffer transformCursorImage(IntBuffer imageData, int width2, int height2, int index2) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(width2 * height2 * 4);
        for (int y2 = height2 - 1; y2 >= 0; --y2) {
            for (int x2 = 0; x2 < width2; ++x2) {
                int pixel = imageData.get(width2 * height2 * index2 + y2 * width2 + x2);
                byteBuffer.put((byte)(pixel >> 16 & 0xFF));
                byteBuffer.put((byte)(pixel >> 8 & 0xFF));
                byteBuffer.put((byte)(pixel & 0xFF));
                byteBuffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public GlfwMouseInput(LwjglWindow context2) {
        this.context = context2;
        this.cursorVisible = true;
    }

    private void onCursorPos(long window, double xpos, double ypos) {
        this.context.getWindowContentScale(this.inputScale);
        int x2 = (int)Math.round(xpos * (double)this.inputScale.x);
        int y2 = (int)Math.round(((double)this.currentHeight - ypos) * (double)this.inputScale.y);
        int xDelta = x2 - this.mouseX;
        int yDelta = y2 - this.mouseY;
        this.mouseX = x2;
        this.mouseY = y2;
        if (xDelta != 0 || yDelta != 0) {
            MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(x2, y2, xDelta, yDelta, this.mouseWheel, 0);
            mouseMotionEvent.setTime(this.getInputTimeNanos());
            this.mouseMotionEvents.add(mouseMotionEvent);
        }
    }

    private void onWheelScroll(long window, double xOffset, double yOffset) {
        this.mouseWheel = (int)((double)this.mouseWheel + yOffset);
        MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(this.mouseX, this.mouseY, 0, 0, this.mouseWheel, (int)Math.round(yOffset));
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        this.mouseMotionEvents.add(mouseMotionEvent);
    }

    private void onMouseButton(long window, int button, int action, int mods) {
        boolean pressed = action == 1;
        MouseButtonEvent mouseButtonEvent = new MouseButtonEvent(this.convertButton(button), pressed, this.mouseX, this.mouseY);
        mouseButtonEvent.setTime(this.getInputTimeNanos());
        this.mouseButtonEvents.add(mouseButtonEvent);
    }

    @Override
    public void initialize() {
        this.initCallbacks();
        if (this.listener != null) {
            this.sendFirstMouseEvent();
        }
        this.setCursorVisible(this.cursorVisible);
        logger.fine("Mouse created.");
        this.initialized = true;
    }

    public void resetContext() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.closeCallbacks();
        this.initCallbacks();
    }

    private void initCallbacks() {
        long window = this.context.getWindowHandle();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width3 = stack.callocInt(1);
            IntBuffer height3 = stack.callocInt(1);
            GLFW.glfwGetWindowSize(window, width3, height3);
            width3.get();
            this.currentHeight = height3.get();
        }
        this.initCurrentMousePosition(window);
        this.cursorPosCallback = new GLFWCursorPosCallback(){

            @Override
            public void invoke(long window, double xpos, double ypos) {
                GlfwMouseInput.this.onCursorPos(window, xpos, ypos);
            }
        };
        GLFW.glfwSetCursorPosCallback(window, this.cursorPosCallback);
        this.scrollCallback = new GLFWScrollCallback(){

            @Override
            public void invoke(long window, double xOffset, double yOffset) {
                GlfwMouseInput.this.onWheelScroll(window, xOffset, yOffset * 120.0);
            }
        };
        GLFW.glfwSetScrollCallback(window, this.scrollCallback);
        this.mouseButtonCallback = new GLFWMouseButtonCallback(){

            @Override
            public void invoke(long window, int button, int action, int mods) {
                GlfwMouseInput.this.onMouseButton(window, button, action, mods);
            }
        };
        GLFW.glfwSetMouseButtonCallback(window, this.mouseButtonCallback);
        this.windowSizeListener = (width2, height2) -> {
            this.currentHeight = height2;
        };
        this.context.registerWindowSizeListener(this.windowSizeListener);
    }

    private void initCurrentMousePosition(long window) {
        double[] x2 = new double[1];
        double[] y2 = new double[1];
        GLFW.glfwGetCursorPos(window, x2, y2);
        this.context.getWindowContentScale(this.inputScale);
        this.mouseX = (int)Math.round(x2[0] * (double)this.inputScale.x);
        this.mouseY = (int)Math.round(((double)this.currentHeight - y2[0]) * (double)this.inputScale.y);
    }

    private void sendFirstMouseEvent() {
        assert (this.listener != null);
        int xDelta = 0;
        int yDelta = 0;
        int wheelDelta = 0;
        MouseMotionEvent evt = new MouseMotionEvent(this.mouseX, this.mouseY, xDelta, yDelta, this.mouseWheel, wheelDelta);
        evt.setTime(this.getInputTimeNanos());
        this.listener.onMouseMotionEvent(evt);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public int getButtonCount() {
        return 8;
    }

    @Override
    public void update() {
        if (this.currentCursor != null && this.currentCursor.length > 1) {
            double now = GLFW.glfwGetTime();
            double frameTime = (GLFW.glfwGetTime() - this.currentCursorFrameStartTime) * 1000.0;
            if (this.currentCursorDelays == null || frameTime >= (double)this.currentCursorDelays.get(this.currentCursorFrame)) {
                ++this.currentCursorFrame;
                this.currentCursorFrame %= this.currentCursor.length;
                this.currentCursorFrameStartTime = now;
                GLFW.glfwSetCursor(this.context.getWindowHandle(), this.currentCursor[this.currentCursorFrame]);
            }
        }
        while (!this.mouseMotionEvents.isEmpty()) {
            this.listener.onMouseMotionEvent(this.mouseMotionEvents.poll());
        }
        while (!this.mouseButtonEvents.isEmpty()) {
            this.listener.onMouseButtonEvent(this.mouseButtonEvents.poll());
        }
    }

    @Override
    public void destroy() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.closeCallbacks();
        this.currentCursor = null;
        this.currentCursorDelays = null;
        for (long[] glfwCursors : this.jmeToGlfwCursorMap.values()) {
            for (long glfwCursor : glfwCursors) {
                GLFW.glfwDestroyCursor(glfwCursor);
            }
        }
        this.jmeToGlfwCursorMap.clear();
        logger.fine("Mouse destroyed.");
    }

    private void closeCallbacks() {
        this.cursorPosCallback.close();
        this.scrollCallback.close();
        this.mouseButtonCallback.close();
        this.context.removeWindowSizeListener(this.windowSizeListener);
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
        if (!this.context.isRenderable()) {
            return;
        }
        if (this.cursorVisible) {
            GLFW.glfwSetInputMode(this.context.getWindowHandle(), 208897, 212993);
        } else {
            GLFW.glfwSetInputMode(this.context.getWindowHandle(), 208897, 212995);
        }
    }

    @Override
    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
        if (listener != null && this.initialized) {
            this.sendFirstMouseEvent();
        }
    }

    @Override
    public long getInputTimeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    @Override
    public void setNativeCursor(JmeCursor jmeCursor) {
        if (jmeCursor != null) {
            long[] glfwCursor = this.jmeToGlfwCursorMap.computeIfAbsent(jmeCursor, GlfwMouseInput::createGlfwCursor);
            this.currentCursorFrame = 0;
            this.currentCursor = glfwCursor;
            this.currentCursorDelays = null;
            this.currentCursorFrameStartTime = GLFW.glfwGetTime();
            if (jmeCursor.getImagesDelay() != null) {
                this.currentCursorDelays = jmeCursor.getImagesDelay();
            }
            GLFW.glfwSetCursor(this.context.getWindowHandle(), glfwCursor[this.currentCursorFrame]);
        } else {
            this.currentCursor = null;
            this.currentCursorDelays = null;
            GLFW.glfwSetCursor(this.context.getWindowHandle(), 0L);
        }
    }

    private int convertButton(int glfwButton) {
        switch (glfwButton) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return glfwButton;
    }
}

