/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.input.AbstractJoystick;
import com.jme3.input.DefaultJoystickAxis;
import com.jme3.input.DefaultJoystickButton;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.JoystickButton;
import com.jme3.input.JoystickCompatibilityMappings;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;

public class GlfwJoystickInput
implements JoyInput {
    private static final Logger LOGGER = Logger.getLogger(GlfwJoystickInput.class.getName());
    private RawInputListener listener;
    private final Map<Integer, GlfwJoystick> joysticks = new HashMap<Integer, GlfwJoystick>();
    private final Map<JoystickButton, Boolean> joyButtonPressed = new HashMap<JoystickButton, Boolean>();
    private boolean initialized = false;

    @Override
    public void setJoyRumble(int joyId, float amount) {
        if (joyId >= this.joysticks.size()) {
            throw new IllegalArgumentException();
        }
    }

    public void fireJoystickConnectedEvent(int jid) {
        Joystick joystick = this.joysticks.get(jid);
        ((InputManager)this.listener).fireJoystickConnectedEvent(joystick);
    }

    public void fireJoystickDisconnectedEvent(int jid) {
        Joystick joystick = this.joysticks.get(jid);
        ((InputManager)this.listener).fireJoystickDisconnectedEvent(joystick);
    }

    public void reloadJoysticks() {
        this.joysticks.clear();
        InputManager inputManager = (InputManager)this.listener;
        Joystick[] joysticks = this.loadJoysticks(inputManager);
        inputManager.setJoysticks(joysticks);
    }

    @Override
    public Joystick[] loadJoysticks(InputManager inputManager) {
        for (int i = 0; i < 15; ++i) {
            if (!GLFW.glfwJoystickPresent(i)) continue;
            String name = GLFW.glfwGetJoystickName(i);
            GlfwJoystick joystick = new GlfwJoystick(inputManager, this, i, name);
            this.joysticks.put(i, joystick);
            FloatBuffer floatBuffer = GLFW.glfwGetJoystickAxes(i);
            int axisIndex = 0;
            while (floatBuffer.hasRemaining()) {
                floatBuffer.get();
                String logicalId = JoystickCompatibilityMappings.remapAxis(joystick.getName(), this.convertAxisIndex(axisIndex));
                DefaultJoystickAxis joystickAxis = new DefaultJoystickAxis(inputManager, joystick, axisIndex, this.convertAxisIndex(axisIndex), logicalId, true, false, 0.0f);
                joystick.addAxis(axisIndex, joystickAxis);
                ++axisIndex;
            }
            ByteBuffer byteBuffer = GLFW.glfwGetJoystickButtons(i);
            if (byteBuffer == null) continue;
            int buttonIndex = 0;
            while (byteBuffer.hasRemaining()) {
                byteBuffer.get();
                String logicalId = JoystickCompatibilityMappings.remapButton(joystick.getName(), String.valueOf(buttonIndex));
                DefaultJoystickButton button = new DefaultJoystickButton(inputManager, joystick, buttonIndex, String.valueOf(buttonIndex), logicalId);
                joystick.addButton(button);
                this.joyButtonPressed.put(button, false);
                ++buttonIndex;
            }
        }
        return this.joysticks.values().toArray(new GlfwJoystick[this.joysticks.size()]);
    }

    private String convertAxisIndex(int index2) {
        if (index2 == 0) {
            return "pov_x";
        }
        if (index2 == 1) {
            return "pov_y";
        }
        if (index2 == 2) {
            return "z";
        }
        if (index2 == 3) {
            return "rz";
        }
        return String.valueOf(index2);
    }

    @Override
    public void initialize() {
        this.initialized = true;
    }

    @Override
    public void update() {
        for (Map.Entry<Integer, GlfwJoystick> entry : this.joysticks.entrySet()) {
            ByteBuffer byteBuffer;
            FloatBuffer axisValues = GLFW.glfwGetJoystickAxes(entry.getKey());
            if (axisValues != null) {
                for (JoystickAxis axis : entry.getValue().getAxes()) {
                    float rawValue = axisValues.get(axis.getAxisId());
                    float value = JoystickCompatibilityMappings.remapAxisRange(axis, rawValue);
                    this.listener.onJoyAxisEvent(new JoyAxisEvent(axis, value, rawValue));
                }
            }
            if ((byteBuffer = GLFW.glfwGetJoystickButtons(entry.getKey())) == null) continue;
            for (JoystickButton button : entry.getValue().getButtons()) {
                boolean pressed;
                boolean bl = pressed = byteBuffer.get(button.getButtonId()) == 1;
                if (this.joyButtonPressed.get(button) == pressed) continue;
                this.joyButtonPressed.put(button, pressed);
                this.listener.onJoyButtonEvent(new JoyButtonEvent(button, pressed));
            }
        }
    }

    @Override
    public void destroy() {
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    @Override
    public long getInputTimeNanos() {
        return 0L;
    }

    protected class GlfwJoystick
    extends AbstractJoystick {
        private JoystickAxis povAxisX;
        private JoystickAxis povAxisY;

        public GlfwJoystick(InputManager inputManager, JoyInput joyInput, int joyId, String name) {
            super(inputManager, joyInput, joyId, name);
        }

        public void addAxis(int index2, JoystickAxis axis) {
            super.addAxis(axis);
            if (index2 == 0) {
                this.povAxisX = axis;
            } else if (index2 == 1) {
                this.povAxisY = axis;
            }
        }

        @Override
        protected void addButton(JoystickButton button) {
            super.addButton(button);
        }

        @Override
        public JoystickAxis getXAxis() {
            return this.povAxisX;
        }

        @Override
        public JoystickAxis getYAxis() {
            return this.povAxisY;
        }

        @Override
        public JoystickAxis getPovXAxis() {
            return this.povAxisX;
        }

        @Override
        public JoystickAxis getPovYAxis() {
            return this.povAxisY;
        }

        @Override
        public int getXAxisIndex() {
            return this.povAxisX.getAxisId();
        }

        @Override
        public int getYAxisIndex() {
            return this.povAxisY.getAxisId();
        }
    }
}

