/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.controls;

import com.jme3.input.controls.Trigger;

public class MouseAxisTrigger
implements Trigger {
    private int mouseAxis;
    private boolean negative;

    public MouseAxisTrigger(int mouseAxis, boolean negative) {
        if (mouseAxis < 0 || mouseAxis > 2) {
            throw new IllegalArgumentException("Mouse Axis must be between 0 and 2");
        }
        this.mouseAxis = mouseAxis;
        this.negative = negative;
    }

    public int getMouseAxis() {
        return this.mouseAxis;
    }

    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public String getName() {
        String sign2 = this.negative ? "Negative" : "Positive";
        switch (this.mouseAxis) {
            case 0: {
                return "Mouse X Axis " + sign2;
            }
            case 1: {
                return "Mouse Y Axis " + sign2;
            }
            case 2: {
                return "Mouse Wheel " + sign2;
            }
        }
        throw new AssertionError();
    }

    public static int mouseAxisHash(int mouseAxis, boolean negative) {
        assert (mouseAxis >= 0 && mouseAxis <= 255);
        return (negative ? 768 : 512) | mouseAxis & 0xFF;
    }

    @Override
    public int triggerHashCode() {
        return MouseAxisTrigger.mouseAxisHash(this.mouseAxis, this.negative);
    }
}

