/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.font.BitmapCharacter;
import com.jme3.font.BitmapCharacterSet;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.texture.Texture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BitmapFontLoader
implements AssetLoader {
    private BitmapFont load(AssetManager assetManager2, String folder, InputStream in) throws IOException {
        String line;
        MaterialDef spriteMat = (MaterialDef)assetManager2.loadAsset(new AssetKey("Common/MatDefs/Misc/Unshaded.j3md"));
        BitmapCharacterSet charSet = new BitmapCharacterSet();
        Material[] matPages = null;
        BitmapFont font = new BitmapFont();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String regex = "[\\s=]+";
        font.setCharSet(charSet);
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(regex);
            if (tokens[0].equals("info")) {
                for (int i = 1; i < tokens.length; ++i) {
                    if (!tokens[i].equals("size")) continue;
                    charSet.setRenderedSize(Integer.parseInt(tokens[i + 1]));
                }
                continue;
            }
            if (tokens[0].equals("common")) {
                for (int i = 1; i < tokens.length; ++i) {
                    String token2 = tokens[i];
                    if (token2.equals("lineHeight")) {
                        charSet.setLineHeight(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token2.equals("base")) {
                        charSet.setBase(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token2.equals("scaleW")) {
                        charSet.setWidth(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token2.equals("scaleH")) {
                        charSet.setHeight(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (!token2.equals("pages")) continue;
                    matPages = new Material[Integer.parseInt(tokens[i + 1])];
                    font.setPages(matPages);
                }
                continue;
            }
            if (tokens[0].equals("page")) {
                int index2 = -1;
                Texture tex = null;
                for (int i = 1; i < tokens.length; ++i) {
                    String token3 = tokens[i];
                    if (token3.equals("id")) {
                        index2 = Integer.parseInt(tokens[i + 1]);
                        continue;
                    }
                    if (!token3.equals("file")) continue;
                    String file = tokens[i + 1];
                    if (file.startsWith("\"")) {
                        file = file.substring(1, file.length() - 1);
                    }
                    TextureKey key = new TextureKey(folder + file, true);
                    key.setGenerateMips(false);
                    tex = assetManager2.loadTexture(key);
                    tex.setMagFilter(Texture.MagFilter.Bilinear);
                    tex.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                }
                if (index2 < 0 || tex == null) continue;
                Material mat = new Material(spriteMat);
                mat.setTexture("ColorMap", tex);
                mat.setBoolean("VertexColor", true);
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                matPages[index2] = mat;
                continue;
            }
            if (tokens[0].equals("char")) {
                BitmapCharacter ch = null;
                for (int i = 1; i < tokens.length; ++i) {
                    String token4 = tokens[i];
                    if (token4.equals("id")) {
                        int index3 = Integer.parseInt(tokens[i + 1]);
                        ch = new BitmapCharacter();
                        charSet.addCharacter(index3, ch);
                        continue;
                    }
                    if (token4.equals("x")) {
                        ch.setX(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token4.equals("y")) {
                        ch.setY(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token4.equals("width")) {
                        ch.setWidth(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token4.equals("height")) {
                        ch.setHeight(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token4.equals("xoffset")) {
                        ch.setXOffset(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token4.equals("yoffset")) {
                        ch.setYOffset(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (token4.equals("xadvance")) {
                        ch.setXAdvance(Integer.parseInt(tokens[i + 1]));
                        continue;
                    }
                    if (!token4.equals("page")) continue;
                    ch.setPage(Integer.parseInt(tokens[i + 1]));
                }
                continue;
            }
            if (!tokens[0].equals("kerning")) continue;
            int index4 = 0;
            int second2 = 0;
            int amount = 0;
            for (int i = 1; i < tokens.length; ++i) {
                if (tokens[i].equals("first")) {
                    index4 = Integer.parseInt(tokens[i + 1]);
                    continue;
                }
                if (tokens[i].equals("second")) {
                    second2 = Integer.parseInt(tokens[i + 1]);
                    continue;
                }
                if (!tokens[i].equals("amount")) continue;
                amount = Integer.parseInt(tokens[i + 1]);
            }
            BitmapCharacter ch = charSet.getCharacter(index4);
            ch.addKerning(second2, amount);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info2) throws IOException {
        try (InputStream in = null;){
            BitmapFont font;
            in = info2.openStream();
            BitmapFont bitmapFont = font = this.load(info2.getManager(), info2.getKey().getFolder(), in);
            return bitmapFont;
        }
    }
}

