/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.font.BitmapFont;
import com.jme3.font.LineWrapMode;
import com.jme3.font.Rectangle;
import com.jme3.math.ColorRGBA;

class StringBlock
implements Cloneable {
    private String text;
    private Rectangle textBox;
    private BitmapFont.Align alignment = BitmapFont.Align.Left;
    private BitmapFont.VAlign vAlignment = BitmapFont.VAlign.Top;
    private float size;
    private ColorRGBA color = new ColorRGBA(ColorRGBA.White);
    private boolean kerning;
    private int lineCount;
    private LineWrapMode wrapType = LineWrapMode.Word;
    private float[] tabPos;
    private float tabWidth = 50.0f;
    private char ellipsisChar = (char)8230;

    StringBlock(String text2, Rectangle textBox, BitmapFont.Align alignment, float size2, ColorRGBA color2, boolean kerning) {
        this.text = text2;
        this.textBox = textBox;
        this.alignment = alignment;
        this.size = size2;
        this.color.set(color2);
        this.kerning = kerning;
    }

    StringBlock() {
        this.text = "";
        this.textBox = null;
        this.alignment = BitmapFont.Align.Left;
        this.size = 100.0f;
        this.color.set(ColorRGBA.White);
        this.kerning = true;
    }

    public StringBlock clone() {
        try {
            StringBlock clone2 = (StringBlock)super.clone();
            clone2.color = this.color.clone();
            if (this.textBox != null) {
                clone2.textBox = this.textBox.clone();
            }
            return clone2;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    String getText() {
        return this.text;
    }

    void setText(String text2) {
        this.text = text2 == null ? "" : text2;
    }

    Rectangle getTextBox() {
        return this.textBox;
    }

    void setTextBox(Rectangle textBox) {
        this.textBox = textBox;
    }

    BitmapFont.Align getAlignment() {
        return this.alignment;
    }

    BitmapFont.VAlign getVerticalAlignment() {
        return this.vAlignment;
    }

    void setAlignment(BitmapFont.Align alignment) {
        this.alignment = alignment;
    }

    void setVerticalAlignment(BitmapFont.VAlign alignment) {
        this.vAlignment = alignment;
    }

    float getSize() {
        return this.size;
    }

    void setSize(float size2) {
        this.size = size2;
    }

    ColorRGBA getColor() {
        return this.color;
    }

    void setColor(ColorRGBA color2) {
        this.color.set(color2);
    }

    boolean isKerning() {
        return this.kerning;
    }

    void setKerning(boolean kerning) {
        this.kerning = kerning;
    }

    int getLineCount() {
        return this.lineCount;
    }

    void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    LineWrapMode getLineWrapMode() {
        return this.wrapType;
    }

    void setLineWrapMode(LineWrapMode wrap) {
        this.wrapType = wrap;
    }

    void setTabWidth(float tabWidth) {
        this.tabWidth = tabWidth;
    }

    void setTabPosition(float[] tabs) {
        this.tabPos = tabs;
    }

    float getTabWidth() {
        return this.tabWidth;
    }

    float[] getTabPosition() {
        return this.tabPos;
    }

    void setEllipsisChar(char c) {
        this.ellipsisChar = c;
    }

    int getEllipsisChar() {
        return this.ellipsisChar;
    }
}

