/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.font.BitmapFont;
import com.jme3.font.ColorTags;
import com.jme3.font.LetterQuad;
import com.jme3.font.StringBlock;
import com.jme3.math.ColorRGBA;
import java.util.LinkedList;

class Letters {
    private final LetterQuad head;
    private final LetterQuad tail;
    private final BitmapFont font;
    private LetterQuad current;
    private final StringBlock block;
    private float totalWidth;
    private float totalHeight;
    private final ColorTags colorTags = new ColorTags();
    private ColorRGBA baseColor = null;
    private float baseAlpha = -1.0f;
    private String plainText;

    Letters(BitmapFont font, StringBlock bound, boolean rightToLeft) {
        String text2 = bound.getText();
        this.block = bound;
        this.font = font;
        this.head = new LetterQuad(font, rightToLeft);
        this.tail = new LetterQuad(font, rightToLeft);
        this.setText(text2);
    }

    void setText(String text2) {
        LinkedList<ColorTags.Range> ranges;
        this.colorTags.setText(text2);
        this.plainText = this.colorTags.getPlainText();
        this.head.setNext(this.tail);
        this.tail.setPrevious(this.head);
        this.current = this.head;
        if (text2 != null && this.plainText.length() > 0) {
            LetterQuad l = this.head;
            CharSequence characters = this.plainText;
            if (this.font.getGlyphParser() != null) {
                characters = this.font.getGlyphParser().parse(this.plainText);
            }
            for (int i = 0; i < characters.length(); ++i) {
                l = l.addNextCharacter(characters.charAt(i));
                if (this.baseColor == null) continue;
                l.setColor(this.baseColor);
            }
        }
        if (!(ranges = this.colorTags.getTags()).isEmpty()) {
            for (int i = 0; i < ranges.size() - 1; ++i) {
                ColorTags.Range start2 = ranges.get(i);
                ColorTags.Range end2 = ranges.get(i + 1);
                this.setColor(start2.start, end2.start, start2.color);
            }
            ColorTags.Range end3 = ranges.getLast();
            this.setColor(end3.start, this.plainText.length(), end3.color);
        }
        this.invalidate();
    }

    LetterQuad getHead() {
        return this.head;
    }

    LetterQuad getTail() {
        return this.tail;
    }

    /*
     * Unable to fully structure code
     */
    void update() {
        l = this.head;
        lineCount = 1;
        ellipsis = this.font.getCharSet().getCharacter(this.block.getEllipsisChar());
        v0 = ellipsisWidth = ellipsis != null ? (float)ellipsis.getWidth() * this.getScale() : 0.0f;
        while (!l.isTail()) {
            block17: {
                block16: {
                    if (!l.isInvalid()) break block16;
                    l.update(this.block);
                    if (!l.isInvalid(this.block)) break block17;
                    switch (1.$SwitchMap$com$jme3$font$LineWrapMode[this.block.getLineWrapMode().ordinal()]) {
                        case 1: {
                            this.lineWrap(l);
                            ++lineCount;
                            ** break;
                        }
                        case 2: {
                            if (l.isBlank()) ** break;
                            blank = l;
                            while (!blank.isBlank()) {
                                if (blank.isLineStart() || blank.isHead()) {
                                    this.lineWrap(l);
                                    ++lineCount;
                                    blank = null;
                                    break;
                                }
                                blank = blank.getPrevious();
                            }
                            if (blank != null) {
                                blank.setEndOfLine();
                                ++lineCount;
                                while (blank != l) {
                                    blank = blank.getNext();
                                    blank.invalidate();
                                    blank.update(this.block);
                                }
                            }
                            break block17;
                        }
                        case 3: {
                            cursor = l.getPrevious();
                            while (cursor.isInvalid(this.block, ellipsisWidth) && !cursor.isLineStart()) {
                                cursor = cursor.getPrevious();
                            }
                            cursor.setBitmapChar(ellipsis);
                            cursor.update(this.block);
                            cursor = cursor.getNext();
                            while (!cursor.isTail() && !cursor.isLineFeed()) {
                                cursor.setBitmapChar(null);
                                cursor.update(this.block);
                                cursor = cursor.getNext();
                            }
                            ** break;
                        }
                        case 4: {
                            l.clip(this.block);
                            q = l.getNext();
                            while (!q.isTail() && !q.isLineFeed()) {
                                q.setBitmapChar(null);
                                q.update(this.block);
                                q = q.getNext();
                            }
                            ** break;
                        }
                    }
lbl58:
                    // 5 sources

                    break block17;
                }
                if (this.current.isInvalid(this.block)) {
                    this.invalidate(this.current);
                }
            }
            if (l.isEndOfLine()) {
                ++lineCount;
            }
            l = l.getNext();
        }
        this.block.setLineCount(lineCount);
        this.align();
        this.rewind();
    }

    private void align() {
        if (this.block.getTextBox() == null) {
            return;
        }
        BitmapFont.Align alignment = this.block.getAlignment();
        BitmapFont.VAlign valignment = this.block.getVerticalAlignment();
        float width2 = this.block.getTextBox().width;
        float height2 = this.block.getTextBox().height;
        float lineWidth = 0.0f;
        float gapX = 0.0f;
        float gapY = 0.0f;
        this.validateSize();
        if (this.totalHeight < height2) {
            switch (valignment) {
                case Top: {
                    gapY = 0.0f;
                    break;
                }
                case Center: {
                    gapY = (height2 - this.totalHeight) * 0.5f;
                    break;
                }
                case Bottom: {
                    gapY = height2 - this.totalHeight;
                }
            }
        }
        if (this.font.isRightToLeft()) {
            if (alignment == BitmapFont.Align.Right && valignment == BitmapFont.VAlign.Top) {
                return;
            }
            LetterQuad cursor2 = this.tail.getPrevious();
            cursor2.setEndOfLine();
            while (!cursor2.isHead()) {
                if (cursor2.isEndOfLine()) {
                    gapX = alignment == BitmapFont.Align.Left ? this.block.getTextBox().x - cursor2.getX0() : (alignment == BitmapFont.Align.Center ? (this.block.getTextBox().x - cursor2.getX0()) / 2.0f : 0.0f);
                }
                cursor2.setAlignment(gapX, gapY);
                cursor2 = cursor2.getPrevious();
            }
        } else {
            if (alignment == BitmapFont.Align.Left && valignment == BitmapFont.VAlign.Top) {
                return;
            }
            LetterQuad cursor3 = this.tail.getPrevious();
            cursor3.setEndOfLine();
            while (!cursor3.isHead()) {
                if (cursor3.isEndOfLine()) {
                    lineWidth = cursor3.getX1() - this.block.getTextBox().x;
                    gapX = alignment == BitmapFont.Align.Center ? (width2 - lineWidth) / 2.0f : (alignment == BitmapFont.Align.Right ? width2 - lineWidth : 0.0f);
                }
                cursor3.setAlignment(gapX, gapY);
                cursor3 = cursor3.getPrevious();
            }
        }
    }

    private void lineWrap(LetterQuad l) {
        if (l.isHead() || l.isBlank()) {
            return;
        }
        l.getPrevious().setEndOfLine();
        l.invalidate();
        l.update(this.block);
    }

    float getCharacterX0() {
        return this.current.getX0();
    }

    float getCharacterY0() {
        return this.current.getY0();
    }

    float getCharacterX1() {
        return this.current.getX1();
    }

    float getCharacterY1() {
        return this.current.getY1();
    }

    float getCharacterAlignX() {
        return this.current.getAlignX();
    }

    float getCharacterAlignY() {
        return this.current.getAlignY();
    }

    float getCharacterWidth() {
        return this.current.getWidth();
    }

    float getCharacterHeight() {
        return this.current.getHeight();
    }

    public boolean nextCharacter() {
        if (this.current.isTail()) {
            return false;
        }
        this.current = this.current.getNext();
        return true;
    }

    public int getCharacterSetPage() {
        return this.current.getBitmapChar().getPage();
    }

    public LetterQuad getQuad() {
        return this.current;
    }

    public void rewind() {
        this.current = this.head;
    }

    public void invalidate() {
        this.invalidate(this.head);
    }

    public void invalidate(LetterQuad cursor2) {
        this.totalWidth = -1.0f;
        this.totalHeight = -1.0f;
        while (!cursor2.isTail() && !cursor2.isInvalid()) {
            cursor2.invalidate();
            cursor2 = cursor2.getNext();
        }
    }

    float getScale() {
        return this.block.getSize() / (float)this.font.getCharSet().getRenderedSize();
    }

    public boolean isPrintable() {
        return this.current.getBitmapChar() != null;
    }

    float getTotalWidth() {
        this.validateSize();
        return this.totalWidth;
    }

    float getTotalHeight() {
        this.validateSize();
        return this.totalHeight;
    }

    void validateSize() {
        if (this.totalWidth < 0.0f) {
            LetterQuad l = this.head;
            while (!l.isTail()) {
                this.totalWidth = this.font.isRightToLeft() ? Math.max(this.totalWidth, Math.abs(l.getX0())) : Math.max(this.totalWidth, l.getX1());
                l = l.getNext();
            }
        }
        this.totalHeight = this.font.getLineHeight(this.block) * (float)this.block.getLineCount();
    }

    void setStyle(int start2, int end2, int style) {
        LetterQuad cursor2 = this.head.getNext();
        while (!cursor2.isTail()) {
            if (cursor2.getIndex() >= start2 && cursor2.getIndex() < end2) {
                cursor2.setStyle(style);
            }
            cursor2 = cursor2.getNext();
        }
    }

    void setColor(ColorRGBA color2) {
        this.baseColor = color2;
        this.colorTags.setBaseColor(color2);
        this.setColor(0, this.block.getText().length(), color2);
    }

    ColorRGBA getBaseColor() {
        return this.baseColor;
    }

    void setColor(int start2, int end2, ColorRGBA color2) {
        LetterQuad cursor2 = this.head.getNext();
        while (!cursor2.isTail()) {
            if (cursor2.getIndex() >= start2 && cursor2.getIndex() < end2) {
                cursor2.setColor(color2);
            }
            cursor2 = cursor2.getNext();
        }
    }

    float getBaseAlpha() {
        return this.baseAlpha;
    }

    void setBaseAlpha(float alpha2) {
        LinkedList<ColorTags.Range> ranges;
        this.baseAlpha = alpha2;
        this.colorTags.setBaseAlpha(alpha2);
        if (alpha2 == -1.0f) {
            alpha2 = this.baseColor != null ? this.baseColor.a : 1.0f;
        }
        LetterQuad cursor2 = this.head.getNext();
        while (!cursor2.isTail()) {
            cursor2.setAlpha(alpha2);
            cursor2 = cursor2.getNext();
        }
        if (this.baseAlpha == -1.0f && !(ranges = this.colorTags.getTags()).isEmpty()) {
            for (int i = 0; i < ranges.size() - 1; ++i) {
                ColorTags.Range start2 = ranges.get(i);
                ColorTags.Range end2 = ranges.get(i + 1);
                this.setColor(start2.start, end2.start, start2.color);
            }
            ColorTags.Range end3 = ranges.getLast();
            this.setColor(end3.start, this.plainText.length(), end3.color);
        }
        this.invalidate();
    }
}

