/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.font.BitmapCharacter;
import com.jme3.util.IntMap;
import java.io.IOException;

public class BitmapCharacterSet
implements Savable {
    private int lineHeight;
    private int base;
    private int renderedSize;
    private int width;
    private int height;
    private final IntMap<IntMap<BitmapCharacter>> characters = new IntMap();
    private int pageSize;

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.lineHeight, "lineHeight", 0);
        oc.write(this.base, "base", 0);
        oc.write(this.renderedSize, "renderedSize", 0);
        oc.write(this.width, "width", 0);
        oc.write(this.height, "height", 0);
        oc.write(this.pageSize, "pageSize", 0);
        int[] styles = new int[this.characters.size()];
        int index2 = 0;
        for (IntMap.Entry<IntMap<BitmapCharacter>> entry : this.characters) {
            int style;
            styles[index2] = style = entry.getKey();
            ++index2;
            IntMap<BitmapCharacter> charset = entry.getValue();
            this.writeCharset(oc, style, charset);
        }
        oc.write(styles, "styles", (int[])null);
    }

    protected void writeCharset(OutputCapsule oc, int style, IntMap<BitmapCharacter> charset) throws IOException {
        int size2 = charset.size();
        short[] indexes = new short[size2];
        Savable[] chars = new BitmapCharacter[size2];
        int i = 0;
        for (IntMap.Entry<BitmapCharacter> entry : charset) {
            indexes[i] = (short)entry.getKey();
            chars[i] = entry.getValue();
            ++i;
        }
        oc.write(indexes, "indexes" + style, (short[])null);
        oc.write(chars, "chars" + style, null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        int[] styles;
        InputCapsule ic = im.getCapsule(this);
        this.lineHeight = ic.readInt("lineHeight", 0);
        this.base = ic.readInt("base", 0);
        this.renderedSize = ic.readInt("renderedSize", 0);
        this.width = ic.readInt("width", 0);
        this.height = ic.readInt("height", 0);
        this.pageSize = ic.readInt("pageSize", 0);
        for (int style : styles = ic.readIntArray("styles", null)) {
            this.characters.put(style, this.readCharset(ic, style));
        }
    }

    private IntMap<BitmapCharacter> readCharset(InputCapsule ic, int style) throws IOException {
        IntMap<BitmapCharacter> charset = new IntMap<BitmapCharacter>();
        short[] indexes = ic.readShortArray("indexes" + style, null);
        Savable[] chars = ic.readSavableArray("chars" + style, null);
        for (int i = 0; i < indexes.length; ++i) {
            int index2 = indexes[i] & 0xFFFF;
            BitmapCharacter chr = (BitmapCharacter)chars[i];
            charset.put(index2, chr);
        }
        return charset;
    }

    public BitmapCharacter getCharacter(int index2) {
        return this.getCharacter(index2, 0);
    }

    public BitmapCharacter getCharacter(int index2, int style) {
        IntMap<BitmapCharacter> map2 = this.getCharacterSet(style);
        return map2.get(index2);
    }

    private IntMap<BitmapCharacter> getCharacterSet(int style) {
        if (this.characters.size() == 0) {
            this.characters.put(style, new IntMap());
        }
        return this.characters.get(style);
    }

    public void addCharacter(int index2, BitmapCharacter ch) {
        this.getCharacterSet(0).put(index2, ch);
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public int getRenderedSize() {
        return this.renderedSize;
    }

    public void setRenderedSize(int renderedSize) {
        this.renderedSize = renderedSize;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width2) {
        this.width = width2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height2) {
        this.height = height2;
    }

    public void merge(BitmapCharacterSet styleSet) {
        if (this.renderedSize != styleSet.renderedSize) {
            throw new RuntimeException("Only support same font size");
        }
        for (IntMap.Entry<IntMap<BitmapCharacter>> entry : styleSet.characters) {
            int style = entry.getKey();
            if (style == 0) {
                throw new RuntimeException("Style must be set first. use setStyle(int)");
            }
            IntMap<BitmapCharacter> charset = entry.getValue();
            this.lineHeight = Math.max(this.lineHeight, styleSet.lineHeight);
            IntMap<BitmapCharacter> old = this.characters.put(style, charset);
            if (old != null) {
                throw new RuntimeException("Can't override old style");
            }
            for (IntMap.Entry<BitmapCharacter> entry2 : charset) {
                BitmapCharacter ch = entry2.getValue();
                ch.setPage(ch.getPage() + this.pageSize);
            }
        }
        this.pageSize += styleSet.pageSize;
    }

    public void setStyle(int style) {
        if (this.characters.size() > 1) {
            throw new RuntimeException("Applicable only for single style font");
        }
        IntMap.Entry<IntMap<BitmapCharacter>> entry = this.characters.iterator().next();
        IntMap<BitmapCharacter> charset = entry.getValue();
        this.characters.remove(entry.getKey());
        this.characters.put(style, charset);
    }

    void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

