/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.util;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.environment.util.BoundingSphereDebug;
import com.jme3.light.Light;
import com.jme3.light.LightProbe;
import com.jme3.material.Material;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LightsDebugState
extends BaseAppState {
    private Node debugNode;
    private final Map<LightProbe, Node> probeMapping = new HashMap<LightProbe, Node>();
    private final List<LightProbe> garbage = new ArrayList<LightProbe>();
    private Geometry debugGeom;
    private Geometry debugBounds;
    private Material debugMaterial;
    private float probeScale = 1.0f;
    private Spatial scene = null;
    private final List<LightProbe> probes = new ArrayList<LightProbe>();

    @Override
    protected void initialize(Application app) {
        this.debugNode = new Node("Environment debug Node");
        Sphere s = new Sphere(16, 16, 0.15f);
        this.debugGeom = new Geometry("debugEnvProbe", s);
        this.debugMaterial = new Material(app.getAssetManager(), "Common/MatDefs/Misc/reflect.j3md");
        this.debugGeom.setMaterial(this.debugMaterial);
        this.debugBounds = BoundingSphereDebug.createDebugSphere(app.getAssetManager());
        if (this.scene == null) {
            this.scene = app.getViewPort().getScenes().get(0);
        }
    }

    @Override
    public void update(float tpf) {
        if (!this.isEnabled()) {
            return;
        }
        this.updateLights(this.scene);
        this.debugNode.updateLogicalState(tpf);
        this.debugNode.updateGeometricState();
        this.cleanProbes();
    }

    public void updateLights(Spatial scene2) {
        for (Light light : scene2.getWorldLightList()) {
            switch (light.getType()) {
                case Probe: {
                    LightProbe probe = (LightProbe)light;
                    this.probes.add(probe);
                    Node n = this.probeMapping.get(probe);
                    if (n == null) {
                        n = new Node("DebugProbe");
                        n.attachChild(this.debugGeom.clone(true));
                        n.attachChild(this.debugBounds.clone(false));
                        this.debugNode.attachChild(n);
                        this.probeMapping.put(probe, n);
                    }
                    Geometry probeGeom = (Geometry)n.getChild(0);
                    Material m = probeGeom.getMaterial();
                    probeGeom.setLocalScale(this.probeScale);
                    if (probe.isReady()) {
                        m.setTexture("CubeMap", probe.getPrefilteredEnvMap());
                    }
                    n.setLocalTranslation(probe.getPosition());
                    n.getChild(1).setLocalScale(probe.getArea().getRadius());
                    break;
                }
            }
        }
        if (scene2 instanceof Node) {
            Node n = (Node)scene2;
            for (Spatial spatial : n.getChildren()) {
                this.updateLights(spatial);
            }
        }
    }

    public void setScene(Spatial scene2) {
        this.scene = scene2;
    }

    private void cleanProbes() {
        if (this.probes.size() != this.probeMapping.size()) {
            for (LightProbe probe : this.probeMapping.keySet()) {
                if (this.probes.contains(probe)) continue;
                this.garbage.add(probe);
            }
            for (LightProbe probe : this.garbage) {
                this.probeMapping.remove(probe);
            }
            this.garbage.clear();
            this.probes.clear();
        }
    }

    @Override
    public void render(RenderManager rm) {
        if (!this.isEnabled()) {
            return;
        }
        rm.renderScene(this.debugNode, this.getApplication().getViewPort());
    }

    public float getProbeScale() {
        return this.probeScale;
    }

    public void setProbeScale(float probeScale) {
        this.probeScale = probeScale;
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
    }

    @Override
    protected void onDisable() {
    }
}

