/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment.generation;

import com.jme3.app.Application;
import com.jme3.environment.generation.JobProgressListener;
import com.jme3.environment.generation.RunnableWithProgress;
import com.jme3.environment.util.CubeMapWrapper;
import com.jme3.environment.util.EnvMapUtils;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.texture.TextureCubeMap;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class PrefilteredEnvMapFaceGenerator
extends RunnableWithProgress {
    private static final Logger log = Logger.getLogger(PrefilteredEnvMapFaceGenerator.class.getName());
    private int targetMapSize;
    private EnvMapUtils.FixSeamsMethod fixSeamsMethod;
    private EnvMapUtils.GenerationType genType;
    private TextureCubeMap sourceMap;
    private TextureCubeMap store;
    private final Application app;
    private int face = 0;
    Vector4f Xi = new Vector4f();
    Vector3f H = new Vector3f();
    Vector3f tmp = new Vector3f();
    ColorRGBA c = new ColorRGBA();
    Vector3f tmp1 = new Vector3f();
    Vector3f tmp2 = new Vector3f();
    Vector3f tmp3 = new Vector3f();

    public PrefilteredEnvMapFaceGenerator(Application app, int face, JobProgressListener<Integer> listener) {
        super(listener);
        this.app = app;
        this.face = face;
    }

    public void setGenerationParam(TextureCubeMap sourceMap, int targetMapSize, EnvMapUtils.FixSeamsMethod fixSeamsMethod, EnvMapUtils.GenerationType genType, TextureCubeMap store) {
        this.sourceMap = sourceMap;
        this.targetMapSize = targetMapSize;
        this.fixSeamsMethod = fixSeamsMethod;
        this.store = store;
        this.genType = genType;
        this.init();
    }

    private void init() {
        this.Xi.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.H.set(0.0f, 0.0f, 0.0f);
        this.tmp.set(0.0f, 0.0f, 0.0f);
        this.c.set(1.0f, 1.0f, 1.0f, 1.0f);
        this.tmp1.set(0.0f, 0.0f, 0.0f);
        this.tmp2.set(0.0f, 0.0f, 0.0f);
        this.tmp3.set(0.0f, 0.0f, 0.0f);
        this.reset();
    }

    @Override
    public void run() {
        this.app.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PrefilteredEnvMapFaceGenerator.this.listener.start();
                return null;
            }
        });
        this.store = this.generatePrefilteredEnvMap(this.sourceMap, this.targetMapSize, this.fixSeamsMethod, this.store);
        this.app.enqueue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PrefilteredEnvMapFaceGenerator.this.listener.done(PrefilteredEnvMapFaceGenerator.this.face);
                return null;
            }
        });
    }

    private TextureCubeMap generatePrefilteredEnvMap(TextureCubeMap sourceEnvMap, int targetMapSize, EnvMapUtils.FixSeamsMethod fixSeamsMethod, TextureCubeMap store) {
        try {
            TextureCubeMap pem = store;
            int nbMipMap = store.getImage().getMipMapSizes().length;
            this.setEnd(nbMipMap);
            if (!sourceEnvMap.getImage().hasMipmaps() || sourceEnvMap.getImage().getMipMapSizes().length < nbMipMap) {
                throw new IllegalArgumentException("The input cube map must have at least " + nbMipMap + "mip maps");
            }
            CubeMapWrapper sourceWrapper = new CubeMapWrapper(sourceEnvMap);
            CubeMapWrapper targetWrapper = new CubeMapWrapper(pem);
            Vector3f texelVect = new Vector3f();
            Vector3f color2 = new Vector3f();
            ColorRGBA outColor = new ColorRGBA();
            int targetMipMapSize = targetMapSize;
            for (int mipLevel = 0; mipLevel < nbMipMap; ++mipLevel) {
                float roughness = EnvMapUtils.getRoughnessFromMip(mipLevel, nbMipMap);
                int nbSamples = EnvMapUtils.getSampleFromMip(mipLevel, nbMipMap);
                for (int y2 = 0; y2 < targetMipMapSize; ++y2) {
                    for (int x2 = 0; x2 < targetMipMapSize; ++x2) {
                        color2.set(0.0f, 0.0f, 0.0f);
                        EnvMapUtils.getVectorFromCubemapFaceTexCoord(x2, y2, targetMipMapSize, this.face, texelVect, fixSeamsMethod);
                        this.prefilterEnvMapTexel(sourceWrapper, roughness, texelVect, nbSamples, mipLevel, color2);
                        outColor.set(Math.max(color2.x, 1.0E-4f), Math.max(color2.y, 1.0E-4f), Math.max(color2.z, 1.0E-4f), 1.0f);
                        targetWrapper.setPixel(x2, y2, this.face, mipLevel, outColor);
                    }
                }
                targetMipMapSize /= 2;
                this.progress();
            }
            return pem;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Vector3f prefilterEnvMapTexel(CubeMapWrapper envMapReader, float roughness, Vector3f N, int numSamples, int mipLevel, Vector3f store) {
        Vector3f prefilteredColor = store;
        float totalWeight = 0.0f;
        int nbRotations = 1;
        if (this.genType == EnvMapUtils.GenerationType.HighQuality) {
            nbRotations = numSamples == 1 ? 1 : 18;
        }
        float rad = (float)Math.PI * 2 / (float)nbRotations;
        float gi = (float)((double)FastMath.abs(N.z + N.x) * 256.0);
        float offset2 = rad * (FastMath.cos(gi * 0.5f % ((float)Math.PI * 2)) * 0.5f + 0.5f);
        float a2 = roughness * roughness;
        a2 *= a2;
        Vector3f upVector = Vector3f.UNIT_X;
        if ((double)FastMath.abs(N.z) < 0.999) {
            upVector = Vector3f.UNIT_Y;
        }
        Vector3f tangentX = this.tmp1.set(upVector).crossLocal(N).normalizeLocal();
        Vector3f tangentY = this.tmp2.set(N).crossLocal(tangentX);
        Vector3f V = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f lWorld = new Vector3f();
        for (int i = 0; i < numSamples; ++i) {
            this.Xi = EnvMapUtils.getHammersleyPoint(i, numSamples, this.Xi);
            this.H = this.importanceSampleGGX(this.Xi, a2, this.H);
            this.H.normalizeLocal();
            float VoH = this.H.z;
            Vector3f L = this.H.multLocal(VoH * 2.0f).subtractLocal(V);
            float NoL = L.z;
            float computedMipLevel = mipLevel;
            if (mipLevel != 0) {
                computedMipLevel = this.computeMipLevel(roughness, numSamples, this.targetMapSize, VoH);
            }
            this.toWorld(L, N, tangentX, tangentY, lWorld);
            totalWeight += this.samplePixel(envMapReader, lWorld, NoL, computedMipLevel, prefilteredColor);
            for (int j = 1; j < nbRotations; ++j) {
                this.rotateDirection(offset2 + (float)j * rad, L, lWorld);
                L.set(lWorld);
                this.toWorld(L, N, tangentX, tangentY, lWorld);
                totalWeight += this.samplePixel(envMapReader, lWorld, NoL, computedMipLevel, prefilteredColor);
            }
        }
        if (totalWeight > 0.0f) {
            prefilteredColor.divideLocal(totalWeight);
        }
        return prefilteredColor;
    }

    private float samplePixel(CubeMapWrapper envMapReader, Vector3f lWorld, float NoL, float computedMipLevel, Vector3f store) {
        if (NoL <= 0.0f) {
            return 0.0f;
        }
        envMapReader.getPixel(lWorld, computedMipLevel, this.c);
        store.setX(store.x + this.c.r * NoL);
        store.setY(store.y + this.c.g * NoL);
        store.setZ(store.z + this.c.b * NoL);
        return NoL;
    }

    private void toWorld(Vector3f L, Vector3f N, Vector3f tangentX, Vector3f tangentY, Vector3f store) {
        store.set(tangentX).multLocal(L.x);
        this.tmp.set(tangentY).multLocal(L.y);
        store.addLocal(this.tmp);
        this.tmp.set(N).multLocal(L.z);
        store.addLocal(this.tmp);
    }

    private float computeMipLevel(float roughness, int numSamples, float size2, float voH) {
        float NoH = voH + 1.0E-5f;
        float Pdf = this.ggx(NoH, roughness) * NoH / (4.0f * voH);
        float omegaS = 1.0f / ((float)numSamples * Pdf);
        float omegaP = (float)Math.PI * 4 / (6.0f * size2 * size2);
        float mipBias = 1.0f;
        double maxLod = Math.log(size2) / Math.log(2.0);
        double log2 = Math.log(omegaS / omegaP) / Math.log(2.0);
        return Math.min(Math.max(0.5f * (float)log2 + mipBias, 0.0f), (float)maxLod);
    }

    private float ggx(float NoH, float alpha2) {
        float tmp = alpha2 / (NoH * NoH * (alpha2 * alpha2 - 1.0f) + 1.0f);
        return tmp * tmp * 0.31830987f;
    }

    private Vector3f rotateDirection(float angle, Vector3f l, Vector3f store) {
        float s = FastMath.sin(angle);
        float c = FastMath.cos(angle);
        float t = 1.0f - c;
        store.x = l.x * c + l.y * s;
        store.y = -l.x * s + l.y * c;
        store.z = l.z * (t + c);
        return store;
    }

    public Vector3f importanceSampleGGX(Vector4f xi, float a2, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        float cosTheta = FastMath.sqrt((1.0f - xi.x) / (1.0f + (a2 - 1.0f) * xi.x));
        float sinTheta = FastMath.sqrt(1.0f - cosTheta * cosTheta);
        float sinThetaCosPhi = sinTheta * xi.z;
        float sinThetaSinPhi = sinTheta * xi.w;
        store.x = sinThetaCosPhi;
        store.y = sinThetaSinPhi;
        store.z = cosTheta;
        return store;
    }
}

