/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.environment.EnvironmentCamera;
import com.jme3.environment.generation.IrradianceSphericalHarmonicsGenerator;
import com.jme3.environment.generation.JobProgressAdapter;
import com.jme3.environment.generation.JobProgressListener;
import com.jme3.environment.generation.PrefilteredEnvMapFaceGenerator;
import com.jme3.environment.util.EnvMapUtils;
import com.jme3.light.LightProbe;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.TextureCubeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class LightProbeFactory {
    private LightProbeFactory() {
    }

    public static LightProbe makeProbe(EnvironmentCamera envCam, Spatial scene2) {
        return LightProbeFactory.makeProbe(envCam, scene2, null);
    }

    public static LightProbe makeProbe(final EnvironmentCamera envCam, Spatial scene2, final EnvMapUtils.GenerationType genType, final JobProgressListener<LightProbe> listener) {
        final LightProbe probe = new LightProbe();
        probe.setPosition(envCam.getPosition());
        probe.setPrefilteredMap(EnvMapUtils.createPrefilteredEnvMap(envCam.getSize(), envCam.getImageFormat()));
        envCam.snapshot(scene2, (JobProgressListener<TextureCubeMap>)new JobProgressAdapter<TextureCubeMap>(){

            @Override
            public void done(TextureCubeMap map2) {
                LightProbeFactory.generatePbrMaps(map2, probe, envCam.getApplication(), genType, listener);
            }
        });
        return probe;
    }

    public static LightProbe makeProbe(EnvironmentCamera envCam, Spatial scene2, JobProgressListener<LightProbe> listener) {
        return LightProbeFactory.makeProbe(envCam, scene2, EnvMapUtils.GenerationType.Fast, listener);
    }

    public static LightProbe updateProbe(final LightProbe probe, final EnvironmentCamera envCam, Spatial scene2, final EnvMapUtils.GenerationType genType, final JobProgressListener<LightProbe> listener) {
        envCam.setPosition(probe.getPosition());
        probe.setReady(false);
        if (probe.getPrefilteredEnvMap() != null) {
            probe.getPrefilteredEnvMap().getImage().dispose();
        }
        probe.setPrefilteredMap(EnvMapUtils.createPrefilteredEnvMap(envCam.getSize(), envCam.getImageFormat()));
        envCam.snapshot(scene2, (JobProgressListener<TextureCubeMap>)new JobProgressAdapter<TextureCubeMap>(){

            @Override
            public void done(TextureCubeMap map2) {
                LightProbeFactory.generatePbrMaps(map2, probe, envCam.getApplication(), genType, listener);
            }
        });
        return probe;
    }

    public static LightProbe updateProbe(LightProbe probe, EnvironmentCamera envCam, Spatial scene2, JobProgressListener<LightProbe> listener) {
        return LightProbeFactory.updateProbe(probe, envCam, scene2, EnvMapUtils.GenerationType.Fast, listener);
    }

    private static void generatePbrMaps(TextureCubeMap envMap, LightProbe probe, Application app, EnvMapUtils.GenerationType genType, JobProgressListener<LightProbe> listener) {
        PrefilteredEnvMapFaceGenerator[] pemGenerators = new PrefilteredEnvMapFaceGenerator[6];
        JobState jobState = new JobState(new ScheduledThreadPoolExecutor(7));
        IrradianceSphericalHarmonicsGenerator irrShGenerator = new IrradianceSphericalHarmonicsGenerator(app, new JobListener(listener, jobState, probe, 6));
        int size2 = envMap.getImage().getWidth();
        irrShGenerator.setGenerationParam(EnvMapUtils.duplicateCubeMap(envMap), probe);
        jobState.executor.execute(irrShGenerator);
        for (int i = 0; i < pemGenerators.length; ++i) {
            pemGenerators[i] = new PrefilteredEnvMapFaceGenerator(app, i, new JobListener(listener, jobState, probe, i));
            pemGenerators[i].setGenerationParam(EnvMapUtils.duplicateCubeMap(envMap), size2, EnvMapUtils.FixSeamsMethod.None, genType, probe.getPrefilteredEnvMap());
            jobState.executor.execute(pemGenerators[i]);
        }
    }

    public static Node getDebugGui(AssetManager manager, LightProbe probe) {
        if (!probe.isReady()) {
            throw new IllegalStateException("The LightProbe is not ready yet, please test isReady().");
        }
        Node debugNode = new Node("debug gui probe");
        Node debugPfemCm = EnvMapUtils.getCubeMapCrossDebugViewWithMipMaps(probe.getPrefilteredEnvMap(), manager);
        debugNode.attachChild(debugPfemCm);
        debugPfemCm.setLocalTranslation(520.0f, 0.0f, 0.0f);
        return debugNode;
    }

    private static class JobState {
        double[] progress = new double[7];
        boolean[] done = new boolean[7];
        ScheduledThreadPoolExecutor executor;
        boolean started = false;

        public JobState(ScheduledThreadPoolExecutor executor) {
            this.executor = executor;
        }

        boolean isDone() {
            for (boolean d : this.done) {
                if (d) continue;
                return false;
            }
            return true;
        }

        float getProgress() {
            float mean = 0.0f;
            for (double faceProgress : this.progress) {
                mean = (float)((double)mean + faceProgress);
            }
            return mean / 7.0f;
        }
    }

    private static class JobListener
    extends JobProgressAdapter<Integer> {
        JobProgressListener<LightProbe> globalListener;
        JobState jobState;
        LightProbe probe;
        int index;

        public JobListener(JobProgressListener<LightProbe> globalListener, JobState jobState, LightProbe probe, int index2) {
            this.globalListener = globalListener;
            this.jobState = jobState;
            this.probe = probe;
            this.index = index2;
        }

        @Override
        public void start() {
            if (this.globalListener != null && !this.jobState.started) {
                this.jobState.started = true;
                this.globalListener.start();
            }
        }

        @Override
        public void progress(double value) {
            this.jobState.progress[this.index] = value;
            if (this.globalListener != null) {
                this.globalListener.progress(this.jobState.getProgress());
            }
        }

        @Override
        public void done(Integer result2) {
            if (this.globalListener != null) {
                if (result2 < 6) {
                    this.globalListener.step("Prefiltered env map face " + result2 + " generated");
                } else {
                    this.globalListener.step("Irradiance map generated");
                }
            }
            this.jobState.done[this.index] = true;
            if (this.jobState.isDone()) {
                this.probe.setNbMipMaps(this.probe.getPrefilteredEnvMap().getImage().getMipMapSizes().length);
                this.probe.setReady(true);
                if (this.globalListener != null) {
                    this.globalListener.done(this.probe);
                }
                this.jobState.executor.shutdownNow();
            }
        }
    }
}

