/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.collision.bih;

import com.jme3.math.Vector3f;

public final class BIHTriangle {
    private final Vector3f pointA = new Vector3f();
    private final Vector3f pointB = new Vector3f();
    private final Vector3f pointC = new Vector3f();
    private final Vector3f center = new Vector3f();

    public BIHTriangle(Vector3f p1, Vector3f p2, Vector3f p3) {
        this.pointA.set(p1);
        this.pointB.set(p2);
        this.pointC.set(p3);
        this.center.set(this.pointA);
        this.center.addLocal(this.pointB).addLocal(this.pointC).multLocal(0.33333334f);
    }

    public Vector3f get1() {
        return this.pointA;
    }

    public Vector3f get2() {
        return this.pointB;
    }

    public Vector3f get3() {
        return this.pointC;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public Vector3f getNormal() {
        Vector3f normal = new Vector3f(this.pointB);
        normal.subtractLocal(this.pointA).crossLocal(this.pointC.x - this.pointA.x, this.pointC.y - this.pointA.y, this.pointC.z - this.pointA.z);
        normal.normalizeLocal();
        return normal;
    }

    public float getExtreme(int axis, boolean left) {
        float v3;
        float v2;
        float v1;
        switch (axis) {
            case 0: {
                v1 = this.pointA.x;
                v2 = this.pointB.x;
                v3 = this.pointC.x;
                break;
            }
            case 1: {
                v1 = this.pointA.y;
                v2 = this.pointB.y;
                v3 = this.pointC.y;
                break;
            }
            case 2: {
                v1 = this.pointA.z;
                v2 = this.pointB.z;
                v3 = this.pointC.z;
                break;
            }
            default: {
                assert (false);
                return 0.0f;
            }
        }
        if (left) {
            if (v1 < v2) {
                if (v1 < v3) {
                    return v1;
                }
                return v3;
            }
            if (v2 < v3) {
                return v2;
            }
            return v3;
        }
        if (v1 > v2) {
            if (v1 > v3) {
                return v1;
            }
            return v3;
        }
        if (v2 > v3) {
            return v2;
        }
        return v3;
    }
}

