/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioSource;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;

public class SoundEvent
extends AbstractCinematicEvent {
    protected String path;
    protected AudioNode audioNode;
    protected boolean stream = false;

    public SoundEvent(String path) {
        this.path = path;
    }

    public SoundEvent(String path, boolean stream) {
        this(path);
        this.stream = stream;
    }

    public SoundEvent(String path, boolean stream, float initialDuration) {
        super(initialDuration);
        this.path = path;
        this.stream = stream;
    }

    public SoundEvent(String path, boolean stream, LoopMode loopMode) {
        super(loopMode);
        this.path = path;
        this.stream = stream;
    }

    public SoundEvent(String path, boolean stream, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.path = path;
        this.stream = stream;
    }

    public SoundEvent(String path, float initialDuration) {
        super(initialDuration);
        this.path = path;
    }

    public SoundEvent(String path, LoopMode loopMode) {
        super(loopMode);
        this.path = path;
    }

    public SoundEvent(String path, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.path = path;
    }

    public SoundEvent() {
    }

    @Override
    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        this.audioNode = new AudioNode(app.getAssetManager(), this.path, this.stream ? AudioData.DataType.Stream : AudioData.DataType.Buffer);
        this.audioNode.setPositional(false);
        this.setLoopMode(this.loopMode);
    }

    @Override
    public void setTime(float time) {
        super.setTime(time);
        if (time < 0.0f) {
            this.stop();
        } else {
            this.audioNode.setTimeOffset(time);
        }
    }

    @Override
    public void onPlay() {
        this.audioNode.play();
    }

    @Override
    public void onStop() {
        this.audioNode.stop();
    }

    @Override
    public void onPause() {
        this.audioNode.pause();
    }

    @Override
    public void onUpdate(float tpf) {
        if (this.audioNode.getStatus() == AudioSource.Status.Stopped) {
            this.stop();
        }
    }

    public AudioNode getAudioNode() {
        return this.audioNode;
    }

    @Override
    public void setLoopMode(LoopMode loopMode) {
        super.setLoopMode(loopMode);
        if (loopMode != LoopMode.DontLoop) {
            this.audioNode.setLooping(true);
        } else {
            this.audioNode.setLooping(false);
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.path, "path", "");
        oc.write(this.stream, "stream", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.path = ic.readString("path", "");
        this.stream = ic.readBoolean("stream", false);
    }
}

