/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bounding;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.math.FastMath;
import com.jme3.math.Plane;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.util.TempVars;

public final class Intersection {
    private Intersection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean intersect(BoundingSphere sphere, Vector3f center, float radius) {
        assert (Vector3f.isValidVector(center) && Vector3f.isValidVector(sphere.center));
        TempVars vars = TempVars.get();
        try {
            Vector3f diff = center.subtract(sphere.center, vars.vect1);
            float rsum = sphere.getRadius() + radius;
            boolean bl = diff.dot(diff) <= rsum * rsum;
            return bl;
        }
        finally {
            vars.release();
        }
    }

    public static boolean intersect(BoundingBox bbox, Vector3f center, float radius) {
        assert (Vector3f.isValidVector(center) && Vector3f.isValidVector(bbox.center));
        float distSqr = radius * radius;
        float minX = bbox.center.x - bbox.xExtent;
        float maxX = bbox.center.x + bbox.xExtent;
        float minY = bbox.center.y - bbox.yExtent;
        float maxY = bbox.center.y + bbox.yExtent;
        float minZ = bbox.center.z - bbox.zExtent;
        float maxZ = bbox.center.z + bbox.zExtent;
        if (center.x < minX) {
            distSqr -= FastMath.sqr(center.x - minX);
        } else if (center.x > maxX) {
            distSqr -= FastMath.sqr(center.x - maxX);
        }
        if (center.y < minY) {
            distSqr -= FastMath.sqr(center.y - minY);
        } else if (center.y > maxY) {
            distSqr -= FastMath.sqr(center.y - maxY);
        }
        if (center.z < minZ) {
            distSqr -= FastMath.sqr(center.z - minZ);
        } else if (center.z > maxZ) {
            distSqr -= FastMath.sqr(center.z - maxZ);
        }
        return distSqr > 0.0f;
    }

    private static final void findMinMax(float x0, float x1, float x2, Vector3f minMax) {
        minMax.set(x0, x0, 0.0f);
        if (x1 < minMax.x) {
            minMax.setX(x1);
        }
        if (x1 > minMax.y) {
            minMax.setY(x1);
        }
        if (x2 < minMax.x) {
            minMax.setX(x2);
        }
        if (x2 > minMax.y) {
            minMax.setY(x2);
        }
    }

    public static boolean intersect(Camera camera, Vector3f center, float radius) {
        for (int i = 5; i >= 0; --i) {
            if (!(camera.getWorldPlane(i).pseudoDistance(center) <= -radius)) continue;
            return false;
        }
        return true;
    }

    public static boolean intersect(BoundingBox bbox, Vector3f v1, Vector3f v2, Vector3f v3) {
        TempVars vars = TempVars.get();
        Vector3f tmp0 = vars.vect1;
        Vector3f tmp1 = vars.vect2;
        Vector3f tmp2 = vars.vect3;
        Vector3f e0 = vars.vect4;
        Vector3f e1 = vars.vect5;
        Vector3f e2 = vars.vect6;
        Vector3f center = bbox.getCenter();
        Vector3f extent = bbox.getExtent(null);
        v1.subtract(center, tmp0);
        v2.subtract(center, tmp1);
        v3.subtract(center, tmp2);
        tmp1.subtract(tmp0, e0);
        tmp2.subtract(tmp1, e1);
        tmp0.subtract(tmp2, e2);
        float fex = FastMath.abs(e0.x);
        float fey = FastMath.abs(e0.y);
        float fez = FastMath.abs(e0.z);
        float p0 = e0.z * tmp0.y - e0.y * tmp0.z;
        float p2 = e0.z * tmp2.y - e0.y * tmp2.z;
        float min = Math.min(p0, p2);
        float max = Math.max(p0, p2);
        float rad = fez * extent.y + fey * extent.z;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        p0 = -e0.z * tmp0.x + e0.x * tmp0.z;
        p2 = -e0.z * tmp2.x + e0.x * tmp2.z;
        min = Math.min(p0, p2);
        max = Math.max(p0, p2);
        rad = fez * extent.x + fex * extent.z;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        float p1 = e0.y * tmp1.x - e0.x * tmp1.y;
        p2 = e0.y * tmp2.x - e0.x * tmp2.y;
        min = Math.min(p1, p2);
        max = Math.max(p1, p2);
        rad = fey * extent.x + fex * extent.y;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        fex = FastMath.abs(e1.x);
        fey = FastMath.abs(e1.y);
        fez = FastMath.abs(e1.z);
        p0 = e1.z * tmp0.y - e1.y * tmp0.z;
        p2 = e1.z * tmp2.y - e1.y * tmp2.z;
        min = Math.min(p0, p2);
        max = Math.max(p0, p2);
        rad = fez * extent.y + fey * extent.z;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        p0 = -e1.z * tmp0.x + e1.x * tmp0.z;
        p2 = -e1.z * tmp2.x + e1.x * tmp2.z;
        min = Math.min(p0, p2);
        max = Math.max(p0, p2);
        rad = fez * extent.x + fex * extent.z;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        p0 = e1.y * tmp0.x - e1.x * tmp0.y;
        p1 = e1.y * tmp1.x - e1.x * tmp1.y;
        min = Math.min(p0, p1);
        max = Math.max(p0, p1);
        rad = fey * extent.x + fex * extent.y;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        fex = FastMath.abs(e2.x);
        fey = FastMath.abs(e2.y);
        fez = FastMath.abs(e2.z);
        p0 = e2.z * tmp0.y - e2.y * tmp0.z;
        p1 = e2.z * tmp1.y - e2.y * tmp1.z;
        min = Math.min(p0, p1);
        max = Math.max(p0, p1);
        rad = fez * extent.y + fey * extent.z;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        p0 = -e2.z * tmp0.x + e2.x * tmp0.z;
        p1 = -e2.z * tmp1.x + e2.x * tmp1.z;
        min = Math.min(p0, p1);
        max = Math.max(p0, p1);
        rad = fez * extent.x + fex * extent.y;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        p1 = e2.y * tmp1.x - e2.x * tmp1.y;
        p2 = e2.y * tmp2.x - e2.x * tmp2.y;
        min = Math.min(p1, p2);
        max = Math.max(p1, p2);
        rad = fey * extent.x + fex * extent.y;
        if (min > rad || max < -rad) {
            vars.release();
            return false;
        }
        Vector3f minMax = vars.vect7;
        Intersection.findMinMax(tmp0.x, tmp1.x, tmp2.x, minMax);
        if (minMax.x > extent.x || minMax.y < -extent.x) {
            vars.release();
            return false;
        }
        Intersection.findMinMax(tmp0.y, tmp1.y, tmp2.y, minMax);
        if (minMax.x > extent.y || minMax.y < -extent.y) {
            vars.release();
            return false;
        }
        Intersection.findMinMax(tmp0.z, tmp1.z, tmp2.z, minMax);
        if (minMax.x > extent.z || minMax.y < -extent.z) {
            vars.release();
            return false;
        }
        Plane p = vars.plane;
        p.setPlanePoints(v1, v2, v3);
        if (bbox.whichSide(p) == Plane.Side.Negative) {
            vars.release();
            return false;
        }
        vars.release();
        return true;
    }
}

