/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.audio.AudioStream;
import com.jme3.audio.SeekableStream;
import com.jme3.util.BufferUtils;
import com.jme3.util.LittleEndien;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WAVLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(WAVLoader.class.getName());
    private static final int i_RIFF = 1179011410;
    private static final int i_WAVE = 1163280727;
    private static final int i_fmt = 544501094;
    private static final int i_data = 1635017060;
    private boolean readStream = false;
    private AudioBuffer audioBuffer;
    private AudioStream audioStream;
    private AudioData audioData;
    private int bytesPerSec;
    private float duration;
    private ResettableInputStream in;
    private int inOffset = 0;

    private void readFormatChunk(int size2) throws IOException {
        short compression = this.in.readShort();
        if (compression != 1) {
            throw new IOException("WAV Loader only supports PCM wave files");
        }
        short channels = this.in.readShort();
        int sampleRate = this.in.readInt();
        this.bytesPerSec = this.in.readInt();
        short bytesPerSample = this.in.readShort();
        short bitsPerSample = this.in.readShort();
        int expectedBytesPerSec = bitsPerSample * channels * sampleRate / 8;
        if (expectedBytesPerSec != this.bytesPerSec) {
            logger.log(Level.WARNING, "Expected {0} bytes per second, got {1}", new Object[]{expectedBytesPerSec, this.bytesPerSec});
        }
        if (bitsPerSample != 8 && bitsPerSample != 16) {
            throw new IOException("Only 8 and 16 bits per sample are supported!");
        }
        if (bitsPerSample / 8 * channels != bytesPerSample) {
            throw new IOException("Invalid bytes per sample value");
        }
        if (bytesPerSample * sampleRate != this.bytesPerSec) {
            throw new IOException("Invalid bytes per second value");
        }
        this.audioData.setupFormat(channels, bitsPerSample, sampleRate);
        int remaining = size2 - 16;
        if (remaining > 0) {
            this.in.skipBytes(remaining);
        }
    }

    private void readDataChunkForBuffer(int len) throws IOException {
        ByteBuffer data2 = BufferUtils.createByteBuffer(len);
        byte[] buf = new byte[512];
        int read = 0;
        while ((read = this.in.read(buf)) > 0) {
            data2.put(buf, 0, Math.min(read, data2.remaining()));
        }
        data2.flip();
        this.audioBuffer.updateData(data2);
        this.in.close();
    }

    private void readDataChunkForStream(int offset2, int len) throws IOException {
        this.in.setResetOffset(offset2);
        this.audioStream.updateData(this.in, this.duration);
    }

    private AudioData load(AssetInfo info2, InputStream inputStream, boolean stream) throws IOException {
        this.in = new ResettableInputStream(info2, inputStream);
        this.inOffset = 0;
        int sig = this.in.readInt();
        if (sig != 1179011410) {
            throw new IOException("File is not a WAVE file");
        }
        this.in.readInt();
        if (this.in.readInt() != 1163280727) {
            throw new IOException("WAVE File does not contain audio");
        }
        this.inOffset += 12;
        this.readStream = stream;
        if (this.readStream) {
            this.audioStream = new AudioStream();
            this.audioData = this.audioStream;
        } else {
            this.audioBuffer = new AudioBuffer();
            this.audioData = this.audioBuffer;
        }
        block4: while (true) {
            int type2 = this.in.readInt();
            int len = this.in.readInt();
            this.inOffset += 8;
            switch (type2) {
                case 544501094: {
                    this.readFormatChunk(len);
                    this.inOffset += len;
                    continue block4;
                }
                case 1635017060: {
                    this.duration = len / this.bytesPerSec;
                    if (this.readStream) {
                        this.readDataChunkForStream(this.inOffset, len);
                    } else {
                        this.readDataChunkForBuffer(len);
                    }
                    return this.audioData;
                }
            }
            int skipped = this.in.skipBytes(len);
            if (skipped <= 0) {
                return null;
            }
            this.inOffset += skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info2) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = info2.openStream();
            AudioData data2 = this.load(info2, inputStream, ((AudioKey)info2.getKey()).isStream());
            if (data2 instanceof AudioStream) {
                inputStream = null;
            }
            AudioData audioData = data2;
            return audioData;
        }
    }

    private static class ResettableInputStream
    extends LittleEndien
    implements SeekableStream {
        private final AssetInfo info;
        private int resetOffset = 0;

        public ResettableInputStream(AssetInfo info2, InputStream in) {
            super(in);
            this.info = info2;
        }

        public void setResetOffset(int resetOffset) {
            this.resetOffset = resetOffset;
        }

        @Override
        public void setTime(float time) {
            if (time != 0.0f) {
                throw new UnsupportedOperationException("Seeking WAV files not supported");
            }
            InputStream newStream = this.info.openStream();
            try {
                newStream.skip(this.resetOffset);
                this.in = new BufferedInputStream(newStream);
            }
            catch (IOException ex) {
                try {
                    newStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(ex);
            }
        }
    }
}

