/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.audio.AudioData;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.SeekableStream;
import com.jme3.util.NativeObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class AudioStream
extends AudioData
implements Closeable {
    private static final Logger logger = Logger.getLogger(AudioStream.class.getName());
    protected InputStream in;
    protected float duration = -1.0f;
    protected boolean open = false;
    protected boolean eof = false;
    protected int[] ids;
    protected int unqueuedBuffersBytes = 0;

    public AudioStream() {
    }

    protected AudioStream(int[] ids) {
        super(-1);
        this.ids = ids;
    }

    public void updateData(InputStream in, float duration) {
        if (this.id != -1 || this.in != null) {
            throw new IllegalStateException("Data already set!");
        }
        this.in = in;
        this.duration = duration;
        this.open = true;
    }

    public int readSamples(byte[] buf, int offset2, int length) {
        if (!this.open || this.eof) {
            return -1;
        }
        try {
            int totalRead = this.in.read(buf, offset2, length);
            if (totalRead < 0) {
                this.eof = true;
            }
            return totalRead;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.eof = true;
            return -1;
        }
    }

    public int readSamples(byte[] buf) {
        return this.readSamples(buf, 0, buf.length);
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public int getId() {
        throw new RuntimeException("Don't use getId() on streams");
    }

    @Override
    public void setId(int id) {
        throw new RuntimeException("Don't use setId() on streams");
    }

    public void initIds(int count2) {
        this.ids = new int[count2];
    }

    public int getId(int index2) {
        return this.ids[index2];
    }

    public void setId(int index2, int id) {
        this.ids[index2] = id;
    }

    public int[] getIds() {
        return this.ids;
    }

    public void setIds(int[] ids) {
        this.ids = ids;
    }

    @Override
    public AudioData.DataType getDataType() {
        return AudioData.DataType.Stream;
    }

    @Override
    public void resetObject() {
        this.id = -1;
        this.ids = null;
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((AudioRenderer)rendererObject).deleteAudioData(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new AudioStream(this.ids);
    }

    public boolean isEOF() {
        return this.eof;
    }

    @Override
    public void close() {
        if (this.in != null && this.open) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } else {
            throw new RuntimeException("AudioStream is already closed!");
        }
        this.open = false;
    }

    public boolean isSeekable() {
        return this.in instanceof SeekableStream;
    }

    public int getUnqueuedBufferBytes() {
        return this.unqueuedBuffersBytes;
    }

    public void setUnqueuedBufferBytes(int unqueuedBuffers) {
        this.unqueuedBuffersBytes = unqueuedBuffers;
    }

    public void setTime(float time) {
        if (!(this.in instanceof SeekableStream)) {
            throw new IllegalStateException("Cannot use setTime on a stream that is not seekable. You must load the file with the streamCache option set to true");
        }
        ((SeekableStream)((Object)this.in)).setTime(time);
        this.eof = false;
        this.unqueuedBuffersBytes = 0;
    }

    @Override
    public long getUniqueId() {
        return 0x700000000L | (long)this.ids[0];
    }
}

