/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class HttpZipLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(HttpZipLocator.class.getName());
    private URL zipUrl;
    private String rootPath = "";
    private int numEntries;
    private int tableOffset;
    private int tableLength;
    private HashMap<String, ZipEntry2> entries;
    private final ByteBuffer byteBuf = ByteBuffer.allocate(250);
    private final CharBuffer charBuf = CharBuffer.allocate(250);
    private final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder();

    private static int get16(byte[] b, int off) {
        return b[off++] & 0xFF | (b[off] & 0xFF) << 8;
    }

    private static int get32(byte[] b, int off) {
        return b[off++] & 0xFF | (b[off++] & 0xFF) << 8 | (b[off++] & 0xFF) << 16 | (b[off] & 0xFF) << 24;
    }

    private static long getu32(byte[] b, int off) throws IOException {
        return (long)(b[off++] & 0xFF | (b[off++] & 0xFF) << 8 | (b[off++] & 0xFF) << 16) | (long)(b[off] & 0xFF) << 24;
    }

    private String getUTF8String(byte[] b, int off, int len) throws CharacterCodingException {
        int toRead;
        StringBuilder sb = new StringBuilder();
        for (int read = 0; read < len; read += toRead) {
            toRead = Math.min(len - read, this.byteBuf.capacity());
            boolean endOfInput = toRead < this.byteBuf.capacity();
            this.byteBuf.put(b, off + read, toRead);
            this.byteBuf.flip();
            CoderResult result2 = this.utf8Decoder.decode(this.byteBuf, this.charBuf, endOfInput);
            if (!result2.isUnderflow() || !endOfInput) {
                result2.throwException();
            }
            this.charBuf.flip();
            sb.append(this.charBuf.toString());
            this.byteBuf.clear();
            this.charBuf.clear();
        }
        return sb.toString();
    }

    private InputStream readData(int offset2, int length) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.zipUrl.openConnection();
        conn.setDoOutput(false);
        conn.setUseCaches(false);
        conn.setInstanceFollowRedirects(false);
        String range = "-";
        if (offset2 != Integer.MAX_VALUE) {
            range = offset2 + range;
        }
        if (length != Integer.MAX_VALUE) {
            range = offset2 != Integer.MAX_VALUE ? range + (offset2 + length - 1) : range + length;
        }
        conn.setRequestProperty("Range", "bytes=" + range);
        conn.connect();
        if (conn.getResponseCode() == 206) {
            return conn.getInputStream();
        }
        if (conn.getResponseCode() == 200) {
            throw new IOException("Your server does not support HTTP feature Content-Range. Please contact your server administrator.");
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    private int readTableEntry(byte[] table, int offset2) throws IOException {
        if ((long)HttpZipLocator.get32(table, offset2) != 33639248L) {
            throw new IOException("Central directory error, expected 'PK12'");
        }
        int nameLen = HttpZipLocator.get16(table, offset2 + 28);
        int extraLen = HttpZipLocator.get16(table, offset2 + 30);
        int commentLen = HttpZipLocator.get16(table, offset2 + 32);
        int newOffset = offset2 + 46 + nameLen + extraLen + commentLen;
        int flags = HttpZipLocator.get16(table, offset2 + 8);
        if ((flags & 1) == 1) {
            return newOffset;
        }
        int method = HttpZipLocator.get16(table, offset2 + 10);
        if (method != 8 && method != 0) {
            return newOffset;
        }
        String name = this.getUTF8String(table, offset2 + 46, nameLen);
        if (name.charAt(name.length() - 1) == '/') {
            return newOffset;
        }
        ZipEntry2 entry = new ZipEntry2();
        entry.name = name;
        entry.deflate = method == 8;
        entry.crc = HttpZipLocator.getu32(table, offset2 + 16);
        entry.length = HttpZipLocator.get32(table, offset2 + 24);
        entry.compSize = HttpZipLocator.get32(table, offset2 + 20);
        entry.offset = HttpZipLocator.get32(table, offset2 + 42);
        this.entries.put(entry.name, entry);
        return newOffset;
    }

    private void fillByteArray(byte[] array, InputStream source) throws IOException {
        int read;
        int length = array.length;
        for (int total = 0; total < length; total += read) {
            read = source.read(array, total, length - total);
            if (read >= 0) continue;
            throw new IOException("Failed to read entire array");
        }
    }

    private void readCentralDirectory() throws IOException {
        byte[] header = new byte[this.tableLength];
        try (InputStream in = this.readData(this.tableOffset, this.tableLength);){
            this.fillByteArray(header, in);
        }
        this.entries = new HashMap(this.numEntries);
        int offset2 = 0;
        for (int i = 0; i < this.numEntries; ++i) {
            offset2 = this.readTableEntry(header, offset2);
        }
    }

    private void readEndHeader() throws IOException {
        byte[] header = new byte[200];
        try (InputStream in = this.readData(Integer.MAX_VALUE, 200);){
            this.fillByteArray(header, in);
        }
        int offset2 = -1;
        for (int i = 178; i >= 0; --i) {
            if (header[i] != 80 || (long)HttpZipLocator.get32(header, i) != 101010256L) continue;
            offset2 = i;
            break;
        }
        if (offset2 == -1) {
            throw new IOException("Cannot find Zip End Header in file!");
        }
        this.numEntries = HttpZipLocator.get16(header, offset2 + 10);
        this.tableLength = HttpZipLocator.get32(header, offset2 + 12);
        this.tableOffset = HttpZipLocator.get32(header, offset2 + 16);
    }

    public void load(URL url) throws IOException {
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            throw new UnsupportedOperationException("HttpZipLocator only supports HTTP(S) URLs");
        }
        this.zipUrl = url;
        this.readEndHeader();
        this.readCentralDirectory();
    }

    private InputStream openStream(ZipEntry2 entry) throws IOException {
        if (entry.nameLength == null && entry.extraLength == null) {
            try (InputStream in = this.readData(entry.offset, 30);){
                byte[] localHeader = new byte[30];
                in.read(localHeader);
                entry.nameLength = HttpZipLocator.get16(localHeader, 26);
                entry.extraLength = HttpZipLocator.get16(localHeader, 28);
            }
        }
        int fileDataOffset = entry.offset + 30 + entry.nameLength + entry.extraLength;
        InputStream in = this.readData(fileDataOffset, entry.compSize);
        if (entry.deflate) {
            return new InflaterInputStream(in, new Inflater(true));
        }
        return in;
    }

    public InputStream openStream(String name) throws IOException {
        ZipEntry2 entry = this.entries.get(name);
        if (entry == null) {
            throw new RuntimeException("Entry not found: " + name);
        }
        return this.openStream(entry);
    }

    @Override
    public void setRootPath(String path) {
        if (!this.rootPath.equals(path)) {
            this.rootPath = path;
            try {
                this.load(new URL(path));
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Failed to set root path " + path, ex);
            }
        }
    }

    @Override
    public AssetInfo locate(AssetManager manager, AssetKey key) {
        final ZipEntry2 entry = this.entries.get(key.getName());
        if (entry == null) {
            return null;
        }
        return new AssetInfo(manager, key){

            @Override
            public InputStream openStream() {
                try {
                    return HttpZipLocator.this.openStream(entry);
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Error retrieving " + entry.name, ex);
                    return null;
                }
            }
        };
    }

    private static class ZipEntry2 {
        String name;
        int length;
        int offset;
        int compSize;
        long crc;
        boolean deflate;
        Integer nameLength;
        Integer extraLength;

        private ZipEntry2() {
        }

        public String toString() {
            return "ZipEntry[name=" + this.name + ",  length=" + this.length + ",  compSize=" + this.compSize + ",  offset=" + this.offset + "]";
        }
    }
}

