/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.cache.AssetCache;
import com.jme3.asset.cache.WeakRefCloneAssetCache;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureProcessor;
import java.io.IOException;

public class TextureKey
extends AssetKey<Texture> {
    private boolean generateMips;
    private boolean flipY;
    private int anisotropy;
    private Texture.Type textureTypeHint = Texture.Type.TwoDimensional;

    public TextureKey(String name, boolean flipY) {
        super(name);
        this.flipY = flipY;
    }

    public TextureKey(String name) {
        super(name);
        this.flipY = true;
    }

    public TextureKey() {
    }

    @Override
    public String toString() {
        String type2;
        switch (this.textureTypeHint) {
            case CubeMap: {
                type2 = " (Cube)";
                break;
            }
            case ThreeDimensional: {
                type2 = " (3D)";
                break;
            }
            case TwoDimensionalArray: {
                type2 = " (Array)";
                break;
            }
            case TwoDimensional: {
                type2 = "";
                break;
            }
            default: {
                type2 = " (" + this.textureTypeHint.toString() + ")";
            }
        }
        return this.name + (this.flipY ? " (Flipped)" : "") + type2 + (this.generateMips ? " (Mipmapped)" : "");
    }

    @Override
    public Class<? extends AssetCache> getCacheType() {
        return WeakRefCloneAssetCache.class;
    }

    @Override
    public Class<? extends AssetProcessor> getProcessorType() {
        return TextureProcessor.class;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public int getAnisotropy() {
        return this.anisotropy;
    }

    public void setAnisotropy(int anisotropy) {
        this.anisotropy = anisotropy;
    }

    public boolean isGenerateMips() {
        return this.generateMips;
    }

    public void setGenerateMips(boolean generateMips) {
        this.generateMips = generateMips;
    }

    public Texture.Type getTextureTypeHint() {
        return this.textureTypeHint;
    }

    public void setTextureTypeHint(Texture.Type textureTypeHint) {
        this.textureTypeHint = textureTypeHint;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextureKey other = (TextureKey)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.generateMips != other.generateMips) {
            return false;
        }
        if (this.flipY != other.flipY) {
            return false;
        }
        if (this.anisotropy != other.anisotropy) {
            return false;
        }
        return this.textureTypeHint == other.textureTypeHint;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + super.hashCode();
        hash = 17 * hash + (this.generateMips ? 1 : 0);
        hash = 17 * hash + (this.flipY ? 1 : 0);
        hash = 17 * hash + this.anisotropy;
        hash = 17 * hash + (this.textureTypeHint != null ? this.textureTypeHint.hashCode() : 0);
        return hash;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.flipY, "flip_y", false);
        oc.write(this.generateMips, "generate_mips", false);
        oc.write(this.anisotropy, "anisotropy", 0);
        oc.write(this.textureTypeHint, "tex_type", Texture.Type.TwoDimensional);
        oc.write(this.textureTypeHint == Texture.Type.CubeMap, "as_cubemap", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.flipY = ic.readBoolean("flip_y", false);
        this.generateMips = ic.readBoolean("generate_mips", false);
        this.anisotropy = ic.readInt("anisotropy", 0);
        boolean asCube = ic.readBoolean("as_cubemap", false);
        this.textureTypeHint = asCube ? Texture.Type.CubeMap : ic.readEnum("tex_type", Texture.Type.class, Texture.Type.TwoDimensional);
    }
}

