/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetConfig;
import com.jme3.asset.AssetEventListener;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.AssetProcessor;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.FilterKey;
import com.jme3.asset.ImplHandler;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.StreamAssetInfo;
import com.jme3.asset.TextureKey;
import com.jme3.asset.cache.AssetCache;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.post.FilterPostProcessor;
import com.jme3.renderer.Caps;
import com.jme3.scene.Spatial;
import com.jme3.shader.Glsl100ShaderGenerator;
import com.jme3.shader.Glsl150ShaderGenerator;
import com.jme3.shader.Glsl300ShaderGenerator;
import com.jme3.shader.ShaderGenerator;
import com.jme3.system.JmeSystem;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DesktopAssetManager
implements AssetManager {
    private static final Logger logger = Logger.getLogger(AssetManager.class.getName());
    private ShaderGenerator shaderGenerator;
    private final ImplHandler handler = new ImplHandler(this);
    private final CopyOnWriteArrayList<AssetEventListener> eventListeners = new CopyOnWriteArrayList();
    private final List<ClassLoader> classLoaders = Collections.synchronizedList(new ArrayList());

    public DesktopAssetManager() {
        this(null);
    }

    public DesktopAssetManager(boolean usePlatformConfig) {
        this(usePlatformConfig ? JmeSystem.getPlatformAssetConfigURL() : null);
    }

    public DesktopAssetManager(URL configFile) {
        if (configFile != null) {
            this.loadConfigFile(configFile);
        }
        logger.fine("DesktopAssetManager created.");
    }

    private void loadConfigFile(URL configFile) {
        try {
            AssetConfig.loadText(this, configFile);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to load asset config", ex);
        }
    }

    @Override
    public void addClassLoader(ClassLoader loader) {
        this.classLoaders.add(loader);
    }

    @Override
    public void removeClassLoader(ClassLoader loader) {
        this.classLoaders.remove(loader);
    }

    @Override
    public List<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableList(this.classLoaders);
    }

    @Override
    public void addAssetEventListener(AssetEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void removeAssetEventListener(AssetEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void clearAssetEventListeners() {
        this.eventListeners.clear();
    }

    public void setAssetEventListener(AssetEventListener listener) {
        this.eventListeners.clear();
        this.eventListeners.add(listener);
    }

    @Override
    public void registerLoader(Class<? extends AssetLoader> loader, String ... extensions) {
        this.handler.addLoader(loader, extensions);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Registered loader: {0} for extensions {1}", new Object[]{loader.getSimpleName(), Arrays.toString(extensions)});
        }
    }

    public void registerLoader(String clsName, String ... extensions) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clsName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        if (clazz != null) {
            this.registerLoader(clazz, extensions);
        }
    }

    @Override
    public void unregisterLoader(Class<? extends AssetLoader> loaderClass) {
        this.handler.removeLoader(loaderClass);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Unregistered loader: {0}", loaderClass.getSimpleName());
        }
    }

    @Override
    public void registerLocator(String rootPath, Class<? extends AssetLocator> locatorClass) {
        this.handler.addLocator(locatorClass, rootPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Registered locator: {0}", locatorClass.getSimpleName());
        }
    }

    public void registerLocator(String rootPath, String clsName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(clsName);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.WARNING, "Failed to find locator: " + clsName, ex);
        }
        catch (NoClassDefFoundError ex) {
            logger.log(Level.WARNING, "Failed to find loader: " + clsName, ex);
        }
        if (clazz != null) {
            this.registerLocator(rootPath, clazz);
        }
    }

    @Override
    public void unregisterLocator(String rootPath, Class<? extends AssetLocator> clazz) {
        this.handler.removeLocator(clazz, rootPath);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Unregistered locator: {0}", clazz.getSimpleName());
        }
    }

    @Override
    public AssetInfo locateAsset(AssetKey<?> key) {
        AssetInfo info2 = this.handler.tryLocate(key);
        if (info2 == null) {
            logger.log(Level.WARNING, "Cannot locate resource: {0}", key);
        }
        return info2;
    }

    @Override
    public <T> T getFromCache(AssetKey<T> key) {
        AssetCache cache2 = this.handler.getCache(key.getCacheType());
        if (cache2 != null) {
            T asset = cache2.getFromCache(key);
            if (asset != null) {
                cache2.notifyNoAssetClone();
            }
            return asset;
        }
        throw new IllegalArgumentException("Key " + key + " specifies no cache.");
    }

    @Override
    public <T> void addToCache(AssetKey<T> key, T asset) {
        AssetCache cache2 = this.handler.getCache(key.getCacheType());
        if (cache2 == null) {
            throw new IllegalArgumentException("Key " + key + " specifies no cache.");
        }
        cache2.addToCache(key, asset);
        cache2.notifyNoAssetClone();
    }

    @Override
    public <T> boolean deleteFromCache(AssetKey<T> key) {
        AssetCache cache2 = this.handler.getCache(key.getCacheType());
        if (cache2 != null) {
            return cache2.deleteFromCache(key);
        }
        throw new IllegalArgumentException("Key " + key + " specifies no cache.");
    }

    @Override
    public void clearCache() {
        this.handler.clearCache();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "All asset caches cleared.");
        }
    }

    protected <T> T loadLocatedAsset(AssetKey<T> key, AssetInfo info2, AssetProcessor proc, AssetCache cache2) {
        Object obj;
        AssetLoader loader = this.handler.aquireLoader(key);
        try {
            this.handler.establishParentKey(key);
            obj = loader.load(info2);
        }
        catch (IOException ex) {
            throw new AssetLoadException("An exception has occurred while loading asset: " + key, ex);
        }
        finally {
            this.handler.releaseParentKey(key);
        }
        if (obj == null) {
            throw new AssetLoadException("Error occurred while loading asset \"" + key + "\" using " + loader.getClass().getSimpleName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Loaded {0} with {1}", new Object[]{key, loader.getClass().getSimpleName()});
        }
        if (proc != null) {
            obj = proc.postProcess(key, obj);
        }
        if (cache2 != null) {
            cache2.addToCache(key, obj);
        }
        for (AssetEventListener listener : this.eventListeners) {
            listener.assetLoaded(key);
        }
        return (T)obj;
    }

    protected <T> T registerAndCloneSmartAsset(AssetKey<T> key, T obj, AssetProcessor proc, AssetCache cache2) {
        if (proc == null) {
            throw new IllegalStateException("Asset implements CloneableSmartAsset but doesn't have processor to handle cloning");
        }
        Object clone2 = proc.createClone(obj);
        if (cache2 == null || clone2 == obj) {
            throw new IllegalStateException("Asset implements CloneableSmartAsset but doesn't have cache or was not cloned");
        }
        cache2.registerAssetClone(key, clone2);
        return (T)clone2;
    }

    @Override
    public <T> T loadAssetFromStream(AssetKey<T> key, InputStream inputStream) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        for (AssetEventListener listener : this.eventListeners) {
            listener.assetRequested(key);
        }
        AssetProcessor proc = this.handler.getProcessor(key.getProcessorType());
        StreamAssetInfo info2 = new StreamAssetInfo(this, key, inputStream);
        return this.loadLocatedAsset(key, info2, proc, null);
    }

    @Override
    public <T> T loadAsset(AssetKey<T> key) {
        Object obj;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        for (AssetEventListener listener : this.eventListeners) {
            listener.assetRequested(key);
        }
        AssetCache cache2 = this.handler.getCache(key.getCacheType());
        AssetProcessor proc = this.handler.getProcessor(key.getProcessorType());
        Object v0 = obj = cache2 != null ? cache2.getFromCache(key) : null;
        if (obj == null) {
            AssetInfo info2 = this.handler.tryLocate(key);
            if (info2 == null) {
                if (this.handler.getParentKey() != null) {
                    for (AssetEventListener listener : this.eventListeners) {
                        listener.assetDependencyNotFound(this.handler.getParentKey(), key);
                    }
                }
                throw new AssetNotFoundException(key.toString());
            }
            obj = this.loadLocatedAsset(key, info2, proc, cache2);
        }
        Object clone2 = obj;
        if (obj instanceof CloneableSmartAsset) {
            clone2 = this.registerAndCloneSmartAsset(key, clone2, proc, cache2);
        }
        return clone2;
    }

    @Override
    public Object loadAsset(String name) {
        return this.loadAsset(new AssetKey(name));
    }

    @Override
    public Texture loadTexture(TextureKey key) {
        return this.loadAsset(key);
    }

    @Override
    public Material loadMaterial(String name) {
        return this.loadAsset(new MaterialKey(name));
    }

    @Override
    public Texture loadTexture(String name) {
        TextureKey key = new TextureKey(name, true);
        key.setGenerateMips(true);
        return this.loadTexture(key);
    }

    @Override
    public AudioData loadAudio(AudioKey key) {
        return this.loadAsset(key);
    }

    @Override
    public AudioData loadAudio(String name) {
        return this.loadAudio(new AudioKey(name, false));
    }

    @Override
    public BitmapFont loadFont(String name) {
        return (BitmapFont)this.loadAsset(new AssetKey(name));
    }

    @Override
    public Spatial loadModel(ModelKey key) {
        return this.loadAsset(key);
    }

    @Override
    public Spatial loadModel(String name) {
        return this.loadModel(new ModelKey(name));
    }

    @Override
    public FilterPostProcessor loadFilter(FilterKey key) {
        return this.loadAsset(key);
    }

    @Override
    public FilterPostProcessor loadFilter(String name) {
        return this.loadFilter(new FilterKey(name));
    }

    @Override
    public ShaderGenerator getShaderGenerator(EnumSet<Caps> caps) {
        if (this.shaderGenerator == null) {
            this.shaderGenerator = caps.contains((Object)Caps.OpenGLES30) && caps.contains((Object)Caps.GLSL300) ? new Glsl300ShaderGenerator(this) : (caps.contains((Object)Caps.GLSL150) ? new Glsl150ShaderGenerator(this) : new Glsl100ShaderGenerator(this));
        }
        return this.shaderGenerator;
    }

    @Override
    public void setShaderGenerator(ShaderGenerator shaderGenerator) {
        this.shaderGenerator = shaderGenerator;
    }
}

