/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.app.state.MjpegFileWriter;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.Timer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VideoRecorderAppState
extends AbstractAppState {
    private int framerate = 30;
    private VideoProcessor processor;
    private File file;
    private Application app;
    private ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setName("jME3 Video Processor");
            th.setDaemon(true);
            return th;
        }
    });
    private int numCpus = Runtime.getRuntime().availableProcessors();
    private ViewPort lastViewPort;
    private float quality;
    private Timer oldTimer;

    public VideoRecorderAppState() {
        this(null, 0.8f);
    }

    public VideoRecorderAppState(float quality) {
        this(null, quality);
    }

    public VideoRecorderAppState(float quality, int framerate) {
        this(null, quality, framerate);
    }

    public VideoRecorderAppState(File file) {
        this(file, 0.8f);
    }

    public VideoRecorderAppState(File file, float quality) {
        this.file = file;
        this.quality = quality;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "JME3 VideoRecorder running on {0} CPU's", this.numCpus);
    }

    public VideoRecorderAppState(File file, float quality, int framerate) {
        this.file = file;
        this.quality = quality;
        this.framerate = framerate;
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "JME3 VideoRecorder running on {0} CPU's", this.numCpus);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot set file while attached!");
        }
        this.file = file;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = app;
        this.oldTimer = app.getTimer();
        app.setTimer(new IsoTimer(this.framerate));
        if (this.file == null) {
            String filename = System.getProperty("user.home") + File.separator + "jMonkey-" + System.currentTimeMillis() / 1000L + ".avi";
            this.file = new File(filename);
        }
        this.processor = new VideoProcessor();
        List<ViewPort> vps = app.getRenderManager().getPostViews();
        for (int i = vps.size() - 1; i >= 0; --i) {
            this.lastViewPort = vps.get(i);
            if (this.lastViewPort.isEnabled()) break;
        }
        this.lastViewPort.addProcessor(this.processor);
    }

    @Override
    public void cleanup() {
        this.lastViewPort.removeProcessor(this.processor);
        this.app.setTimer(this.oldTimer);
        this.initialized = false;
        this.file = null;
        super.cleanup();
    }

    public static final class IsoTimer
    extends Timer {
        private float framerate;
        private int ticks;
        private long lastTime = 0L;

        public IsoTimer(float framerate) {
            this.framerate = framerate;
            this.ticks = 0;
        }

        @Override
        public long getTime() {
            return (long)((float)this.ticks * (1.0f / this.framerate) * 1000.0f);
        }

        @Override
        public long getResolution() {
            return 1000L;
        }

        @Override
        public float getFrameRate() {
            return this.framerate;
        }

        @Override
        public float getTimePerFrame() {
            return 1.0f / this.framerate;
        }

        @Override
        public void update() {
            long time = System.currentTimeMillis();
            long difference = time - this.lastTime;
            this.lastTime = time;
            if ((float)difference < 1.0f / this.framerate * 1000.0f) {
                try {
                    Thread.sleep(difference);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.ticks;
        }

        @Override
        public void reset() {
            this.ticks = 0;
        }
    }

    private class VideoProcessor
    implements SceneProcessor {
        private Camera camera;
        private int width;
        private int height;
        private RenderManager renderManager;
        private boolean isInitialized = false;
        private LinkedBlockingQueue<WorkItem> freeItems;
        private LinkedBlockingQueue<WorkItem> usedItems = new LinkedBlockingQueue();
        private MjpegFileWriter writer;

        private VideoProcessor() {
        }

        public void addImage(Renderer renderer, FrameBuffer out) {
            if (this.freeItems == null) {
                return;
            }
            try {
                final WorkItem item2 = this.freeItems.take();
                this.usedItems.add(item2);
                item2.buffer.clear();
                renderer.readFrameBufferWithFormat(out, item2.buffer, Image.Format.BGRA8);
                VideoRecorderAppState.this.executor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Screenshots.convertScreenShot(item2.buffer, item2.image);
                        item2.data = VideoProcessor.this.writer.writeImageToBytes(item2.image, VideoRecorderAppState.this.quality);
                        while (VideoProcessor.this.usedItems.peek() != item2) {
                            Thread.sleep(1L);
                        }
                        VideoProcessor.this.writer.addImage(item2.data);
                        VideoProcessor.this.usedItems.poll();
                        VideoProcessor.this.freeItems.add(item2);
                        return null;
                    }
                });
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VideoRecorderAppState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public void initialize(RenderManager rm, ViewPort viewPort) {
            this.camera = viewPort.getCamera();
            this.width = this.camera.getWidth();
            this.height = this.camera.getHeight();
            this.renderManager = rm;
            this.isInitialized = true;
            if (this.freeItems == null) {
                this.freeItems = new LinkedBlockingQueue();
                for (int i = 0; i < VideoRecorderAppState.this.numCpus; ++i) {
                    this.freeItems.add(new WorkItem(this.width, this.height));
                }
            }
        }

        @Override
        public void reshape(ViewPort vp, int w, int h) {
        }

        @Override
        public boolean isInitialized() {
            return this.isInitialized;
        }

        @Override
        public void preFrame(float tpf) {
            if (null == this.writer) {
                try {
                    this.writer = new MjpegFileWriter(VideoRecorderAppState.this.file, this.width, this.height, VideoRecorderAppState.this.framerate);
                }
                catch (Exception ex) {
                    Logger.getLogger(VideoRecorderAppState.class.getName()).log(Level.SEVERE, "Error creating file writer: {0}", ex);
                }
            }
        }

        @Override
        public void postQueue(RenderQueue rq) {
        }

        @Override
        public void postFrame(FrameBuffer out) {
            this.addImage(this.renderManager.getRenderer(), out);
        }

        @Override
        public void cleanup() {
            try {
                while (this.freeItems.size() < VideoRecorderAppState.this.numCpus) {
                    Thread.sleep(10L);
                }
                this.writer.finishAVI();
            }
            catch (Exception ex) {
                Logger.getLogger(VideoRecorderAppState.class.getName()).log(Level.SEVERE, "Error closing video: {0}", ex);
            }
            this.writer = null;
        }

        @Override
        public void setProfiler(AppProfiler profiler) {
        }
    }

    private class WorkItem {
        ByteBuffer buffer;
        BufferedImage image;
        byte[] data;

        public WorkItem(int width2, int height2) {
            this.image = new BufferedImage(width2, height2, 6);
            this.buffer = BufferUtils.createByteBuffer(width2 * height2 * 4);
        }
    }
}

