/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class MjpegFileWriter
implements AutoCloseable {
    int width = 0;
    int height = 0;
    double framerate = 0.0;
    int numFrames = 0;
    File aviFile = null;
    OutputStream aviOutput = null;
    long riffOffset = 0L;
    long aviMovieOffset = 0L;
    long position = 0L;
    AVIIndexList indexlist = null;

    public MjpegFileWriter(File aviFile, int width2, int height2, double framerate) throws Exception {
        this(aviFile, width2, height2, framerate, 0);
    }

    public MjpegFileWriter(File aviFile, int width2, int height2, double framerate, int numFrames) throws Exception {
        this.aviFile = aviFile;
        this.width = width2;
        this.height = height2;
        this.framerate = framerate;
        this.numFrames = numFrames;
        FileOutputStream fos = new FileOutputStream(aviFile);
        this.aviOutput = new BufferedOutputStream(fos);
        RIFFHeader rh = new RIFFHeader();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.write(rh.toBytes());
        baos.write(new AVIMainHeader().toBytes());
        baos.write(new AVIStreamList().toBytes());
        baos.write(new AVIStreamHeader().toBytes());
        baos.write(new AVIStreamFormat().toBytes());
        baos.write(new AVIJunk().toBytes());
        byte[] headerBytes = baos.toByteArray();
        this.aviOutput.write(headerBytes);
        this.aviMovieOffset = headerBytes.length;
        byte[] listBytes = new AVIMovieList().toBytes();
        this.aviOutput.write(listBytes);
        this.indexlist = new AVIIndexList();
        this.position = headerBytes.length + listBytes.length;
    }

    public void addImage(Image image) throws Exception {
        this.addImage(image, 0.8f);
    }

    public void addImage(Image image, float quality) throws Exception {
        this.addImage(this.writeImageToBytes(image, quality));
    }

    public void addImage(byte[] imageData) throws Exception {
        byte[] fcc = new byte[]{48, 48, 100, 98};
        int useLength = imageData.length;
        int extra = (useLength + (int)this.position) % 4;
        if (extra > 0) {
            useLength += extra;
        }
        this.indexlist.addAVIIndex((int)this.position, useLength);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(fcc.length + 4 + useLength);
        baos.write(fcc);
        baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(useLength)));
        baos.write(imageData);
        if (extra > 0) {
            for (int i = 0; i < extra; ++i) {
                baos.write(0);
            }
        }
        byte[] data2 = baos.toByteArray();
        this.aviOutput.write(data2);
        imageData = null;
        ++this.numFrames;
        this.position += (long)data2.length;
    }

    public void finishAVI() throws IOException {
        byte[] indexlistBytes = this.indexlist.toBytes();
        this.aviOutput.write(indexlistBytes);
        this.aviOutput.close();
        int fileSize = (int)this.aviFile.length();
        int listSize = (int)((long)(fileSize - 8) - this.aviMovieOffset - (long)indexlistBytes.length);
        try (SeekableByteChannel sbc = Files.newByteChannel(this.aviFile.toPath(), StandardOpenOption.WRITE);
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            baos.write(new RIFFHeader(fileSize).toBytes());
            baos.write(new AVIMainHeader().toBytes());
            baos.write(new AVIStreamList().toBytes());
            baos.write(new AVIStreamHeader().toBytes());
            baos.write(new AVIStreamFormat().toBytes());
            baos.write(new AVIJunk().toBytes());
            baos.write(new AVIMovieList(listSize).toBytes());
            sbc.write(ByteBuffer.wrap(baos.toByteArray()));
        }
    }

    public static int swapInt(int v) {
        return v >>> 24 | v << 24 | v << 8 & 0xFF0000 | v >> 8 & 0xFF00;
    }

    public static short swapShort(short v) {
        return (short)(v >>> 8 | v << 8);
    }

    public static byte[] intBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static byte[] shortBytes(short i) {
        byte[] b = new byte[]{(byte)(i >>> 8), (byte)(i & 0xFF)};
        return b;
    }

    @Override
    public void close() throws Exception {
        this.finishAVI();
    }

    public byte[] writeImageToBytes(Image image, float quality) throws Exception {
        BufferedImage bi;
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 1) {
            bi = (BufferedImage)image;
        } else {
            bi = new BufferedImage(this.width, this.height, 1);
            Graphics2D g = bi.createGraphics();
            g.drawImage(image, 0, 0, this.width, this.height, null);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageWriter imgWrtr = ImageIO.getImageWritersByFormatName("jpg").next();
        try (ImageOutputStream imgOutStrm = ImageIO.createImageOutputStream(baos);){
            imgWrtr.setOutput(imgOutStrm);
            ImageWriteParam jpgWrtPrm = imgWrtr.getDefaultWriteParam();
            jpgWrtPrm.setCompressionMode(2);
            jpgWrtPrm.setCompressionQuality(quality);
            imgWrtr.write(null, new IIOImage(bi, null, null), jpgWrtPrm);
        }
        return baos.toByteArray();
    }

    private class AVIIndexList {
        public byte[] fcc = new byte[]{105, 100, 120, 49};
        public int cb = 0;
        public List<AVIIndex> ind = new ArrayList<AVIIndex>();

        public void addAVIIndex(AVIIndex ai) {
            this.ind.add(ai);
        }

        public void addAVIIndex(int dwOffset, int dwSize) {
            this.ind.add(new AVIIndex(dwOffset, dwSize));
        }

        public byte[] toBytes() throws IOException {
            this.cb = 16 * this.ind.size();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            for (int i = 0; i < this.ind.size(); ++i) {
                AVIIndex in = this.ind.get(i);
                baos.write(in.toBytes());
            }
            return baos.toByteArray();
        }
    }

    private class RIFFHeader {
        public byte[] fcc = new byte[]{82, 73, 70, 70};
        public int fileSize = 0;
        public byte[] fcc2 = new byte[]{65, 86, 73, 32};
        public byte[] fcc3 = new byte[]{76, 73, 83, 84};
        public int listSize = 200;
        public byte[] fcc4 = new byte[]{104, 100, 114, 108};

        public RIFFHeader() {
        }

        public RIFFHeader(int fileSize) {
            this.fileSize = fileSize;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.fileSize)));
            baos.write(this.fcc2);
            baos.write(this.fcc3);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.listSize)));
            baos.write(this.fcc4);
            return baos.toByteArray();
        }
    }

    private class AVIMainHeader {
        public byte[] fcc = new byte[]{97, 118, 105, 104};
        public int cb = 56;
        public int dwMicroSecPerFrame = 0;
        public int dwMaxBytesPerSec = 10000000;
        public int dwPaddingGranularity = 0;
        public int dwFlags = 65552;
        public int dwTotalFrames = 0;
        public int dwInitialFrames = 0;
        public int dwStreams = 1;
        public int dwSuggestedBufferSize = 0;
        public int dwWidth = 0;
        public int dwHeight = 0;
        public int[] dwReserved = new int[4];

        public AVIMainHeader() {
            this.dwMicroSecPerFrame = (int)(1.0 / MjpegFileWriter.this.framerate * 1000000.0);
            this.dwWidth = MjpegFileWriter.this.width;
            this.dwHeight = MjpegFileWriter.this.height;
            this.dwTotalFrames = MjpegFileWriter.this.numFrames;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwMicroSecPerFrame)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwMaxBytesPerSec)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwPaddingGranularity)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwFlags)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwTotalFrames)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwInitialFrames)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwStreams)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSuggestedBufferSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwWidth)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwHeight)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[0])));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[1])));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[2])));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwReserved[3])));
            return baos.toByteArray();
        }
    }

    private class AVIStreamList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int size = 124;
        public byte[] fcc2 = new byte[]{115, 116, 114, 108};

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.size)));
            baos.write(this.fcc2);
            return baos.toByteArray();
        }
    }

    private class AVIStreamHeader {
        public byte[] fcc = new byte[]{115, 116, 114, 104};
        public int cb = 64;
        public byte[] fccType = new byte[]{118, 105, 100, 115};
        public byte[] fccHandler = new byte[]{77, 74, 80, 71};
        public int dwFlags = 0;
        public short wPriority = 0;
        public short wLanguage = 0;
        public int dwInitialFrames = 0;
        public int dwScale = 0;
        public int dwRate = 1000000;
        public int dwStart = 0;
        public int dwLength = 0;
        public int dwSuggestedBufferSize = 0;
        public int dwQuality = -1;
        public int dwSampleSize = 0;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        public AVIStreamHeader() {
            this.dwScale = (int)(1.0 / MjpegFileWriter.this.framerate * 1000000.0);
            this.dwLength = MjpegFileWriter.this.numFrames;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            baos.write(this.fccType);
            baos.write(this.fccHandler);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwFlags)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.wPriority)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.wLanguage)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwInitialFrames)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwScale)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwRate)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwStart)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwLength)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSuggestedBufferSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwQuality)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSampleSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.left)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.top)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.right)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.bottom)));
            return baos.toByteArray();
        }
    }

    private class AVIStreamFormat {
        public byte[] fcc = new byte[]{115, 116, 114, 102};
        public int cb = 40;
        public int biSize = 40;
        public int biWidth = 0;
        public int biHeight = 0;
        public short biPlanes = 1;
        public short biBitCount = (short)24;
        public byte[] biCompression = new byte[]{77, 74, 80, 71};
        public int biSizeImage = 0;
        public int biXPelsPerMeter = 0;
        public int biYPelsPerMeter = 0;
        public int biClrUsed = 0;
        public int biClrImportant = 0;

        public AVIStreamFormat() {
            this.biWidth = MjpegFileWriter.this.width;
            this.biHeight = MjpegFileWriter.this.height;
            this.biSizeImage = MjpegFileWriter.this.width * MjpegFileWriter.this.height;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.cb)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biSize)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biWidth)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biHeight)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.biPlanes)));
            baos.write(MjpegFileWriter.shortBytes(MjpegFileWriter.swapShort(this.biBitCount)));
            baos.write(this.biCompression);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biSizeImage)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biXPelsPerMeter)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biYPelsPerMeter)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biClrUsed)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.biClrImportant)));
            return baos.toByteArray();
        }
    }

    private class AVIJunk {
        public byte[] fcc = new byte[]{74, 85, 78, 75};
        public int size = 1808;
        public byte[] data = new byte[this.size];

        public AVIJunk() {
            Arrays.fill(this.data, (byte)0);
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.size)));
            baos.write(this.data);
            return baos.toByteArray();
        }
    }

    private class AVIMovieList {
        public byte[] fcc = new byte[]{76, 73, 83, 84};
        public int listSize = 0;
        public byte[] fcc2 = new byte[]{109, 111, 118, 105};

        public AVIMovieList() {
        }

        public AVIMovieList(int listSize) {
            this.listSize = listSize;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.listSize)));
            baos.write(this.fcc2);
            return baos.toByteArray();
        }
    }

    private class AVIIndex {
        public byte[] fcc = new byte[]{48, 48, 100, 98};
        public int dwFlags = 16;
        public int dwOffset = 0;
        public int dwSize = 0;

        public AVIIndex(int dwOffset, int dwSize) {
            this.dwOffset = dwOffset;
            this.dwSize = dwSize;
        }

        public byte[] toBytes() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.fcc);
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwFlags)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwOffset)));
            baos.write(MjpegFileWriter.intBytes(MjpegFileWriter.swapInt(this.dwSize)));
            return baos.toByteArray();
        }
    }
}

