/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.renderer.RenderManager;
import com.jme3.util.SafeArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AppStateManager {
    private final SafeArrayList<AppState> initializing = new SafeArrayList<AppState>(AppState.class);
    private final SafeArrayList<AppState> states = new SafeArrayList<AppState>(AppState.class);
    private final SafeArrayList<AppState> terminating = new SafeArrayList<AppState>(AppState.class);
    private final ConcurrentMap<String, AppState> stateIndex = new ConcurrentHashMap<String, AppState>();
    private final Application app;

    public AppStateManager(Application app) {
        this.app = app;
    }

    public Application getApplication() {
        return this.app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getInitializing() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.initializing.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getTerminating() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.terminating.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppState[] getStates() {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.states.getArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(AppState state2) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            if (state2.getId() != null && this.stateIndex.putIfAbsent(state2.getId(), state2) != null) {
                throw new IllegalArgumentException("ID:" + state2.getId() + " is already being used by another state:" + this.stateIndex.get(state2.getId()));
            }
            if (!this.states.contains(state2) && !this.initializing.contains(state2)) {
                state2.stateAttached(this);
                this.initializing.add(state2);
                return true;
            }
            return false;
        }
    }

    public void attachAll(AppState ... states) {
        this.attachAll(Arrays.asList(states));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAll(Iterable<AppState> states) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            for (AppState state2 : states) {
                this.attach(state2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(AppState state2) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            this.stateIndex.values().remove(state2);
            if (this.states.contains(state2)) {
                state2.stateDetached(this);
                this.states.remove(state2);
                this.terminating.add(state2);
                return true;
            }
            if (this.initializing.contains(state2)) {
                state2.stateDetached(this);
                this.initializing.remove(state2);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasState(AppState state2) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            return this.states.contains(state2) || this.initializing.contains(state2);
        }
    }

    public <T extends AppState> T getState(Class<T> stateClass) {
        return this.getState(stateClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AppState> T getState(Class<T> stateClass, boolean failOnMiss) {
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            AppState[] array;
            for (AppState state2 : array = this.getStates()) {
                if (!stateClass.isAssignableFrom(state2.getClass())) continue;
                return (T)state2;
            }
            for (AppState state2 : array = this.getInitializing()) {
                if (!stateClass.isAssignableFrom(state2.getClass())) continue;
                return (T)state2;
            }
        }
        if (failOnMiss) {
            throw new IllegalArgumentException("State not found for:" + stateClass);
        }
        return null;
    }

    public <T extends AppState> T getState(String id, Class<T> stateClass) {
        return (T)((AppState)stateClass.cast(this.stateIndex.get(id)));
    }

    public boolean hasState(String id) {
        return this.stateIndex.containsKey(id);
    }

    public <T extends AppState> T stateForId(String id, Class<T> stateClass) {
        T result2 = this.getState(id, stateClass);
        if (result2 == null) {
            throw new IllegalArgumentException("State not found for:" + id);
        }
        return (T)((AppState)stateClass.cast(result2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePending() {
        AppState[] array = this.getInitializing();
        if (array.length == 0) {
            return;
        }
        AppState[] appStateArray = this.states;
        synchronized (this.states) {
            List<AppState> transfer = Arrays.asList(array);
            this.states.addAll(transfer);
            this.initializing.removeAll(transfer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (AppState state2 : array) {
                state2.initialize(this, this.app);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminatePending() {
        AppState[] array = this.getTerminating();
        if (array.length == 0) {
            return;
        }
        for (AppState state2 : array) {
            state2.cleanup();
        }
        SafeArrayList<AppState> safeArrayList = this.states;
        synchronized (safeArrayList) {
            this.terminating.removeAll(Arrays.asList(array));
        }
    }

    public void update(float tpf) {
        AppState[] array;
        this.terminatePending();
        this.initializePending();
        for (AppState state2 : array = this.getStates()) {
            if (!state2.isEnabled()) continue;
            if (this.app.getAppProfiler() != null) {
                this.app.getAppProfiler().appSubStep(state2.getClass().getSimpleName());
            }
            state2.update(tpf);
        }
    }

    public void render(RenderManager rm) {
        AppState[] array;
        for (AppState state2 : array = this.getStates()) {
            if (!state2.isEnabled()) continue;
            if (this.app.getAppProfiler() != null) {
                this.app.getAppProfiler().appSubStep(state2.getClass().getSimpleName());
            }
            state2.render(rm);
        }
    }

    public void postRender() {
        AppState[] array;
        for (AppState state2 : array = this.getStates()) {
            if (!state2.isEnabled()) continue;
            if (this.app.getAppProfiler() != null) {
                this.app.getAppProfiler().appSubStep(state2.getClass().getSimpleName());
            }
            state2.postRender();
        }
    }

    public void cleanup() {
        AppState[] array;
        for (AppState state2 : array = this.getStates()) {
            state2.cleanup();
        }
    }
}

