/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.MatParamOverride;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.shader.VarType;
import com.jme3.util.SafeArrayList;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class SkeletonControl
extends AbstractControl
implements Cloneable,
JmeCloneable {
    private Skeleton skeleton;
    private SafeArrayList<Geometry> targets = new SafeArrayList<Geometry>(Geometry.class);
    private boolean wasMeshUpdated = false;
    private transient boolean hwSkinningDesired = true;
    private transient boolean hwSkinningEnabled = false;
    private transient boolean hwSkinningTested = false;
    private transient boolean hwSkinningSupported = false;
    private transient Matrix4f[] offsetMatrices;
    private MatParamOverride numberOfBonesParam;
    private MatParamOverride boneMatricesParam;

    protected SkeletonControl() {
    }

    private void switchToHardware() {
        this.numberOfBonesParam.setEnabled(true);
        this.boneMatricesParam.setEnabled(true);
        int numBones = (this.skeleton.getBoneCount() / 10 + 1) * 10;
        this.numberOfBonesParam.setValue(numBones);
        for (Geometry geometry : this.targets) {
            Mesh mesh = geometry.getMesh();
            if (mesh == null || !mesh.isAnimated()) continue;
            mesh.prepareForAnim(false);
        }
    }

    private void switchToSoftware() {
        this.numberOfBonesParam.setEnabled(false);
        this.boneMatricesParam.setEnabled(false);
        for (Geometry geometry : this.targets) {
            Mesh mesh = geometry.getMesh();
            if (mesh == null || !mesh.isAnimated()) continue;
            mesh.prepareForAnim(true);
        }
    }

    private boolean testHardwareSupported(RenderManager rm) {
        if (this.skeleton.getBoneCount() > 255) {
            return false;
        }
        this.switchToHardware();
        try {
            rm.preloadScene(this.spatial);
            return true;
        }
        catch (RendererException e) {
            Logger.getLogger(SkeletonControl.class.getName()).log(Level.WARNING, "Could not enable HW skinning due to shader compile error:", e);
            return false;
        }
    }

    public void setHardwareSkinningPreferred(boolean preferred) {
        this.hwSkinningDesired = preferred;
    }

    public boolean isHardwareSkinningPreferred() {
        return this.hwSkinningDesired;
    }

    public boolean isHardwareSkinningUsed() {
        return this.hwSkinningEnabled;
    }

    public SkeletonControl(Skeleton skeleton) {
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null");
        }
        this.skeleton = skeleton;
        this.numberOfBonesParam = new MatParamOverride(VarType.Int, "NumberOfBones", null);
        this.boneMatricesParam = new MatParamOverride(VarType.Matrix4Array, "BoneMatrices", null);
    }

    private void findTargets(Geometry geometry) {
        Mesh mesh = geometry.getMesh();
        if (mesh != null && mesh.isAnimated()) {
            this.targets.add(geometry);
        }
    }

    private void findTargets(Node node2) {
        for (Spatial child2 : node2.getChildren()) {
            if (child2 instanceof Geometry) {
                this.findTargets((Geometry)child2);
                continue;
            }
            if (!(child2 instanceof Node)) continue;
            this.findTargets((Node)child2);
        }
    }

    @Override
    public void setSpatial(Spatial spatial) {
        Spatial oldSpatial = this.spatial;
        super.setSpatial(spatial);
        this.updateTargetsAndMaterials(spatial);
        if (oldSpatial != null) {
            oldSpatial.removeMatParamOverride(this.numberOfBonesParam);
            oldSpatial.removeMatParamOverride(this.boneMatricesParam);
        }
        if (spatial != null) {
            spatial.removeMatParamOverride(this.numberOfBonesParam);
            spatial.removeMatParamOverride(this.boneMatricesParam);
            spatial.addMatParamOverride(this.numberOfBonesParam);
            spatial.addMatParamOverride(this.boneMatricesParam);
        }
    }

    private void controlRenderSoftware() {
        this.resetToBind();
        this.offsetMatrices = this.skeleton.computeSkinningMatrices();
        for (Geometry geometry : this.targets) {
            Mesh mesh = geometry.getMesh();
            this.softwareSkinUpdate(mesh, this.offsetMatrices);
        }
    }

    private void controlRenderHardware() {
        this.offsetMatrices = this.skeleton.computeSkinningMatrices();
        this.boneMatricesParam.setValue(this.offsetMatrices);
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
        if (!this.wasMeshUpdated) {
            this.updateTargetsAndMaterials(this.spatial);
            assert (this.hwSkinningTested || !this.hwSkinningTested && !this.hwSkinningSupported && !this.hwSkinningEnabled);
            assert (!this.hwSkinningEnabled || this.hwSkinningEnabled && this.hwSkinningTested && this.hwSkinningSupported);
            if (this.hwSkinningDesired && !this.hwSkinningTested) {
                this.hwSkinningTested = true;
                this.hwSkinningSupported = this.testHardwareSupported(rm);
                if (this.hwSkinningSupported) {
                    this.hwSkinningEnabled = true;
                    Logger.getLogger(SkeletonControl.class.getName()).log(Level.INFO, "Hardware skinning engaged for {0}", this.spatial);
                } else {
                    this.switchToSoftware();
                }
            } else if (this.hwSkinningDesired && this.hwSkinningSupported && !this.hwSkinningEnabled) {
                this.switchToHardware();
                this.hwSkinningEnabled = true;
            } else if (!this.hwSkinningDesired && this.hwSkinningEnabled) {
                this.switchToSoftware();
                this.hwSkinningEnabled = false;
            }
            if (this.hwSkinningEnabled) {
                this.controlRenderHardware();
            } else {
                this.controlRenderSoftware();
            }
            this.wasMeshUpdated = true;
        }
    }

    @Override
    protected void controlUpdate(float tpf) {
        this.wasMeshUpdated = false;
    }

    void resetToBind() {
        for (Geometry geometry : this.targets) {
            Mesh mesh = geometry.getMesh();
            if (mesh == null || !mesh.isAnimated()) continue;
            Buffer bwBuff = mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
            Buffer biBuff = mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
            if (!biBuff.hasArray() || !bwBuff.hasArray()) {
                mesh.prepareForAnim(true);
            }
            VertexBuffer bindPos = mesh.getBuffer(VertexBuffer.Type.BindPosePosition);
            VertexBuffer bindNorm = mesh.getBuffer(VertexBuffer.Type.BindPoseNormal);
            VertexBuffer pos = mesh.getBuffer(VertexBuffer.Type.Position);
            VertexBuffer norm = mesh.getBuffer(VertexBuffer.Type.Normal);
            FloatBuffer pb = (FloatBuffer)pos.getData();
            FloatBuffer nb = (FloatBuffer)norm.getData();
            FloatBuffer bpb = (FloatBuffer)bindPos.getData();
            FloatBuffer bnb = (FloatBuffer)bindNorm.getData();
            pb.clear();
            nb.clear();
            bpb.clear();
            bnb.clear();
            VertexBuffer bindTangents = mesh.getBuffer(VertexBuffer.Type.BindPoseTangent);
            if (bindTangents != null) {
                VertexBuffer tangents = mesh.getBuffer(VertexBuffer.Type.Tangent);
                FloatBuffer tb = (FloatBuffer)tangents.getData();
                FloatBuffer btb = (FloatBuffer)bindTangents.getData();
                tb.clear();
                btb.clear();
                tb.put(btb).clear();
            }
            pb.put(bpb).clear();
            nb.put(bnb).clear();
        }
    }

    @Override
    public Object jmeClone() {
        return super.jmeClone();
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.skeleton = cloner.clone(this.skeleton);
        this.targets = cloner.clone(this.targets);
        this.numberOfBonesParam = cloner.clone(this.numberOfBonesParam);
        this.boneMatricesParam = cloner.clone(this.boneMatricesParam);
    }

    public Node getAttachmentsNode(String boneName) {
        Bone b = this.skeleton.getBone(boneName);
        if (b == null) {
            throw new IllegalArgumentException("Given bone name does not exist in the skeleton.");
        }
        this.updateTargetsAndMaterials(this.spatial);
        int boneIndex = this.skeleton.getBoneIndex(b);
        Node n = b.getAttachmentsNode(boneIndex, this.targets);
        Node parent2 = this.spatial instanceof Node ? (Node)this.spatial : this.spatial.getParent();
        parent2.attachChild(n);
        return n;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Mesh[] getTargets() {
        Mesh[] result2 = new Mesh[this.targets.size()];
        int i = 0;
        for (Geometry geometry : this.targets) {
            Mesh mesh;
            result2[i] = mesh = geometry.getMesh();
            ++i;
        }
        return result2;
    }

    private void softwareSkinUpdate(Mesh mesh, Matrix4f[] offsetMatrices) {
        VertexBuffer tb = mesh.getBuffer(VertexBuffer.Type.Tangent);
        if (tb == null) {
            this.applySkinning(mesh, offsetMatrices);
        } else {
            this.applySkinningTangents(mesh, offsetMatrices, tb);
        }
    }

    private void applySkinning(Mesh mesh, Matrix4f[] offsetMatrices) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            throw new IllegalStateException("Max weights per vert is incorrectly set!");
        }
        int fourMinusMaxWeights = 4 - maxWeightsPerVert;
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.rewind();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fnb.rewind();
        IndexBuffer ib = IndexBuffer.wrapIndexBuffer(mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData());
        FloatBuffer wb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        wb.rewind();
        float[] weights = wb.array();
        int idxWeights = 0;
        TempVars vars = TempVars.get();
        float[] posBuf = vars.skinPositions;
        float[] normBuf = vars.skinNormals;
        int iterations = (int)FastMath.ceil((float)fvb.limit() / (float)posBuf.length);
        int bufLength = posBuf.length;
        for (int i = iterations - 1; i >= 0; --i) {
            bufLength = Math.min(posBuf.length, fvb.remaining());
            fvb.get(posBuf, 0, bufLength);
            fnb.get(normBuf, 0, bufLength);
            int verts = bufLength / 3;
            int idxPositions = 0;
            for (int vert = verts - 1; vert >= 0; --vert) {
                if (weights[idxWeights] == 0.0f) {
                    idxPositions += 3;
                    idxWeights += 4;
                    continue;
                }
                float nmx = normBuf[idxPositions];
                float vtx = posBuf[idxPositions++];
                float nmy = normBuf[idxPositions];
                float vty = posBuf[idxPositions++];
                float nmz = normBuf[idxPositions];
                float vtz = posBuf[idxPositions++];
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                float rnx = 0.0f;
                float rny = 0.0f;
                float rnz = 0.0f;
                for (int w = maxWeightsPerVert - 1; w >= 0; --w) {
                    float weight = weights[idxWeights];
                    Matrix4f mat = offsetMatrices[ib.get(idxWeights++)];
                    rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                    ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                    rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                    rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                    rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                    rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
                }
                idxWeights += fourMinusMaxWeights;
                normBuf[idxPositions -= 3] = rnx;
                posBuf[idxPositions++] = rx;
                normBuf[idxPositions] = rny;
                posBuf[idxPositions++] = ry;
                normBuf[idxPositions] = rnz;
                posBuf[idxPositions++] = rz;
            }
            fvb.position(fvb.position() - bufLength);
            fvb.put(posBuf, 0, bufLength);
            fnb.position(fnb.position() - bufLength);
            fnb.put(normBuf, 0, bufLength);
        }
        vars.release();
        vb.updateData(fvb);
        nb.updateData(fnb);
    }

    private void applySkinningTangents(Mesh mesh, Matrix4f[] offsetMatrices, VertexBuffer tb) {
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            throw new IllegalStateException("Max weights per vert is incorrectly set!");
        }
        int fourMinusMaxWeights = 4 - maxWeightsPerVert;
        VertexBuffer vb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fvb = (FloatBuffer)vb.getData();
        fvb.rewind();
        VertexBuffer nb = mesh.getBuffer(VertexBuffer.Type.Normal);
        FloatBuffer fnb = (FloatBuffer)nb.getData();
        fnb.rewind();
        FloatBuffer ftb = (FloatBuffer)tb.getData();
        ftb.rewind();
        IndexBuffer ib = IndexBuffer.wrapIndexBuffer(mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData());
        FloatBuffer wb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        wb.rewind();
        float[] weights = wb.array();
        int idxWeights = 0;
        TempVars vars = TempVars.get();
        float[] posBuf = vars.skinPositions;
        float[] normBuf = vars.skinNormals;
        float[] tanBuf = vars.skinTangents;
        int iterations = (int)FastMath.ceil((float)fvb.limit() / (float)posBuf.length);
        int bufLength = 0;
        int tanLength = 0;
        for (int i = iterations - 1; i >= 0; --i) {
            bufLength = Math.min(posBuf.length, fvb.remaining());
            tanLength = Math.min(tanBuf.length, ftb.remaining());
            fvb.get(posBuf, 0, bufLength);
            fnb.get(normBuf, 0, bufLength);
            ftb.get(tanBuf, 0, tanLength);
            int verts = bufLength / 3;
            int idxPositions = 0;
            int idxTangents = 0;
            for (int vert = verts - 1; vert >= 0; --vert) {
                if (weights[idxWeights] == 0.0f) {
                    idxTangents += 4;
                    idxPositions += 3;
                    idxWeights += 4;
                    continue;
                }
                float nmx = normBuf[idxPositions];
                float vtx = posBuf[idxPositions++];
                float nmy = normBuf[idxPositions];
                float vty = posBuf[idxPositions++];
                float nmz = normBuf[idxPositions];
                float vtz = posBuf[idxPositions++];
                float tnx = tanBuf[idxTangents++];
                float tny = tanBuf[idxTangents++];
                float tnz = tanBuf[idxTangents++];
                ++idxTangents;
                float rx = 0.0f;
                float ry = 0.0f;
                float rz = 0.0f;
                float rnx = 0.0f;
                float rny = 0.0f;
                float rnz = 0.0f;
                float rtx = 0.0f;
                float rty = 0.0f;
                float rtz = 0.0f;
                for (int w = maxWeightsPerVert - 1; w >= 0; --w) {
                    float weight = weights[idxWeights];
                    Matrix4f mat = offsetMatrices[ib.get(idxWeights++)];
                    rx += (mat.m00 * vtx + mat.m01 * vty + mat.m02 * vtz + mat.m03) * weight;
                    ry += (mat.m10 * vtx + mat.m11 * vty + mat.m12 * vtz + mat.m13) * weight;
                    rz += (mat.m20 * vtx + mat.m21 * vty + mat.m22 * vtz + mat.m23) * weight;
                    rnx += (nmx * mat.m00 + nmy * mat.m01 + nmz * mat.m02) * weight;
                    rny += (nmx * mat.m10 + nmy * mat.m11 + nmz * mat.m12) * weight;
                    rnz += (nmx * mat.m20 + nmy * mat.m21 + nmz * mat.m22) * weight;
                    rtx += (tnx * mat.m00 + tny * mat.m01 + tnz * mat.m02) * weight;
                    rty += (tnx * mat.m10 + tny * mat.m11 + tnz * mat.m12) * weight;
                    rtz += (tnx * mat.m20 + tny * mat.m21 + tnz * mat.m22) * weight;
                }
                idxWeights += fourMinusMaxWeights;
                normBuf[idxPositions -= 3] = rnx;
                posBuf[idxPositions++] = rx;
                normBuf[idxPositions] = rny;
                posBuf[idxPositions++] = ry;
                normBuf[idxPositions] = rnz;
                posBuf[idxPositions++] = rz;
                idxTangents -= 4;
                tanBuf[idxTangents++] = rtx;
                tanBuf[idxTangents++] = rty;
                tanBuf[idxTangents++] = rtz;
                ++idxTangents;
            }
            fvb.position(fvb.position() - bufLength);
            fvb.put(posBuf, 0, bufLength);
            fnb.position(fnb.position() - bufLength);
            fnb.put(normBuf, 0, bufLength);
            ftb.position(ftb.position() - tanLength);
            ftb.put(tanBuf, 0, tanLength);
        }
        vars.release();
        vb.updateData(fvb);
        nb.updateData(fnb);
        tb.updateData(ftb);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.skeleton, "skeleton", null);
        oc.write(this.numberOfBonesParam, "numberOfBonesParam", null);
        oc.write(this.boneMatricesParam, "boneMatricesParam", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        this.skeleton = (Skeleton)in.readSavable("skeleton", null);
        this.numberOfBonesParam = (MatParamOverride)in.readSavable("numberOfBonesParam", null);
        this.boneMatricesParam = (MatParamOverride)in.readSavable("boneMatricesParam", null);
        if (this.numberOfBonesParam == null) {
            this.numberOfBonesParam = new MatParamOverride(VarType.Int, "NumberOfBones", null);
            this.boneMatricesParam = new MatParamOverride(VarType.Matrix4Array, "BoneMatrices", null);
            this.getSpatial().addMatParamOverride(this.numberOfBonesParam);
            this.getSpatial().addMatParamOverride(this.boneMatricesParam);
        }
    }

    private void updateTargetsAndMaterials(Spatial spatial) {
        this.targets.clear();
        if (spatial instanceof Node) {
            this.findTargets((Node)spatial);
        } else if (spatial instanceof Geometry) {
            this.findTargets((Geometry)spatial);
        }
    }
}

