/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

@Deprecated
public final class Pose
implements Savable,
Cloneable {
    private String name;
    private int targetMeshIndex;
    private Vector3f[] offsets;
    private int[] indices;
    private final transient Vector3f tempVec = new Vector3f();
    private final transient Vector3f tempVec2 = new Vector3f();

    public Pose(String name, int targetMeshIndex, Vector3f[] offsets, int[] indices) {
        this.name = name;
        this.targetMeshIndex = targetMeshIndex;
        this.offsets = offsets;
        this.indices = indices;
    }

    protected Pose() {
    }

    public int getTargetMeshIndex() {
        return this.targetMeshIndex;
    }

    public void apply(float blend, FloatBuffer vertexBuffer) {
        for (int i = 0; i < this.indices.length; ++i) {
            Vector3f offset2 = this.offsets[i];
            int vertIndex = this.indices[i];
            this.tempVec.set(offset2).multLocal(blend);
            BufferUtils.populateFromBuffer(this.tempVec2, vertexBuffer, vertIndex);
            this.tempVec2.addLocal(this.tempVec);
            BufferUtils.setInBuffer(this.tempVec2, vertexBuffer, vertIndex);
        }
    }

    public Pose clone() {
        try {
            Pose result2 = (Pose)super.clone();
            result2.indices = (int[])this.indices.clone();
            if (this.offsets != null) {
                result2.offsets = new Vector3f[this.offsets.length];
                for (int i = 0; i < this.offsets.length; ++i) {
                    result2.offsets[i] = this.offsets[i].clone();
                }
            }
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule out = e.getCapsule(this);
        out.write(this.name, "name", "");
        out.write(this.targetMeshIndex, "meshIndex", -1);
        out.write(this.offsets, "offsets", null);
        out.write(this.indices, "indices", (int[])null);
    }

    @Override
    public void read(JmeImporter i) throws IOException {
        InputCapsule in = i.getCapsule(this);
        this.name = in.readString("name", "");
        this.targetMeshIndex = in.readInt("meshIndex", -1);
        this.indices = in.readIntArray("indices", null);
        Savable[] readSavableArray = in.readSavableArray("offsets", null);
        if (readSavableArray != null) {
            this.offsets = new Vector3f[readSavableArray.length];
            System.arraycopy(readSavableArray, 0, this.offsets, 0, readSavableArray.length);
        }
    }
}

