/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.CompactArray;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import java.io.IOException;

public class CompactQuaternionArray
extends CompactArray<Quaternion>
implements Savable {
    public CompactQuaternionArray() {
    }

    public CompactQuaternionArray(float[] dataArray, int[] index2) {
        super(dataArray, index2);
    }

    @Override
    protected final int getTupleSize() {
        return 4;
    }

    @Override
    protected final Class<Quaternion> getElementClass() {
        return Quaternion.class;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        this.serialize();
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.array, "array", (float[])null);
        out.write(this.index, "index", (int[])null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.array = in.readFloatArray("array", null);
        this.index = in.readIntArray("index", null);
    }

    @Override
    protected void serialize(int i, Quaternion store) {
        int j = i * this.getTupleSize();
        this.array[j] = store.getX();
        this.array[j + 1] = store.getY();
        this.array[j + 2] = store.getZ();
        this.array[j + 3] = store.getW();
    }

    @Override
    protected Quaternion deserialize(int i, Quaternion store) {
        int j = i * this.getTupleSize();
        store.set(this.array[j], this.array[j + 1], this.array[j + 2], this.array[j + 3]);
        return store;
    }
}

