/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParamOverride;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.jme3.util.SafeArrayList;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;

@Deprecated
public final class Bone
implements Savable,
JmeCloneable {
    public static final int SAVABLE_VERSION = 2;
    private String name;
    private Bone parent;
    private ArrayList<Bone> children = new ArrayList();
    private boolean userControl = false;
    private Node attachNode;
    private Geometry targetGeometry = null;
    private Vector3f bindPos;
    private Quaternion bindRot;
    private Vector3f bindScale;
    private Vector3f modelBindInversePos;
    private Quaternion modelBindInverseRot;
    private Vector3f modelBindInverseScale;
    private Vector3f localPos = new Vector3f();
    private Quaternion localRot = new Quaternion();
    private Vector3f localScale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector3f modelPos = new Vector3f();
    private Quaternion modelRot = new Quaternion();
    private Vector3f modelScale = new Vector3f();
    private Transform tmpTransform;
    private transient float currentWeightSum = -1.0f;

    public Bone(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.bindPos = new Vector3f();
        this.bindRot = new Quaternion();
        this.bindScale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.modelBindInversePos = new Vector3f();
        this.modelBindInverseRot = new Quaternion();
        this.modelBindInverseScale = new Vector3f();
    }

    Bone(Bone source) {
        this.name = source.name;
        this.userControl = source.userControl;
        this.bindPos = source.bindPos.clone();
        this.bindRot = source.bindRot.clone();
        this.bindScale = source.bindScale.clone();
        this.modelBindInversePos = source.modelBindInversePos.clone();
        this.modelBindInverseRot = source.modelBindInverseRot.clone();
        this.modelBindInverseScale = source.modelBindInverseScale.clone();
    }

    protected Bone() {
    }

    @Override
    public Object jmeClone() {
        try {
            Bone clone2 = (Bone)super.clone();
            return clone2;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.parent = cloner.clone(this.parent);
        this.children = cloner.clone(this.children);
        this.attachNode = cloner.clone(this.attachNode);
        this.targetGeometry = cloner.clone(this.targetGeometry);
        this.bindPos = cloner.clone(this.bindPos);
        this.bindRot = cloner.clone(this.bindRot);
        this.bindScale = cloner.clone(this.bindScale);
        this.modelBindInversePos = cloner.clone(this.modelBindInversePos);
        this.modelBindInverseRot = cloner.clone(this.modelBindInverseRot);
        this.modelBindInverseScale = cloner.clone(this.modelBindInverseScale);
        this.localPos = cloner.clone(this.localPos);
        this.localRot = cloner.clone(this.localRot);
        this.localScale = cloner.clone(this.localScale);
        this.modelPos = cloner.clone(this.modelPos);
        this.modelRot = cloner.clone(this.modelRot);
        this.modelScale = cloner.clone(this.modelScale);
        this.tmpTransform = cloner.clone(this.tmpTransform);
    }

    public String getName() {
        return this.name;
    }

    public Bone getParent() {
        return this.parent;
    }

    public ArrayList<Bone> getChildren() {
        return this.children;
    }

    public Vector3f getLocalPosition() {
        return this.localPos;
    }

    public Quaternion getLocalRotation() {
        return this.localRot;
    }

    public Vector3f getLocalScale() {
        return this.localScale;
    }

    public Vector3f getModelSpacePosition() {
        return this.modelPos;
    }

    public Quaternion getModelSpaceRotation() {
        return this.modelRot;
    }

    public Vector3f getModelSpaceScale() {
        return this.modelScale;
    }

    @Deprecated
    public Vector3f getWorldBindInversePosition() {
        return this.modelBindInversePos;
    }

    public Vector3f getModelBindInversePosition() {
        return this.modelBindInversePos;
    }

    @Deprecated
    public Quaternion getWorldBindInverseRotation() {
        return this.modelBindInverseRot;
    }

    public Quaternion getModelBindInverseRotation() {
        return this.modelBindInverseRot;
    }

    @Deprecated
    public Vector3f getWorldBindInverseScale() {
        return this.modelBindInverseScale;
    }

    public Vector3f getModelBindInverseScale() {
        return this.modelBindInverseScale;
    }

    public Transform getModelBindInverseTransform() {
        Transform t = new Transform();
        t.setTranslation(this.modelBindInversePos);
        t.setRotation(this.modelBindInverseRot);
        if (this.modelBindInverseScale != null) {
            t.setScale(this.modelBindInverseScale);
        }
        return t;
    }

    public Transform getBindInverseTransform() {
        Transform t = new Transform();
        t.setTranslation(this.bindPos);
        t.setRotation(this.bindRot);
        if (this.bindScale != null) {
            t.setScale(this.bindScale);
        }
        return t.invert();
    }

    @Deprecated
    public Vector3f getWorldBindPosition() {
        return this.bindPos;
    }

    public Vector3f getBindPosition() {
        return this.bindPos;
    }

    @Deprecated
    public Quaternion getWorldBindRotation() {
        return this.bindRot;
    }

    public Quaternion getBindRotation() {
        return this.bindRot;
    }

    @Deprecated
    public Vector3f getWorldBindScale() {
        return this.bindScale;
    }

    public Vector3f getBindScale() {
        return this.bindScale;
    }

    public void setUserControl(boolean enable) {
        this.userControl = enable;
    }

    public void addChild(Bone bone) {
        this.children.add(bone);
        bone.parent = this;
    }

    @Deprecated
    public final void updateWorldVectors() {
        this.updateModelTransforms();
    }

    public final void updateModelTransforms() {
        if (this.currentWeightSum == 1.0f) {
            this.currentWeightSum = -1.0f;
        } else if (this.currentWeightSum != -1.0f) {
            if (this.currentWeightSum == 0.0f) {
                this.localRot.set(this.bindRot);
                this.localPos.set(this.bindPos);
                this.localScale.set(this.bindScale);
            } else {
                float invWeightSum = 1.0f - this.currentWeightSum;
                this.localRot.nlerp(this.bindRot, invWeightSum);
                this.localPos.interpolateLocal(this.bindPos, invWeightSum);
                this.localScale.interpolateLocal(this.bindScale, invWeightSum);
            }
            this.currentWeightSum = -1.0f;
        }
        if (this.parent != null) {
            this.parent.modelRot.mult(this.localRot, this.modelRot);
            this.parent.modelScale.mult(this.localScale, this.modelScale);
            this.parent.modelRot.mult(this.localPos, this.modelPos);
            this.modelPos.multLocal(this.parent.modelScale);
            this.modelPos.addLocal(this.parent.modelPos);
        } else {
            this.modelRot.set(this.localRot);
            this.modelPos.set(this.localPos);
            this.modelScale.set(this.localScale);
        }
        if (this.attachNode != null) {
            this.updateAttachNode();
        }
    }

    private void updateAttachNode() {
        Node attachParent = this.attachNode.getParent();
        if (attachParent == null || this.targetGeometry == null || this.targetGeometry.getParent() == attachParent && this.targetGeometry.getLocalTransform().isIdentity()) {
            this.attachNode.setLocalTranslation(this.modelPos);
            this.attachNode.setLocalRotation(this.modelRot);
            this.attachNode.setLocalScale(this.modelScale);
        } else if (this.targetGeometry.isIgnoreTransform()) {
            this.attachNode.setLocalTranslation(this.modelPos);
            this.attachNode.setLocalRotation(this.modelRot);
            this.attachNode.setLocalScale(this.modelScale);
            this.attachNode.getLocalTransform().combineWithParent(this.attachNode.getParent().getWorldTransform().invert());
        } else {
            Transform combined = new Transform(this.modelPos, this.modelRot, this.modelScale);
            for (Spatial loopSpatial = this.targetGeometry; loopSpatial != attachParent && loopSpatial != null; loopSpatial = loopSpatial.getParent()) {
                Transform localTransform = loopSpatial.getLocalTransform();
                combined.combineWithParent(localTransform);
            }
            this.attachNode.setLocalTransform(combined);
        }
    }

    public final void update() {
        this.updateModelTransforms();
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.children.get(i).update();
        }
    }

    void setBindingPose() {
        this.bindPos.set(this.localPos);
        this.bindRot.set(this.localRot);
        this.bindScale.set(this.localScale);
        if (this.modelBindInversePos == null) {
            this.modelBindInversePos = new Vector3f();
            this.modelBindInverseRot = new Quaternion();
            this.modelBindInverseScale = new Vector3f();
        }
        this.modelBindInversePos.set(this.modelPos);
        this.modelBindInversePos.negateLocal();
        this.modelBindInverseRot.set(this.modelRot);
        this.modelBindInverseRot.inverseLocal();
        this.modelBindInverseScale.set(Vector3f.UNIT_XYZ);
        this.modelBindInverseScale.divideLocal(this.modelScale);
        for (Bone b : this.children) {
            b.setBindingPose();
        }
    }

    final void reset() {
        if (!this.userControl) {
            this.localPos.set(this.bindPos);
            this.localRot.set(this.bindRot);
            this.localScale.set(this.bindScale);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.children.get(i).reset();
        }
    }

    void getOffsetTransform(Matrix4f outTransform, Quaternion tmp1, Vector3f tmp2, Vector3f tmp3, Matrix3f tmp4) {
        Vector3f scale2 = this.modelScale.mult(this.modelBindInverseScale, tmp3);
        Quaternion rotate = this.modelRot.mult(this.modelBindInverseRot, tmp1);
        Vector3f translate = this.modelPos.add(rotate.mult(scale2.mult(this.modelBindInversePos, tmp2), tmp2), tmp2);
        outTransform.setTransform(translate, scale2, rotate.toRotationMatrix(tmp4));
    }

    public void setUserTransforms(Vector3f translation, Quaternion rotation, Vector3f scale2) {
        if (!this.userControl) {
            throw new IllegalStateException("You must call setUserControl(true) in order to setUserTransform to work");
        }
        this.localPos.set(this.bindPos);
        this.localRot.set(this.bindRot);
        this.localScale.set(this.bindScale);
        this.localPos.addLocal(translation);
        this.localRot.multLocal(rotation);
        this.localScale.multLocal(scale2);
    }

    public void setUserTransformsInModelSpace(Vector3f translation, Quaternion rotation) {
        if (!this.userControl) {
            throw new IllegalStateException("You must call setUserControl(true) in order to setUserTransformsInModelSpace to work");
        }
        this.modelPos.set(translation);
        this.modelRot.set(rotation);
        if (this.attachNode != null) {
            this.attachNode.setLocalTranslation(translation);
            this.attachNode.setLocalRotation(rotation);
        }
    }

    public Transform getCombinedTransform(Vector3f position, Quaternion rotation) {
        if (this.tmpTransform == null) {
            this.tmpTransform = new Transform();
        }
        rotation.mult(this.localPos, this.tmpTransform.getTranslation()).addLocal(position);
        this.tmpTransform.setRotation(rotation).getRotation().multLocal(this.localRot);
        return this.tmpTransform;
    }

    Node getAttachmentsNode(int boneIndex, SafeArrayList<Geometry> targets) {
        this.targetGeometry = null;
        for (Geometry geometry : targets) {
            Mesh mesh = geometry.getMesh();
            if (mesh == null || !mesh.isAnimatedByBone(boneIndex)) continue;
            this.targetGeometry = geometry;
            break;
        }
        if (this.attachNode == null) {
            this.attachNode = new Node(this.name + "_attachnode");
            this.attachNode.setUserData("AttachedBone", this);
            this.attachNode.addMatParamOverride(new MatParamOverride(VarType.Int, "NumberOfBones", null));
        }
        return this.attachNode;
    }

    void setAttachmentsNode(Node attachNode) {
        this.attachNode = attachNode;
    }

    void setAnimTransforms(Vector3f translation, Quaternion rotation, Vector3f scale2) {
        if (this.userControl) {
            return;
        }
        this.localPos.set(this.bindPos).addLocal(translation);
        this.localRot.set(this.bindRot).multLocal(rotation);
        if (scale2 != null) {
            this.localScale.set(this.bindScale).multLocal(scale2);
        }
    }

    void blendAnimTransforms(Vector3f translation, Quaternion rotation, Vector3f scale2, float weight) {
        if (this.userControl) {
            return;
        }
        if (weight == 0.0f) {
            return;
        }
        if (this.currentWeightSum == 1.0f) {
            return;
        }
        if (this.currentWeightSum == -1.0f || this.currentWeightSum == 0.0f) {
            this.localPos.set(this.bindPos).addLocal(translation);
            this.localRot.set(this.bindRot).multLocal(rotation);
            if (scale2 != null) {
                this.localScale.set(this.bindScale).multLocal(scale2);
            }
            this.currentWeightSum = weight;
        } else {
            TempVars vars = TempVars.get();
            Vector3f tmpV = vars.vect1;
            Vector3f tmpV2 = vars.vect2;
            Quaternion tmpQ = vars.quat1;
            tmpV.set(this.bindPos).addLocal(translation);
            this.localPos.interpolateLocal(tmpV, weight);
            tmpQ.set(this.bindRot).multLocal(rotation);
            this.localRot.nlerp(tmpQ, weight);
            if (scale2 != null) {
                tmpV2.set(this.bindScale).multLocal(scale2);
                this.localScale.interpolateLocal(tmpV2, weight);
            }
            this.currentWeightSum = 1.0f;
            vars.release();
        }
    }

    public void setBindTransforms(Vector3f translation, Quaternion rotation, Vector3f scale2) {
        this.bindPos.set(translation);
        this.bindRot.set(rotation);
        if (scale2 != null) {
            this.bindScale.set(scale2);
        }
        this.localPos.set(translation);
        this.localRot.set(rotation);
        if (scale2 != null) {
            this.localScale.set(scale2);
        }
    }

    private String toString(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append('-');
        }
        sb.append(this.name).append(" bone\n");
        for (Bone child2 : this.children) {
            sb.append(child2.toString(depth + 1));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule input = im.getCapsule(this);
        this.name = input.readString("name", null);
        int ver = input.getSavableVersion(Bone.class);
        if (ver < 2) {
            this.bindPos = (Vector3f)input.readSavable("initialPos", null);
            this.bindRot = (Quaternion)input.readSavable("initialRot", null);
            this.bindScale = (Vector3f)input.readSavable("initialScale", new Vector3f(1.0f, 1.0f, 1.0f));
        } else {
            this.bindPos = (Vector3f)input.readSavable("bindPos", null);
            this.bindRot = (Quaternion)input.readSavable("bindRot", null);
            this.bindScale = (Vector3f)input.readSavable("bindScale", new Vector3f(1.0f, 1.0f, 1.0f));
        }
        this.attachNode = (Node)input.readSavable("attachNode", null);
        this.targetGeometry = (Geometry)input.readSavable("targetGeometry", null);
        this.localPos.set(this.bindPos);
        this.localRot.set(this.bindRot);
        this.localScale.set(this.bindScale);
        ArrayList childList = input.readSavableArrayList("children", null);
        for (int i = childList.size() - 1; i >= 0; --i) {
            this.addChild((Bone)childList.get(i));
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule output = ex.getCapsule(this);
        output.write(this.name, "name", null);
        output.write(this.attachNode, "attachNode", null);
        output.write(this.targetGeometry, "targetGeometry", null);
        output.write(this.bindPos, "bindPos", null);
        output.write(this.bindRot, "bindRot", null);
        output.write(this.bindScale, "bindScale", new Vector3f(1.0f, 1.0f, 1.0f));
        output.writeSavableArrayList(this.children, "children", null);
    }

    public void setLocalRotation(Quaternion rot) {
        if (!this.userControl) {
            throw new IllegalStateException("User control must be on bone to allow user transforms");
        }
        this.localRot.set(rot);
    }

    public void setLocalTranslation(Vector3f pos) {
        if (!this.userControl) {
            throw new IllegalStateException("User control must be on bone to allow user transforms");
        }
        this.localPos.set(pos);
    }

    public void setLocalScale(Vector3f scale2) {
        if (!this.userControl) {
            throw new IllegalStateException("User control must be on bone to allow user transforms");
        }
        this.localScale.set(scale2);
    }

    public boolean hasUserControl() {
        return this.userControl;
    }
}

