/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.ClonableTrack;
import com.jme3.animation.Track;
import com.jme3.animation.TrackInfo;
import com.jme3.audio.AudioNode;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class AudioTrack
implements ClonableTrack {
    private static final Logger logger = Logger.getLogger(AudioTrack.class.getName());
    private AudioNode audio;
    private float startOffset = 0.0f;
    private float length = 0.0f;
    private boolean initialized = false;
    private boolean started = false;
    private boolean played = false;

    protected AudioTrack() {
    }

    public AudioTrack(AudioNode audio, float length) {
        this.audio = audio;
        this.length = length;
        this.setUserData(this);
    }

    public AudioTrack(AudioNode audio, float length, float startOffset) {
        this(audio, length);
        this.startOffset = startOffset;
    }

    @Override
    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        if (time >= this.length) {
            return;
        }
        if (!this.initialized) {
            control.addListener(new OnEndListener());
            this.initialized = true;
        }
        if (!this.started && time >= this.startOffset) {
            this.started = true;
            this.audio.playInstance();
        }
    }

    private void stop() {
        this.audio.stop();
        this.started = false;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public float[] getKeyFrameTimes() {
        return new float[]{this.startOffset};
    }

    @Override
    public AudioTrack clone() {
        return new AudioTrack(this.audio, this.length, this.startOffset);
    }

    @Override
    public Track cloneForSpatial(Spatial spatial) {
        AudioTrack audioTrack = new AudioTrack();
        audioTrack.length = this.length;
        audioTrack.startOffset = this.startOffset;
        audioTrack.audio = this.findAudio(spatial);
        if (audioTrack.audio == null) {
            logger.log(Level.WARNING, "{0} was not found in {1} or is not bound to this track", new Object[]{this.audio.getName(), spatial.getName()});
            audioTrack.audio = this.audio;
        }
        this.setUserData(audioTrack);
        return audioTrack;
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.initialized = false;
        this.started = false;
        this.played = false;
        this.audio = cloner.clone(this.audio);
    }

    private AudioNode findAudio(Spatial spat) {
        if (spat instanceof AudioNode) {
            AudioNode em = (AudioNode)spat;
            TrackInfo t = (TrackInfo)em.getUserData("TrackInfo");
            if (t != null && t.getTracks().contains(this)) {
                return em;
            }
            return null;
        }
        if (spat instanceof Node) {
            for (Spatial child2 : ((Node)spat).getChildren()) {
                AudioNode em = this.findAudio(child2);
                if (em == null) continue;
                return em;
            }
        }
        return null;
    }

    private void setUserData(AudioTrack audioTrack) {
        TrackInfo data2 = (TrackInfo)audioTrack.audio.getUserData("TrackInfo");
        if (data2 == null) {
            data2 = new TrackInfo();
            audioTrack.audio.setUserData("TrackInfo", data2);
        }
        data2.addTrack(audioTrack);
    }

    @Override
    public void cleanUp() {
        TrackInfo t = (TrackInfo)this.audio.getUserData("TrackInfo");
        t.getTracks().remove(this);
        if (!t.getTracks().isEmpty()) {
            this.audio.setUserData("TrackInfo", null);
        }
    }

    public AudioNode getAudio() {
        return this.audio;
    }

    public void setAudio(AudioNode audio) {
        if (this.audio != null) {
            TrackInfo data2 = (TrackInfo)audio.getUserData("TrackInfo");
            data2.getTracks().remove(this);
        }
        this.audio = audio;
        this.setUserData(this);
    }

    public float getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(float startOffset) {
        this.startOffset = startOffset;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.audio, "audio", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.startOffset, "startOffset", 0.0f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.audio = (AudioNode)in.readSavable("audio", null);
        this.length = in.readFloat("length", this.length);
        this.startOffset = in.readFloat("startOffset", 0.0f);
    }

    private class OnEndListener
    implements AnimEventListener {
        private OnEndListener() {
        }

        @Override
        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            AudioTrack.this.stop();
        }

        @Override
        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
        }
    }
}

