/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.Animation;
import com.jme3.animation.SpatialTrack;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;

@Deprecated
public class AnimationFactory {
    private static final float EULER_STEP = 2.3561945f;
    protected String name;
    protected int fps;
    protected float duration;
    protected int totalFrames;
    protected float tpf;
    protected float[] times;
    protected Vector3f[] translations;
    protected Quaternion[] rotations;
    protected Vector3f[] scales;
    protected Vector3f[] keyFramesTranslation;
    protected Vector3f[] keyFramesScale;
    protected Rotation[] keyFramesRotation;

    public AnimationFactory(float duration, String name) {
        this(duration, name, 30);
    }

    public AnimationFactory(float duration, String name, int fps) {
        this.name = name;
        this.duration = duration;
        this.fps = fps;
        this.totalFrames = (int)((float)fps * duration) + 1;
        this.tpf = 1.0f / (float)fps;
        this.times = new float[this.totalFrames];
        this.translations = new Vector3f[this.totalFrames];
        this.rotations = new Quaternion[this.totalFrames];
        this.scales = new Vector3f[this.totalFrames];
        this.keyFramesTranslation = new Vector3f[this.totalFrames];
        this.keyFramesTranslation[0] = new Vector3f();
        this.keyFramesScale = new Vector3f[this.totalFrames];
        this.keyFramesScale[0] = new Vector3f(1.0f, 1.0f, 1.0f);
        this.keyFramesRotation = new Rotation[this.totalFrames];
        this.keyFramesRotation[0] = new Rotation();
    }

    public void addTimeTransform(float time, Transform transform2) {
        this.addKeyFrameTransform((int)(time / this.tpf), transform2);
    }

    public void addKeyFrameTransform(int keyFrameIndex, Transform transform2) {
        this.addKeyFrameTranslation(keyFrameIndex, transform2.getTranslation());
        this.addKeyFrameScale(keyFrameIndex, transform2.getScale());
        this.addKeyFrameRotation(keyFrameIndex, transform2.getRotation());
    }

    public void addTimeTranslation(float time, Vector3f translation) {
        this.addKeyFrameTranslation((int)(time / this.tpf), translation);
    }

    public void addKeyFrameTranslation(int keyFrameIndex, Vector3f translation) {
        Vector3f t = this.getTranslationForFrame(keyFrameIndex);
        t.set(translation);
    }

    public void addTimeRotation(float time, Quaternion rotation) {
        this.addKeyFrameRotation((int)(time / this.tpf), rotation);
    }

    public void addKeyFrameRotation(int keyFrameIndex, Quaternion rotation) {
        Rotation r = this.getRotationForFrame(keyFrameIndex);
        r.set(rotation);
    }

    public void addTimeRotationAngles(float time, float x2, float y2, float z) {
        this.addKeyFrameRotationAngles((int)(time / this.tpf), x2, y2, z);
    }

    public void addKeyFrameRotationAngles(int keyFrameIndex, float x2, float y2, float z) {
        Rotation r = this.getRotationForFrame(keyFrameIndex);
        r.set(x2, y2, z);
        int prev = this.getPreviousKeyFrame(keyFrameIndex, this.keyFramesRotation);
        if (prev != -1) {
            Rotation prevRot = this.keyFramesRotation[prev];
            float delta = Math.max(Math.abs(x2 - prevRot.eulerAngles.x), Math.abs(y2 - prevRot.eulerAngles.y));
            if ((delta = Math.max(delta, Math.abs(z - prevRot.eulerAngles.z))) >= (float)Math.PI) {
                int dF = keyFrameIndex - prev;
                float dXAngle = (x2 - prevRot.eulerAngles.x) / (float)dF;
                float dYAngle = (y2 - prevRot.eulerAngles.y) / (float)dF;
                float dZAngle = (z - prevRot.eulerAngles.z) / (float)dF;
                int keyStep = (int)((float)dF / delta * 2.3561945f);
                for (int cursor2 = prev + keyStep; cursor2 < keyFrameIndex; cursor2 += keyStep) {
                    Rotation dr = this.getRotationForFrame(cursor2);
                    dr.masterKeyFrame = keyFrameIndex;
                    dr.set(prevRot.eulerAngles.x + (float)cursor2 * dXAngle, prevRot.eulerAngles.y + (float)cursor2 * dYAngle, prevRot.eulerAngles.z + (float)cursor2 * dZAngle);
                }
            }
        }
    }

    public void addTimeScale(float time, Vector3f scale2) {
        this.addKeyFrameScale((int)(time / this.tpf), scale2);
    }

    public void addKeyFrameScale(int keyFrameIndex, Vector3f scale2) {
        Vector3f s = this.getScaleForFrame(keyFrameIndex);
        s.set(scale2);
    }

    private Vector3f getTranslationForFrame(int keyFrameIndex) {
        if (keyFrameIndex < 0 || keyFrameIndex > this.totalFrames) {
            throw new ArrayIndexOutOfBoundsException("keyFrameIndex must be between 0 and " + this.totalFrames + " (received " + keyFrameIndex + ")");
        }
        Vector3f v = this.keyFramesTranslation[keyFrameIndex];
        if (v == null) {
            this.keyFramesTranslation[keyFrameIndex] = v = new Vector3f();
        }
        return v;
    }

    private Vector3f getScaleForFrame(int keyFrameIndex) {
        if (keyFrameIndex < 0 || keyFrameIndex > this.totalFrames) {
            throw new ArrayIndexOutOfBoundsException("keyFrameIndex must be between 0 and " + this.totalFrames + " (received " + keyFrameIndex + ")");
        }
        Vector3f v = this.keyFramesScale[keyFrameIndex];
        if (v == null) {
            this.keyFramesScale[keyFrameIndex] = v = new Vector3f();
        }
        return v;
    }

    private Rotation getRotationForFrame(int keyFrameIndex) {
        if (keyFrameIndex < 0 || keyFrameIndex > this.totalFrames) {
            throw new ArrayIndexOutOfBoundsException("keyFrameIndex must be between 0 and " + this.totalFrames + " (received " + keyFrameIndex + ")");
        }
        Rotation v = this.keyFramesRotation[keyFrameIndex];
        if (v == null) {
            this.keyFramesRotation[keyFrameIndex] = v = new Rotation();
        }
        return v;
    }

    public Animation buildAnimation() {
        this.interpolateTime();
        this.interpolate(this.keyFramesTranslation, Type.Translation);
        this.interpolate(this.keyFramesRotation, Type.Rotation);
        this.interpolate(this.keyFramesScale, Type.Scale);
        SpatialTrack spatialTrack = new SpatialTrack(this.times, this.translations, this.rotations, this.scales);
        Animation spatialAnimation = new Animation(this.name, this.duration);
        spatialAnimation.setTracks(new SpatialTrack[]{spatialTrack});
        return spatialAnimation;
    }

    private void interpolateTime() {
        for (int i = 0; i < this.totalFrames; ++i) {
            this.times[i] = (float)i * this.tpf;
        }
    }

    private void interpolate(Object[] keyFrames, Type type2) {
        int i = 0;
        while (i < this.totalFrames) {
            int key = this.getNextKeyFrame(i, keyFrames);
            if (key != -1) {
                int span = key - i;
                block11: for (int j = i; j <= key; ++j) {
                    float val = (float)(j - i) / (float)span;
                    switch (type2) {
                        case Translation: {
                            this.translations[j] = FastMath.interpolateLinear(val, (Vector3f)keyFrames[i], (Vector3f)keyFrames[key]);
                            continue block11;
                        }
                        case Rotation: {
                            Quaternion rot = new Quaternion();
                            this.rotations[j] = rot.slerp(((Rotation)keyFrames[i]).rotation, ((Rotation)keyFrames[key]).rotation, val);
                            continue block11;
                        }
                        case Scale: {
                            this.scales[j] = FastMath.interpolateLinear(val, (Vector3f)keyFrames[i], (Vector3f)keyFrames[key]);
                        }
                    }
                }
                i = key;
                continue;
            }
            block12: for (int j = i; j < this.totalFrames; ++j) {
                switch (type2) {
                    case Translation: {
                        this.translations[j] = ((Vector3f)keyFrames[i]).clone();
                        continue block12;
                    }
                    case Rotation: {
                        this.rotations[j] = ((Rotation)keyFrames[i]).rotation.clone();
                        continue block12;
                    }
                    case Scale: {
                        this.scales[j] = ((Vector3f)keyFrames[i]).clone();
                    }
                }
            }
            i = this.totalFrames;
        }
    }

    private int getNextKeyFrame(int index2, Object[] keyFrames) {
        for (int i = index2 + 1; i < this.totalFrames; ++i) {
            if (keyFrames[i] == null) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousKeyFrame(int index2, Object[] keyFrames) {
        for (int i = index2 - 1; i >= 0; --i) {
            if (keyFrames[i] == null) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    protected class Rotation {
        Quaternion rotation = new Quaternion();
        Vector3f eulerAngles = new Vector3f();
        int masterKeyFrame = -1;

        public Rotation() {
            this.rotation.loadIdentity();
        }

        void set(Quaternion rot) {
            this.rotation.set(rot);
            float[] a = new float[3];
            this.rotation.toAngles(a);
            this.eulerAngles.set(a[0], a[1], a[2]);
        }

        void set(float x2, float y2, float z) {
            float[] a = new float[]{x2, y2, z};
            this.rotation.fromAngles(a);
            this.eulerAngles.set(x2, y2, z);
        }
    }

    private static enum Type {
        Translation,
        Rotation,
        Scale;

    }
}

