/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Primitives {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;

    private Primitives() {
    }

    public static <T> Class<T> wrap(Class<T> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("type is null");
        }
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type2);
        return wrapped == null ? type2 : wrapped;
    }

    static {
        HashMap<Class<Object>, Class<Void>> primToWrap = new HashMap<Class<Object>, Class<Void>>(16);
        primToWrap.put(Boolean.TYPE, Boolean.class);
        primToWrap.put(Byte.TYPE, Byte.class);
        primToWrap.put(Character.TYPE, Character.class);
        primToWrap.put(Double.TYPE, Double.class);
        primToWrap.put(Float.TYPE, Float.class);
        primToWrap.put(Integer.TYPE, Integer.class);
        primToWrap.put(Long.TYPE, Long.class);
        primToWrap.put(Short.TYPE, Short.class);
        primToWrap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
    }
}

