/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween.action;

import com.jme3.anim.tween.AbstractTween;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.tween.action.Action;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.math.Transform;
import com.jme3.util.clone.Cloner;
import java.util.Collection;

public abstract class BlendableAction
extends Action {
    protected BlendableAction collectTransformDelegate;
    private float transitionWeight = 1.0f;
    private double maxTransitionWeight = 1.0;
    private double transitionLength = 0.4f;
    private float weight = 1.0f;
    private TransitionTween transition = new TransitionTween(this.transitionLength);

    public BlendableAction(Tween ... tweens) {
        super(tweens);
    }

    public void setCollectTransformDelegate(BlendableAction delegate2) {
        this.collectTransformDelegate = delegate2;
    }

    @Override
    public boolean interpolate(double t) {
        if (t < 0.0) {
            return true;
        }
        if (this.collectTransformDelegate == null) {
            if (this.transition.getLength() > this.getLength()) {
                this.transition.setLength(this.getLength());
            }
            if (this.isForward()) {
                this.transition.interpolate(t);
            } else {
                float v = Math.max((float)(this.getLength() - t), 0.0f);
                this.transition.interpolate(v);
            }
        } else {
            this.transitionWeight = 1.0f;
        }
        if (this.weight == 0.0f) {
            return t < this.getLength();
        }
        this.doInterpolate(t);
        return t < this.getLength();
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    protected abstract void doInterpolate(double var1);

    public abstract Collection<HasLocalTransform> getTargets();

    public abstract void collectTransform(HasLocalTransform var1, Transform var2, float var3, BlendableAction var4);

    public double getTransitionLength() {
        return this.transitionLength;
    }

    public void setTransitionLength(double transitionLength) {
        this.transitionLength = transitionLength;
        this.transition.setLength(transitionLength);
    }

    protected float getTransitionWeight() {
        return this.transitionWeight;
    }

    public void setMaxTransitionWeight(double maxTransitionWeight) {
        if (maxTransitionWeight < 0.0 || maxTransitionWeight > 1.0) {
            throw new IllegalArgumentException("maxTransitionWeight must be between 0 and 1");
        }
        this.maxTransitionWeight = maxTransitionWeight;
    }

    public double getMaxTransitionWeight() {
        return this.maxTransitionWeight;
    }

    @Override
    public BlendableAction jmeClone() {
        try {
            BlendableAction clone2 = (BlendableAction)super.clone();
            return clone2;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.collectTransformDelegate = cloner.clone(this.collectTransformDelegate);
        this.transition = cloner.clone(this.transition);
    }

    private class TransitionTween
    extends AbstractTween {
        public TransitionTween(double length) {
            super(length);
        }

        @Override
        protected void doInterpolate(double t) {
            BlendableAction.this.transitionWeight = (float)Math.min(t, BlendableAction.this.maxTransitionWeight);
        }
    }
}

