/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween;

import com.jme3.anim.tween.AbstractTween;
import com.jme3.anim.tween.ContainsTweens;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.util.Primitives;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tweens {
    private static final Logger log = Logger.getLogger(Tweens.class.getName());
    private static final CurveFunction SMOOTH = new SmoothStep();
    private static final CurveFunction SINE = new Sine();

    private Tweens() {
    }

    public static Tween sequence(Tween ... delegates) {
        return new Sequence(delegates);
    }

    public static Tween parallel(Tween ... delegates) {
        return new Parallel(delegates);
    }

    public static Tween delay(double length) {
        return new Delay(length);
    }

    public static Tween stretch(double desiredLength, Tween ... delegates) {
        if (delegates.length == 1) {
            return new Stretch(delegates[0], desiredLength);
        }
        return new Stretch(Tweens.sequence(delegates), desiredLength);
    }

    public static Tween sineStep(Tween ... delegates) {
        if (delegates.length == 1) {
            return new Curve(delegates[0], SINE);
        }
        return new Curve(Tweens.sequence(delegates), SINE);
    }

    public static Tween smoothStep(Tween ... delegates) {
        if (delegates.length == 1) {
            return new Curve(delegates[0], SMOOTH);
        }
        return new Curve(Tweens.sequence(delegates), SMOOTH);
    }

    public static Tween callMethod(Object target, String method, Object ... args2) {
        return new CallMethod(target, method, args2);
    }

    public static Tween callTweenMethod(double length, Object target, String method, Object ... args2) {
        return new CallTweenMethod(length, target, method, args2);
    }

    public static Tween loopCount(int count2, Tween ... delegates) {
        if (delegates.length == 1) {
            return new Loop(delegates[0], count2);
        }
        return new Loop(Tweens.sequence(delegates), count2);
    }

    public static Tween loopDuration(double duration, Tween ... delegates) {
        if (delegates.length == 1) {
            return new Loop(delegates[0], duration);
        }
        return new Loop(Tweens.sequence(delegates), duration);
    }

    public static Tween invert(Tween delegate2) {
        return new Invert(delegate2);
    }

    public static Tween cycle(Tween delegate2) {
        return Tweens.sequence(delegate2, Tweens.invert(delegate2));
    }

    private static class Sequence
    implements Tween,
    ContainsTweens {
        private final Tween[] delegates;
        private int current = 0;
        private double baseTime;
        private double length;

        public Sequence(Tween ... delegates) {
            this.delegates = delegates;
            for (Tween t : delegates) {
                this.length += t.getLength();
            }
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (t < this.baseTime) {
                this.current = 0;
                this.baseTime = 0.0;
            }
            if (this.current >= this.delegates.length) {
                return false;
            }
            while (!this.delegates[this.current].interpolate(t - this.baseTime)) {
                this.baseTime += this.delegates[this.current].getLength();
                ++this.current;
                if (this.current < this.delegates.length) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegates=" + Arrays.asList(this.delegates) + "]";
        }

        @Override
        public Tween[] getTweens() {
            return this.delegates;
        }
    }

    private static class Parallel
    implements Tween,
    ContainsTweens {
        private final Tween[] delegates;
        private final boolean[] done;
        private double length;
        private double lastTime;

        public Parallel(Tween ... delegates) {
            this.delegates = delegates;
            this.done = new boolean[delegates.length];
            for (Tween t : delegates) {
                if (!(t.getLength() > this.length)) continue;
                this.length = t.getLength();
            }
        }

        @Override
        public double getLength() {
            return this.length;
        }

        protected void reset() {
            for (int i = 0; i < this.done.length; ++i) {
                this.done[i] = false;
            }
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (t < this.lastTime) {
                this.reset();
            }
            this.lastTime = t;
            int runningCount = this.delegates.length;
            for (int i = 0; i < this.delegates.length; ++i) {
                if (!this.done[i]) {
                    boolean bl = this.done[i] = !this.delegates[i].interpolate(t);
                }
                if (!this.done[i]) continue;
                --runningCount;
            }
            return runningCount > 0;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegates=" + Arrays.asList(this.delegates) + "]";
        }

        @Override
        public Tween[] getTweens() {
            return this.delegates;
        }
    }

    private static class Delay
    extends AbstractTween {
        public Delay(double length) {
            super(length);
        }

        @Override
        protected void doInterpolate(double t) {
        }
    }

    private static class Stretch
    implements Tween,
    ContainsTweens {
        private final Tween[] delegate = new Tween[1];
        private final double length;
        private final double scale;

        public Stretch(Tween delegate2, double length) {
            this.delegate[0] = delegate2;
            this.length = length;
            this.scale = length != 0.0 ? delegate2.getLength() / length : 0.0;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public Tween[] getTweens() {
            return this.delegate;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            t = this.length > 0.0 ? (t *= this.scale) : this.length;
            return this.delegate[0].interpolate(t);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegate=" + this.delegate[0] + ", length=" + this.length + "]";
        }
    }

    private static class Curve
    implements Tween {
        private final Tween delegate;
        private final CurveFunction func;
        private final double length;

        public Curve(Tween delegate2, CurveFunction func) {
            this.delegate = delegate2;
            this.func = func;
            this.length = delegate2.getLength();
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (this.length == 0.0) {
                return this.delegate.interpolate(t);
            }
            t = this.func.curve(t / this.length);
            return this.delegate.interpolate(t * this.length);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegate=" + this.delegate + ", func=" + this.func + "]";
        }
    }

    private static interface CurveFunction {
        public double curve(double var1);
    }

    private static class CallMethod
    extends AbstractTween {
        private Object target;
        private Method method;
        private Object[] args;

        public CallMethod(Object target, String methodName, Object ... args2) {
            super(0.0);
            if (target == null) {
                throw new IllegalArgumentException("Target cannot be null.");
            }
            this.target = target;
            this.args = args2;
            this.method = args2 == null ? CallMethod.findMethod(target.getClass(), methodName, new Object[0]) : CallMethod.findMethod(target.getClass(), methodName, args2);
            if (this.method == null) {
                throw new IllegalArgumentException("Method not found for:" + methodName + " on type:" + target.getClass());
            }
            this.method.setAccessible(true);
        }

        private static Method findMethod(Class type2, String name, Object ... args2) {
            for (Method m : type2.getDeclaredMethods()) {
                Class<?>[] paramTypes;
                if (!Objects.equals(m.getName(), name) || (paramTypes = m.getParameterTypes()).length != args2.length) continue;
                int matches = 0;
                for (int i = 0; i < args2.length; ++i) {
                    if (!paramTypes[i].isInstance(args2[i]) && !Primitives.wrap(paramTypes[i]).isInstance(args2[i])) continue;
                    ++matches;
                }
                if (matches != args2.length) continue;
                return m;
            }
            if (type2.getSuperclass() != null) {
                return CallMethod.findMethod(type2.getSuperclass(), name, args2);
            }
            return null;
        }

        @Override
        protected void doInterpolate(double t) {
            try {
                this.method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error running method:" + this.method + " for object:" + this.target, e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[method=" + this.method + ", parms=" + Arrays.asList(this.args) + "]";
        }
    }

    private static class CallTweenMethod
    extends AbstractTween {
        private Object target;
        private Method method;
        private Object[] args;
        private int tIndex = -1;
        private boolean isFloat = false;

        public CallTweenMethod(double length, Object target, String methodName, Object ... args2) {
            super(length);
            if (target == null) {
                throw new IllegalArgumentException("Target cannot be null.");
            }
            this.target = target;
            this.method = this.findMethod(target.getClass(), methodName, args2);
            if (this.method == null) {
                throw new IllegalArgumentException("Method not found for:" + methodName + " on type:" + target.getClass());
            }
            this.method.setAccessible(true);
            this.args = new Object[args2.length + 1];
            if (this.tIndex == 0) {
                for (int i = 0; i < args2.length; ++i) {
                    this.args[i + 1] = args2[i];
                }
            } else {
                for (int i = 0; i < args2.length; ++i) {
                    this.args[i] = args2[i];
                }
            }
        }

        private static boolean isFloatType(Class type2) {
            return type2 == Float.TYPE || type2 == Float.class;
        }

        private static boolean isDoubleType(Class type2) {
            return type2 == Double.TYPE || type2 == Double.class;
        }

        private Method findMethod(Class type2, String name, Object ... args2) {
            for (Method m : type2.getDeclaredMethods()) {
                if (!Objects.equals(m.getName(), name)) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length != args2.length + 1) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Param lengths of [" + m + "] differ.  method arg count:" + paramTypes.length + "  looking for:" + (args2.length + 1));
                    continue;
                }
                if (CallTweenMethod.isFloatType(paramTypes[0]) || CallTweenMethod.isDoubleType(paramTypes[0])) {
                    int matches = 0;
                    for (int i = 1; i < paramTypes.length; ++i) {
                        if (!paramTypes[i].isInstance(args2[i - 1])) continue;
                        ++matches;
                    }
                    if (matches == args2.length) {
                        this.tIndex = 0;
                        this.isFloat = CallTweenMethod.isFloatType(paramTypes[0]);
                    } else if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, m + " Leading float check failed because of type mismatches, for:" + m);
                    }
                }
                if (this.tIndex >= 0) {
                    return m;
                }
                int last2 = paramTypes.length - 1;
                if (!CallTweenMethod.isFloatType(paramTypes[last2]) && !CallTweenMethod.isDoubleType(paramTypes[last2])) continue;
                int matches = 0;
                for (int i = 0; i < last2; ++i) {
                    if (!paramTypes[i].isInstance(args2[i])) continue;
                    ++matches;
                }
                if (matches == args2.length) {
                    this.tIndex = last2;
                    this.isFloat = CallTweenMethod.isFloatType(paramTypes[last2]);
                    return m;
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, "Trailing float check failed because of type mismatches, for:" + m);
            }
            if (type2.getSuperclass() != null) {
                return this.findMethod(type2.getSuperclass(), name, args2);
            }
            return null;
        }

        @Override
        protected void doInterpolate(double t) {
            try {
                this.args[this.tIndex] = this.isFloat ? (Number)Float.valueOf((float)t) : (Number)t;
                this.method.invoke(this.target, this.args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error running method:" + this.method + " for object:" + this.target, e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[method=" + this.method + ", parms=" + Arrays.asList(this.args) + "]";
        }
    }

    private static class Loop
    implements Tween,
    ContainsTweens {
        private final Tween[] delegate = new Tween[1];
        private final double length;
        private final int loopCount;
        private double baseTime;
        private int current = 0;

        public Loop(Tween delegate2, double duration) {
            if (delegate2.getLength() <= 0.0) {
                throw new IllegalArgumentException("Delegate length must be greater than 0");
            }
            if (duration <= 0.0) {
                throw new IllegalArgumentException("Duration must be greater than 0");
            }
            this.delegate[0] = delegate2;
            this.length = duration;
            this.loopCount = (int)Math.ceil(duration / delegate2.getLength());
        }

        public Loop(Tween delegate2, int count2) {
            if (count2 <= 0) {
                throw new IllegalArgumentException("Loop count must be greater than 0");
            }
            this.delegate[0] = delegate2;
            this.length = (double)count2 * delegate2.getLength();
            this.loopCount = count2;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public Tween[] getTweens() {
            return this.delegate;
        }

        @Override
        public boolean interpolate(double t) {
            if (t < 0.0) {
                return true;
            }
            if (t < this.baseTime) {
                this.current = 0;
                this.baseTime = 0.0;
            }
            if (this.current >= this.loopCount) {
                return false;
            }
            while (!this.delegate[0].interpolate(t - this.baseTime)) {
                this.baseTime += this.delegate[0].getLength();
                ++this.current;
                if (this.current < this.loopCount) continue;
                return false;
            }
            return t < this.length;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegate=" + this.delegate[0] + ", length=" + this.length + "]";
        }
    }

    private static class Invert
    extends AbstractTween
    implements ContainsTweens {
        private final Tween[] delegate = new Tween[1];

        public Invert(Tween delegate2) {
            super(delegate2.getLength());
            this.delegate[0] = delegate2;
        }

        @Override
        protected void doInterpolate(double t) {
            this.delegate[0].interpolate((1.0 - t) * this.getLength());
        }

        @Override
        public Tween[] getTweens() {
            return this.delegate;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[delegate=" + this.delegate[0] + ", length=" + this.getLength() + "]";
        }
    }

    private static class SmoothStep
    implements CurveFunction {
        private SmoothStep() {
        }

        @Override
        public double curve(double t) {
            if (t < 0.0) {
                return 0.0;
            }
            if (t > 1.0) {
                return 1.0;
            }
            return t * t * (3.0 - 2.0 * t);
        }
    }

    private static class Sine
    implements CurveFunction {
        private Sine() {
        }

        @Override
        public double curve(double t) {
            if (t < 0.0) {
                return 0.0;
            }
            if (t > 1.0) {
                return 1.0;
            }
            double result2 = Math.sin(t * Math.PI - 1.5707963267948966);
            return (result2 + 1.0) * 0.5;
        }
    }
}

