/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.renderer.Limits;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.mesh.MorphTarget;
import com.jme3.shader.VarType;
import com.jme3.util.BufferUtils;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MorphControl
extends AbstractControl
implements Savable {
    private static final Logger logger = Logger.getLogger(MorphControl.class.getName());
    private static final int MAX_MORPH_BUFFERS = 14;
    private static final float MIN_WEIGHT = 0.005f;
    private static final String TAG_APPROXIMATE = "approximateTangents";
    private static final String TAG_TARGETS = "targets";
    private SafeArrayList<Geometry> targets = new SafeArrayList<Geometry>(Geometry.class);
    private TargetLocator targetLocator = new TargetLocator();
    private boolean approximateTangents = true;
    private MatParamOverride nullNumberOfBones = new MatParamOverride(VarType.Int, "NumberOfBones", null);
    private float[] tmpPosArray;
    private float[] tmpNormArray;
    private float[] tmpTanArray;
    private static final VertexBuffer.Type[] bufferTypes = VertexBuffer.Type.values();

    @Override
    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        for (Geometry target : this.targets.getArray()) {
            target.removeMatParamOverride(this.nullNumberOfBones);
        }
        this.targets.clear();
        if (spatial != null) {
            spatial.depthFirstTraversal(this.targetLocator);
        }
    }

    @Override
    protected void controlUpdate(float tpf) {
    }

    @Override
    protected void controlRender(RenderManager rm, ViewPort vp) {
        for (Geometry geom : this.targets.getArray()) {
            int i;
            Mesh mesh = geom.getMesh();
            if (!geom.isDirtyMorph()) continue;
            Material m = geom.getMaterial();
            float[] weights = geom.getMorphState();
            MorphTarget[] morphTargets = mesh.getMorphTargets();
            int targetNumBuffers = this.getTargetNumBuffers(morphTargets[0]);
            int maxGPUTargets = this.getMaxGPUTargets(rm, geom, m, targetNumBuffers);
            MatParam param2 = m.getParam("MorphWeights");
            float[] matWeights = (float[])param2.getValue();
            int nbGPUTargets = 0;
            int lastGpuTargetIndex = 0;
            int boundBufferIdx = 0;
            float cpuWeightSum = 0.0f;
            for (i = 0; i < morphTargets.length; ++i) {
                if (weights[i] < 0.005f) continue;
                if (nbGPUTargets >= maxGPUTargets) {
                    cpuWeightSum += weights[i];
                    continue;
                }
                lastGpuTargetIndex = i;
                MorphTarget t = morphTargets[i];
                boundBufferIdx = this.bindMorphTargetBuffer(mesh, targetNumBuffers, boundBufferIdx, t);
                matWeights[nbGPUTargets] = weights[i];
                ++nbGPUTargets;
            }
            if (nbGPUTargets < matWeights.length) {
                for (i = nbGPUTargets; i < matWeights.length; ++i) {
                    matWeights[i] = 0.0f;
                }
            } else if (cpuWeightSum > 0.0f) {
                MorphTarget mt = geom.getFallbackMorphTarget();
                if (mt == null) {
                    mt = this.initCpuMorphTarget(geom);
                    geom.setFallbackMorphTarget(mt);
                }
                cpuWeightSum += matWeights[nbGPUTargets - 1];
                this.ensureTmpArraysCapacity(geom.getVertexCount() * 3, targetNumBuffers);
                for (int i2 = lastGpuTargetIndex; i2 < morphTargets.length; ++i2) {
                    if (weights[i2] < 0.005f) continue;
                    float weight = weights[i2] / cpuWeightSum;
                    MorphTarget t = geom.getMesh().getMorphTargets()[i2];
                    this.mergeMorphTargets(targetNumBuffers, weight, t, i2 == lastGpuTargetIndex);
                }
                this.writeCpuBuffer(targetNumBuffers, mt);
                this.bindMorphTargetBuffer(mesh, targetNumBuffers, (nbGPUTargets - 1) * targetNumBuffers, mt);
                matWeights[nbGPUTargets - 1] = cpuWeightSum;
            }
            geom.setDirtyMorph(false);
        }
    }

    private int getMaxGPUTargets(RenderManager rm, Geometry geom, Material mat, int targetNumBuffers) {
        if (geom.getNbSimultaneousGPUMorph() > -1) {
            return geom.getNbSimultaneousGPUMorph();
        }
        int nbMaxBuffers = this.getRemainingBuffers(geom.getMesh(), rm.getRenderer());
        int realNumTargetsBuffers = geom.getMesh().getMorphTargets().length * targetNumBuffers;
        int maxGPUTargets = Math.min(realNumTargetsBuffers, Math.min(nbMaxBuffers, 14)) / targetNumBuffers;
        MatParam param = mat.getParam("MorphWeights");
        if (param == null) {
            float[] wts = new float[maxGPUTargets];
            mat.setParam("MorphWeights", VarType.FloatArray, wts);
        }
        mat.setInt("NumberOfTargetsBuffers", targetNumBuffers);
        boolean compilationOk = false;
        while (!compilationOk && maxGPUTargets > 0) {
            mat.setInt("NumberOfMorphTargets", maxGPUTargets);
            try {
                rm.preloadScene(this.spatial);
                compilationOk = true;
            }
            catch (RendererException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "{0}: failed at {1}", new Object[]{geom.getName(), maxGPUTargets});
                }
                --maxGPUTargets;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "{0}: {1}", new Object[]{geom.getName(), maxGPUTargets});
        }
        geom.setNbSimultaneousGPUMorph(maxGPUTargets);
        return maxGPUTargets;
    }

    private int bindMorphTargetBuffer(Mesh mesh, int targetNumBuffers, int boundBufferIdx, MorphTarget t) {
        int start2 = VertexBuffer.Type.MorphTarget0.ordinal();
        if (targetNumBuffers >= 1) {
            this.activateBuffer(mesh, boundBufferIdx, start2, t.getBuffer(VertexBuffer.Type.Position));
            ++boundBufferIdx;
        }
        if (targetNumBuffers >= 2) {
            this.activateBuffer(mesh, boundBufferIdx, start2, t.getBuffer(VertexBuffer.Type.Normal));
            ++boundBufferIdx;
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            this.activateBuffer(mesh, boundBufferIdx, start2, t.getBuffer(VertexBuffer.Type.Tangent));
            ++boundBufferIdx;
        }
        return boundBufferIdx;
    }

    private void writeCpuBuffer(int targetNumBuffers, MorphTarget mt) {
        FloatBuffer dest;
        if (targetNumBuffers >= 1) {
            dest = mt.getBuffer(VertexBuffer.Type.Position);
            dest.rewind();
            dest.put(this.tmpPosArray, 0, dest.capacity());
        }
        if (targetNumBuffers >= 2) {
            dest = mt.getBuffer(VertexBuffer.Type.Normal);
            dest.rewind();
            dest.put(this.tmpNormArray, 0, dest.capacity());
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            dest = mt.getBuffer(VertexBuffer.Type.Tangent);
            dest.rewind();
            dest.put(this.tmpTanArray, 0, dest.capacity());
        }
    }

    private void mergeMorphTargets(int targetNumBuffers, float weight, MorphTarget t, boolean init2) {
        if (targetNumBuffers >= 1) {
            this.mergeTargetBuffer(this.tmpPosArray, weight, t.getBuffer(VertexBuffer.Type.Position), init2);
        }
        if (targetNumBuffers >= 2) {
            this.mergeTargetBuffer(this.tmpNormArray, weight, t.getBuffer(VertexBuffer.Type.Normal), init2);
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            this.mergeTargetBuffer(this.tmpTanArray, weight, t.getBuffer(VertexBuffer.Type.Tangent), init2);
        }
    }

    private void ensureTmpArraysCapacity(int capacity, int targetNumBuffers) {
        if (targetNumBuffers >= 1) {
            this.tmpPosArray = this.ensureCapacity(this.tmpPosArray, capacity);
        }
        if (targetNumBuffers >= 2) {
            this.tmpNormArray = this.ensureCapacity(this.tmpNormArray, capacity);
        }
        if (!this.approximateTangents && targetNumBuffers == 3) {
            this.tmpTanArray = this.ensureCapacity(this.tmpTanArray, capacity);
        }
    }

    private void mergeTargetBuffer(float[] array, float weight, FloatBuffer src, boolean init2) {
        src.rewind();
        int j = 0;
        while (j < src.capacity()) {
            if (init2) {
                array[j] = 0.0f;
            }
            int n = j++;
            array[n] = array[n] + weight * src.get();
        }
    }

    private void activateBuffer(Mesh mesh, int idx, int start2, FloatBuffer b) {
        VertexBuffer.Type t = bufferTypes[start2 + idx];
        VertexBuffer vb = mesh.getBuffer(t);
        if (vb == null || vb.getData() != b) {
            mesh.setBuffer(t, 3, b);
        }
    }

    private float[] ensureCapacity(float[] tmpArray, int size2) {
        if (tmpArray == null || tmpArray.length < size2) {
            return new float[size2];
        }
        return tmpArray;
    }

    private MorphTarget initCpuMorphTarget(Geometry geom) {
        MorphTarget res = new MorphTarget();
        MorphTarget mt = geom.getMesh().getMorphTargets()[0];
        FloatBuffer b = mt.getBuffer(VertexBuffer.Type.Position);
        if (b != null) {
            res.setBuffer(VertexBuffer.Type.Position, BufferUtils.createFloatBuffer(b.capacity()));
        }
        if ((b = mt.getBuffer(VertexBuffer.Type.Normal)) != null) {
            res.setBuffer(VertexBuffer.Type.Normal, BufferUtils.createFloatBuffer(b.capacity()));
        }
        if (!this.approximateTangents && (b = mt.getBuffer(VertexBuffer.Type.Tangent)) != null) {
            res.setBuffer(VertexBuffer.Type.Tangent, BufferUtils.createFloatBuffer(b.capacity()));
        }
        return res;
    }

    private int getTargetNumBuffers(MorphTarget morphTarget) {
        int num = 0;
        if (morphTarget.getBuffer(VertexBuffer.Type.Position) != null) {
            ++num;
        }
        if (morphTarget.getBuffer(VertexBuffer.Type.Normal) != null) {
            ++num;
        }
        if (!this.approximateTangents && morphTarget.getBuffer(VertexBuffer.Type.Tangent) != null) {
            ++num;
        }
        return num;
    }

    private int getRemainingBuffers(Mesh mesh, Renderer renderer) {
        int nbUsedBuffers = 0;
        for (VertexBuffer vb : mesh.getBufferList().getArray()) {
            boolean isMorphBuffer;
            boolean bl = isMorphBuffer = vb.getBufferType().ordinal() >= VertexBuffer.Type.MorphTarget0.ordinal() && vb.getBufferType().ordinal() <= VertexBuffer.Type.MorphTarget9.ordinal();
            if (vb.getBufferType() == VertexBuffer.Type.Index || isMorphBuffer || vb.getUsage() == VertexBuffer.Usage.CpuOnly) continue;
            ++nbUsedBuffers;
        }
        return renderer.getLimits().get((Object)Limits.VertexAttributes) - nbUsedBuffers;
    }

    public void setApproximateTangents(boolean approximateTangents) {
        this.approximateTangents = approximateTangents;
    }

    public boolean isApproximateTangents() {
        return this.approximateTangents;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.targets = cloner.clone(this.targets);
        this.targetLocator = new TargetLocator();
        this.nullNumberOfBones = cloner.clone(this.nullNumberOfBones);
        this.tmpPosArray = null;
        this.tmpNormArray = null;
        this.tmpTanArray = null;
    }

    @Override
    public MorphControl jmeClone() {
        try {
            MorphControl clone2 = (MorphControl)super.clone();
            return clone2;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.approximateTangents = capsule.readBoolean(TAG_APPROXIMATE, true);
        this.targets.addAll(capsule.readSavableArrayList(TAG_TARGETS, null));
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule(this);
        capsule.write(this.approximateTangents, TAG_APPROXIMATE, true);
        capsule.writeSavableArrayList(new ArrayList<Geometry>(this.targets), TAG_TARGETS, null);
    }

    private class TargetLocator
    extends SceneGraphVisitorAdapter {
        private TargetLocator() {
        }

        @Override
        public void visit(Geometry geom) {
            MatParam p = geom.getMaterial().getMaterialDef().getMaterialParam("MorphWeights");
            if (p == null) {
                return;
            }
            Mesh mesh = geom.getMesh();
            if (mesh != null && mesh.hasMorphTargets()) {
                MorphControl.this.targets.add(geom);
                if (mesh.getBuffer(VertexBuffer.Type.HWBoneIndex) == null && !geom.getLocalMatParamOverrides().contains(MorphControl.this.nullNumberOfBones)) {
                    geom.addMatParamOverride(MorphControl.this.nullNumberOfBones);
                }
            }
        }
    }
}

