/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimationMask;
import com.jme3.anim.tween.action.Action;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;

public class AnimLayer
implements JmeCloneable {
    private Action currentAction;
    private String currentActionName;
    private AnimComposer composer;
    private final AnimationMask mask;
    private double time;
    private Object manager;
    private final String name;
    private boolean loop = true;

    AnimLayer(AnimComposer composer, String name, AnimationMask mask) {
        assert (composer != null);
        this.composer = composer;
        assert (name != null);
        this.name = name;
        this.mask = mask;
    }

    public Action getCurrentAction() {
        return this.currentAction;
    }

    public String getCurrentActionName() {
        return this.currentActionName;
    }

    public Object getManager() {
        return this.manager;
    }

    public AnimationMask getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public double getTime() {
        return this.time;
    }

    public void setCurrentAction(Action actionToRun) {
        this.setCurrentAction(null, actionToRun);
    }

    public void setCurrentAction(String actionName, Action actionToRun) {
        this.setCurrentAction(actionName, actionToRun, true);
    }

    public void setCurrentAction(String actionName, Action actionToRun, boolean loop) {
        this.time = 0.0;
        this.currentAction = actionToRun;
        this.currentActionName = actionName;
        this.loop = loop;
    }

    public void setManager(Object manager) {
        this.manager = manager;
    }

    public void setTime(double animationTime) {
        double length = this.currentAction.getLength();
        this.time = animationTime >= 0.0 ? animationTime % length : animationTime % length + length;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public void setLooping(boolean loop) {
        this.loop = loop;
    }

    void update(float appDeltaTimeInSeconds) {
        Action action = this.currentAction;
        if (action == null) {
            return;
        }
        double speedup = action.getSpeed() * (double)this.composer.getGlobalSpeed();
        double scaledDeltaTime = speedup * (double)appDeltaTimeInSeconds;
        this.time += scaledDeltaTime;
        if (this.time < 0.0) {
            double length = action.getLength();
            this.time = (this.time % length + length) % length;
        }
        action.setMask(this.mask);
        boolean running = action.interpolate(this.time);
        action.setMask(null);
        if (!running) {
            this.time = 0.0;
            if (!this.loop) {
                this.setCurrentAction(null);
            }
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.composer = cloner.clone(this.composer);
        this.currentAction = null;
        this.currentActionName = null;
    }

    @Override
    public Object jmeClone() {
        try {
            AnimLayer clone2 = (AnimLayer)super.clone();
            return clone2;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError();
        }
    }
}

