/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.ejt.internal.gui.HiDPIUtil;
import com.install4j.api.UiUtil;
import com.install4j.runtime.util.IconHelper;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiIcon
implements Icon {
    private static final ImageIconLoader URL_LOADER = fileName -> {
        URL iconUrl = IconHelper.getIconUrl(fileName);
        if (iconUrl != null) {
            return new ImageIcon(iconUrl);
        }
        return null;
    };
    private static final ImageIconLoader FILE_LOADER = filename -> {
        if (new File(filename).exists()) {
            return new ImageIcon(filename);
        }
        return null;
    };
    @NotNull
    private ImageIcon lowResLightIcon;
    @Nullable
    private ImageIcon highResLightIcon;
    @Nullable
    private ImageIcon lowResDarkIcon;
    @Nullable
    private ImageIcon highResDarkIcon;

    public MultiIcon(String fileName) {
        this.loadUrl(fileName);
    }

    public MultiIcon(File file) {
        String path = file.getPath();
        if (path.startsWith("icon:")) {
            this.loadUrl(path);
        } else {
            this.load(path, FILE_LOADER);
        }
    }

    private void loadUrl(String fileName) {
        this.load(fileName, URL_LOADER);
        if (this.lowResDarkIcon == null) {
            this.lowResDarkIcon = IconHelper.darkenIcon(this.lowResLightIcon);
        }
        if (this.highResLightIcon != null && this.highResDarkIcon == null) {
            this.highResDarkIcon = IconHelper.darkenIcon(this.highResLightIcon);
        }
    }

    private void load(String fileName, ImageIconLoader loader) {
        this.lowResLightIcon = this.loadNonNullIcon(fileName, loader);
        this.lowResDarkIcon = loader.loadIcon(IconHelper.toDarkFileName(fileName));
        String highResFileName = IconHelper.toHighResFileName(fileName);
        this.highResLightIcon = loader.loadIcon(highResFileName);
        this.highResDarkIcon = loader.loadIcon(IconHelper.toDarkFileName(highResFileName));
    }

    @NotNull
    private ImageIcon loadNonNullIcon(String fileName, ImageIconLoader loader) {
        ImageIcon icon = loader.loadIcon(fileName);
        if (icon == null) {
            throw new RuntimeException("Icon " + fileName + " could not be loaded");
        }
        return icon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x2, int y2) {
        boolean hiDPI = HiDPIUtil.isHiDPI((Graphics2D)g);
        ImageIcon icon = this.resolveEnabledOrDisabledIcon(hiDPI, c);
        if (hiDPI && (icon == this.highResLightIcon || icon == this.highResDarkIcon)) {
            HiDPIUtil.paintScaledIcon(icon.getImage(), icon.getImageObserver(), c, g, x2, y2);
        } else {
            icon.paintIcon(c, g, x2, y2);
        }
    }

    @Override
    public int getIconWidth() {
        return this.lowResLightIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.lowResLightIcon.getIconHeight();
    }

    private ImageIcon resolveEnabledOrDisabledIcon(boolean hiDPI, Component c) {
        Icon disabledIcon;
        ImageIcon icon = this.resolveIcon(hiDPI);
        if (!c.isEnabled() && (disabledIcon = UIManager.getLookAndFeel().getDisabledIcon((JComponent)c, icon)) instanceof ImageIcon) {
            return (ImageIcon)disabledIcon;
        }
        return icon;
    }

    private ImageIcon resolveIcon(boolean hiDPI) {
        boolean dark = UiUtil.isDarkUi();
        if (hiDPI) {
            if (dark) {
                return IconHelper.coalesce(this.highResDarkIcon, this.lowResDarkIcon, this.highResLightIcon, this.lowResLightIcon);
            }
            return IconHelper.coalesce(this.highResLightIcon, this.lowResLightIcon);
        }
        if (dark) {
            return IconHelper.coalesce(this.lowResDarkIcon, this.lowResLightIcon);
        }
        return this.lowResLightIcon;
    }

    public Image getImage() {
        return this.lowResLightIcon.getImage();
    }

    private static interface ImageIconLoader {
        @Nullable
        public ImageIcon loadIcon(String var1);
    }
}

