/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class HtmlTextHelper {
    public static String formatTextWithoutHtmlTags(String s) {
        if (s == null) {
            return null;
        }
        if (s.contains("<html")) {
            return HtmlTextHelper.convertHtmlToText(s);
        }
        return s;
    }

    private static String convertHtmlToText(String html) {
        final StringBuffer textBuffer = new StringBuffer();
        final Stack tagStack = new Stack();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
                if (tag.equals(HTML.Tag.TITLE)) {
                    tagStack.push(new IndentedTag(tag, 0));
                } else if (HtmlTextHelper.isTagNeedsNewlineBefore(tag)) {
                    if (textBuffer.length() > 0 && textBuffer.charAt(textBuffer.length() - 1) != '\n') {
                        this.newLine();
                    }
                    this.newLine();
                } else if (tag.equals(HTML.Tag.DL) || tag.equals(HTML.Tag.DT)) {
                    this.newLine();
                } else if (tag.equals(HTML.Tag.OL) || tag.equals(HTML.Tag.UL) || tag.equals(HTML.Tag.BLOCKQUOTE) || tag.equals(HTML.Tag.DD)) {
                    tagStack.push(new IndentedTag(tag));
                    this.newLine();
                } else if (tag.equals(HTML.Tag.LI)) {
                    IndentedTag parent2 = (IndentedTag)tagStack.peek();
                    if (parent2.getTag().equals(HTML.Tag.OL)) {
                        String order = parent2.nextOrder() + ".";
                        textBuffer.append(order);
                        for (int i = 0; i < 3 - order.length(); ++i) {
                            textBuffer.append("\u00a0");
                        }
                    } else {
                        textBuffer.append("*\u00a0\u00a0");
                    }
                    tagStack.push(new IndentedTag(tag));
                }
            }

            private void newLine() {
                textBuffer.append('\n');
                for (IndentedTag indentedTag : tagStack) {
                    for (int j = 0; j < indentedTag.getIndentation(); ++j) {
                        textBuffer.append("\u00a0");
                    }
                }
            }

            @Override
            public void handleEndTag(HTML.Tag tag, int pos) {
                if (HtmlTextHelper.isTagNeedsNewlineBefore(tag)) {
                    this.newLine();
                }
                if (tag.equals(HTML.Tag.TD)) {
                    textBuffer.append("\u00a0");
                } else if (tag.equals(HTML.Tag.OL) || tag.equals(HTML.Tag.UL) || tag.equals(HTML.Tag.LI) || tag.equals(HTML.Tag.BLOCKQUOTE)) {
                    tagStack.pop();
                    this.newLine();
                } else if (tag.equals(HTML.Tag.DD) || tag.equals(HTML.Tag.TITLE)) {
                    tagStack.pop();
                }
            }

            @Override
            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet a, int pos) {
                if (tag.equals(HTML.Tag.BR)) {
                    this.newLine();
                }
            }

            @Override
            public void handleText(char[] text2, int pos) {
                if (tagStack.size() == 0 || ((IndentedTag)tagStack.peek()).getTag() != HTML.Tag.TITLE) {
                    textBuffer.append(text2);
                }
            }
        };
        StringReader in = new StringReader(html);
        ParserDelegator delegator = new ParserDelegator();
        try {
            delegator.parse(in, parserCallback, true);
            return textBuffer.toString();
        }
        catch (IOException ex) {
            return html;
        }
    }

    private static boolean isTagNeedsNewlineBefore(HTML.Tag tag) {
        return tag.equals(HTML.Tag.P) || tag.equals(HTML.Tag.H1) || tag.equals(HTML.Tag.H2) || tag.equals(HTML.Tag.H3) || tag.equals(HTML.Tag.H4) || tag.equals(HTML.Tag.H5) || tag.equals(HTML.Tag.H6) || tag.equals(HTML.Tag.TH) || tag.equals(HTML.Tag.TR);
    }

    private static class IndentedTag {
        private HTML.Tag tag;
        private int indentation;
        private int order;

        public IndentedTag(HTML.Tag tag) {
            this.tag = tag;
            this.order = 0;
        }

        public IndentedTag(HTML.Tag tag, int indentation) {
            this.tag = tag;
            this.indentation = indentation;
            this.order = 0;
        }

        public int nextOrder() {
            return ++this.order;
        }

        public HTML.Tag getTag() {
            return this.tag;
        }

        public int getIndentation() {
            return this.indentation;
        }
    }
}

