/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlDisplayTextArea
extends JTextPane {
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public HtmlDisplayTextArea() {
        this.setEditable(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.setRequestFocusEnabled(false);
        this.setMargin(NO_MARGIN);
        this.setEditorKit(new HTMLEditorKit());
        this.updateUI();
        this.setOpaque(false);
        this.setFocusable(false);
    }

    @Override
    public void setText(String text2) {
        text2 = InstallerUtil.sanitizeHTML(text2);
        super.setText(text2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            StyleSheet css = ((HTMLDocument)document).getStyleSheet();
            Font font = UIManager.getFont("Label.font");
            css.addRule("body {color : #" + GUIHelper.getHexValue(UIManager.getColor("Label.foreground")) + " }");
            css.addRule("body {font-size : " + font.getSize() + "pt; }");
            css.addRule("body {font-family :" + font.getFontName() + "; }");
        }
    }
}

