/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.util.ExtendedResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileResourceBundle
extends ResourceBundle
implements ExtendedResourceBundle {
    private LinkedHashMap<String, String> properties = new LinkedHashMap();

    public FileResourceBundle(File file, ResourceBundle parent2) throws IOException {
        this(new FileInputStream(file), parent2);
    }

    public FileResourceBundle(InputStream input, ResourceBundle parent2) throws IOException {
        String line;
        this.setParent(parent2);
        BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            int index2;
            if (line.trim().startsWith("#") || (index2 = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, index2);
            if (key.charAt(0) == '\ufeff') {
                key = key.substring(1);
            }
            String value = line.substring(index2 + 1);
            value = this.replaceLineBreaks(value);
            this.properties.put(key, value);
        }
        input.close();
    }

    @Override
    public boolean containsKeyDirectly(@NotNull String key) {
        boolean contained = this.properties.containsKey(key);
        if (!contained && key.startsWith(".")) {
            return this.properties.containsKey(key.substring(1));
        }
        return contained;
    }

    public LinkedHashMap<String, String> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        Set<String> keySet = this.properties.keySet();
        if (this.parent != null) {
            keySet = new LinkedHashSet<String>(keySet);
            Enumeration<String> en = this.parent.getKeys();
            while (en.hasMoreElements()) {
                keySet.add(en.nextElement());
            }
        }
        return Collections.enumeration(keySet);
    }

    @Override
    protected Object handleGetObject(@NotNull String key) {
        if (key.startsWith(".")) {
            String keyWithoutLeadingDot = key.substring(1);
            if (!this.properties.containsKey(key) && this.properties.containsKey(keyWithoutLeadingDot)) {
                return this.properties.get(keyWithoutLeadingDot);
            }
        }
        return this.properties.get(key);
    }

    private String replaceLineBreaks(String string) {
        int index2;
        while ((index2 = string.indexOf("\\n")) > -1) {
            string = string.substring(0, index2) + "\n" + string.substring(index2 + 2);
        }
        while ((index2 = string.indexOf("\u00a5n")) > -1) {
            string = string.substring(0, index2) + "\n" + string.substring(index2 + 2);
        }
        return string;
    }
}

