/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.ejt.internal.gui.LookAndFeelChangeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CustomCardLayout
extends CardLayout {
    private List<JComponent> components = new ArrayList<JComponent>();

    public CustomCardLayout() {
        LookAndFeelChangeUtil.onLookAndFeelChange(this, CustomCardLayout::updateComponentUIs);
    }

    private void updateComponentUIs() {
        for (JComponent component : this.components) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        super.addLayoutComponent(component, constraints);
        if (component instanceof JComponent) {
            this.components.add((JComponent)component);
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        super.removeLayoutComponent(component);
        if (component instanceof JComponent) {
            this.components.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent2) {
        Object object = parent2.getTreeLock();
        synchronized (object) {
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = parent2.getInsets();
            int componentCount = parent2.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component component = parent2.getComponent(i);
                component.setBounds(hgap + insets.left, vgap + insets.top, parent2.getWidth() - (hgap * 2 + insets.left + insets.right), parent2.getHeight() - (vgap * 2 + insets.top + insets.bottom));
            }
            super.layoutContainer(parent2);
        }
    }
}

