/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class BinaryUtil {
    public static short swap(short x2) {
        return (short)(x2 << 8 | x2 >> 8 & 0xFF);
    }

    public static int swap(int x2) {
        return BinaryUtil.swap((short)x2) << 16 | BinaryUtil.swap((short)(x2 >> 16)) & 0xFFFF;
    }

    public static long align(long val, long alignment) {
        return (val / alignment + (long)(val % alignment > 0L ? 1 : 0)) * alignment;
    }

    public static void writeFully(WritableByteChannel channel, ByteBuffer data2) throws IOException {
        while (data2.position() < data2.limit()) {
            channel.write(data2);
        }
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer data2) throws IOException {
        while (data2.position() < data2.limit()) {
            if (channel.read(data2) != -1) continue;
            throw new EOFException();
        }
    }

    public static ByteBuffer readToBuffer(File file) throws IOException {
        ByteBuffer ret = ByteBuffer.allocate((int)file.length());
        FileInputStream in = new FileInputStream(file);
        FileChannel channel = in.getChannel();
        BinaryUtil.readFully(channel, ret);
        channel.close();
        in.close();
        return (ByteBuffer)ret.position(0);
    }
}

