/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration.gui;

import com.install4j.runtime.launcher.integration.gui.WindowChecker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class SwtWindowChecker
extends WindowChecker {
    private ThreadGroup rootThreadGroup = SwtWindowChecker.currentThread().getThreadGroup().getParent();

    public SwtWindowChecker(Runnable runnable, boolean adjustLaf) {
        super(runnable, adjustLaf);
        while (this.rootThreadGroup.getParent() != null) {
            this.rootThreadGroup = this.rootThreadGroup.getParent();
        }
    }

    @Override
    protected boolean checkExecute() {
        return this.checkThreads(this.rootThreadGroup, 0);
    }

    public boolean checkThreads(ThreadGroup threadGroup, int level) {
        int threadCount = threadGroup.activeCount();
        Thread[] threads = new Thread[2 * threadCount];
        threadCount = threadGroup.enumerate(threads, false);
        for (int i = 0; i < threadCount; ++i) {
            Thread thread2 = threads[i];
            if (!this.checkThread(thread2)) continue;
            return true;
        }
        int groupCount = threadGroup.activeGroupCount();
        ThreadGroup[] groups2 = new ThreadGroup[2 * groupCount];
        groupCount = threadGroup.enumerate(groups2, false);
        for (int i = 0; i < groupCount; ++i) {
            try {
                if (!this.checkThreads(groups2[i], level + 1)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean checkThread(Thread thread2) {
        Display display = Display.findDisplay((Thread)thread2);
        if (display != null) {
            boolean[] result2 = new boolean[1];
            display.syncExec(() -> {
                Shell[] shells;
                for (Shell shell : shells = display.getShells()) {
                    if (!shell.isVisible()) continue;
                    result2[0] = true;
                    return;
                }
            });
            return result2[0];
        }
        return false;
    }
}

