/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateConfig;
import java.io.File;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class UpdateLog {
    private static final String PROPNAME_UPDATE_LOG = "install4j.updateLog";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String LAUNCHER_ID = System.getProperty("install4j.launcherId");
    private static final int MAXIMUM_RETAINED_BYTES = 40000;
    private static long pid = -1L;
    private static volatile String applicationName;
    private static volatile boolean updaterApplication;

    private static synchronized void writeString(String message) {
        block11: {
            File logFile = new File(AutomaticUpdate.getUpdateDir(), "update.log");
            logFile.getParentFile().mkdirs();
            try (RandomAccessFile raFile = new RandomAccessFile(logFile, "rw");){
                if (!UpdateConfig.tryLock(raFile.getChannel(), 40)) break block11;
                long length = raFile.length();
                try {
                    if (length > 200000L) {
                        int firstLineFeed;
                        raFile.seek(length - 40000L);
                        byte[] buffer = new byte[40000];
                        raFile.readFully(buffer);
                        for (firstLineFeed = 0; firstLineFeed < 40000 && buffer[firstLineFeed] != 10; ++firstLineFeed) {
                        }
                        raFile.seek(0L);
                        length = 40000 - firstLineFeed - 1;
                        raFile.write(buffer, firstLineFeed + 1, (int)length);
                        raFile.setLength(length);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                raFile.seek(length);
                raFile.write((message + System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean enabled(int level) {
        String value = System.getProperty(PROPNAME_UPDATE_LOG, "");
        if (value.equals("true")) {
            return level <= 2;
        }
        if (value.length() > 0 && Character.isDigit(value.charAt(0))) {
            try {
                return level <= Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void logIfUpdater(int level, String message) {
        if (updaterApplication) {
            UpdateLog.log(level, message);
        }
    }

    public static synchronized void log(int level, String message) {
        if (UpdateLog.enabled(level)) {
            if (pid == -1L) {
                pid = VersionSpecificHelper.getPid();
            }
            StringBuilder builder = new StringBuilder(DATE_FORMAT.format(new Date()));
            builder.append(" (PID ").append(pid);
            if (LAUNCHER_ID != null) {
                builder.append(", Launcher ID ").append(LAUNCHER_ID);
            }
            if (applicationName != null) {
                builder.append(", ").append(applicationName);
            } else {
                String currentApplicationId = InstallerConfig.getCurrentApplicationId();
                if (currentApplicationId != null) {
                    builder.append(", App ID ").append(currentApplicationId);
                }
            }
            builder.append("): ").append(message);
            UpdateLog.writeString(builder.toString());
        }
    }

    public static void logIfUpdater(int level, Throwable throwable) {
        if (updaterApplication) {
            UpdateLog.log(level, throwable);
        }
    }

    public static void logIfUpdater(Throwable throwable) {
        if (updaterApplication) {
            UpdateLog.log(throwable);
        }
    }

    public static void log(Throwable throwable) {
        UpdateLog.log(1, throwable);
    }

    public static void log(int level, Throwable throwable) {
        if (UpdateLog.enabled(level)) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter pw = new PrintWriter(stringWriter){

                @Override
                public void println() {
                    super.println();
                    super.write("        ");
                }
            };
            throwable.printStackTrace(pw);
            UpdateLog.log(1, stringWriter.toString());
        }
    }

    public static void addUpdateLogProperty(List<String> arguments2) {
        String updateLogValue = System.getProperty(PROPNAME_UPDATE_LOG);
        if (updateLogValue != null) {
            arguments2.add("-Dinstall4j.updateLog=" + updateLogValue);
        }
    }

    public static void setApplicationName(String applicationName) {
        UpdateLog.applicationName = applicationName;
    }

    public static boolean setUpdaterApplication(boolean updaterApplication) {
        boolean changed = UpdateLog.updaterApplication != updaterApplication;
        UpdateLog.updaterApplication = updaterApplication;
        return changed;
    }
}

